/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core;

import com.bc.ceres.core.DefaultResourceLocator;
import java.nio.file.Path;
import java.util.Collection;
import java.util.ServiceLoader;

public abstract class ResourceLocator {
    public static Collection<Path> getResources(String name) {
        ServiceLoader<ResourceLocator> providers = ServiceLoader.load(ResourceLocator.class);
        ResourceLocator resourceLocator = null;
        for (ResourceLocator provider : providers) {
            if (!provider.getClass().equals(DefaultResourceLocator.class)) {
                resourceLocator = provider;
                break;
            }
            if (resourceLocator != null) continue;
            resourceLocator = provider;
        }
        if (resourceLocator == null) {
            resourceLocator = new DefaultResourceLocator();
        }
        return resourceLocator.locateResources(name);
    }

    public abstract Collection<Path> locateResources(String var1);
}

