/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import java.io.File;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.envisat.HeaderEntryNotFoundException;
import org.esa.snap.dataio.envisat.HeaderParseException;
import org.esa.snap.dataio.envisat.ProductFile;

public class AatsrAuxProductFile
extends ProductFile {
    private static final String PARSE_SPH_ERR_MSG = "Failed to parse main header parameter '%s': %s";

    public AatsrAuxProductFile(File file, ImageInputStream dataInputStream) throws IOException {
        super(file, dataInputStream);
    }

    @Override
    public ProductData.UTC getSceneRasterStartTime() {
        try {
            return this.getMPH().getParamUTC("SENSING_START");
        }
        catch (HeaderEntryNotFoundException | HeaderParseException e) {
            this.getLogger().warning(String.format(PARSE_SPH_ERR_MSG, "SENSING_START", ((Throwable)e).getMessage()));
            return null;
        }
    }

    @Override
    public ProductData.UTC getSceneRasterStopTime() {
        try {
            return this.getMPH().getParamUTC("SENSING_STOP");
        }
        catch (HeaderEntryNotFoundException | HeaderParseException e) {
            this.getLogger().warning(String.format(PARSE_SPH_ERR_MSG, "SENSING_STOP", ((Throwable)e).getMessage()));
            return null;
        }
    }

    @Override
    public int getSceneRasterWidth() {
        return 0;
    }

    @Override
    public int getSceneRasterHeight() {
        return 0;
    }

    @Override
    public float getTiePointGridOffsetX(int gridWidth) {
        return 0.0f;
    }

    @Override
    public float getTiePointGridOffsetY(int gridWidth) {
        return 0.0f;
    }

    @Override
    public float getTiePointSubSamplingX(int gridWidth) {
        return 1.0f;
    }

    @Override
    public float getTiePointSubSamplingY(int gridWidth) {
        return 1.0f;
    }

    @Override
    public boolean storesPixelsInChronologicalOrder() {
        return true;
    }

    @Override
    public Mask[] createDefaultMasks(String flagDsName) {
        return new Mask[0];
    }

    @Override
    void setInvalidPixelExpression(Band band) {
    }

    @Override
    public String getGADSName() {
        return null;
    }

    @Override
    public float[] getSpectralBandWavelengths() {
        return new float[0];
    }

    @Override
    public float[] getSpectralBandBandwidths() {
        return new float[0];
    }

    @Override
    public float[] getSpectralBandSolarFluxes() {
        return new float[0];
    }
}

