/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.raster.gpf.masks;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.image.VirtualBandOpImage;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.dem.dataio.DEMFactory;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileGeoreferencing;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="Land-Sea-Mask", category="Raster/Masks", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Creates a bitmask defining land vs ocean.")
public class CreateLandMaskOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct = null;
    @Parameter(description="The list of source bands.", alias="sourceBands", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames = null;
    @Parameter(label="Mask the Land", defaultValue="true")
    private Boolean landMask = true;
    @Parameter(label="Use SRTM 3sec", defaultValue="true")
    private Boolean useSRTM = true;
    @Parameter(label="Vector")
    private String geometry = "";
    @Parameter(label="Invert Vector", defaultValue="false")
    private Boolean invertGeometry = false;
    @Parameter(label="Extend shoreline by this many pixels", defaultValue="0")
    private Integer shorelineExtension = 0;
    private ElevationModel dem = null;
    private static final int landThreshold = -10;
    private static final int seaThreshold = -10;

    public void initialize() throws OperatorException {
        try {
            this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
            ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
            this.addSelectedBands();
            if (this.shorelineExtension == null) {
                this.shorelineExtension = 0;
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void addSelectedBands() throws OperatorException {
        Band[] sourceBands;
        boolean copyVirtualBands = false;
        if (this.sourceBandNames == null || this.sourceBandNames.length == 0) {
            copyVirtualBands = true;
            Band[] bands = this.sourceProduct.getBands();
            String[] bandNameList = new ArrayList(this.sourceProduct.getNumBands());
            Band[] bandArray = bands;
            int n = bandArray.length;
            for (int i = 0; i < n; ++i) {
                Band band = bandArray[i];
                if (this.targetProduct.containsBand(band.getName())) continue;
                bandNameList.add(band.getName());
            }
            this.sourceBandNames = bandNameList.toArray(new String[bandNameList.size()]);
        }
        ArrayList<Band> sourceBandList = new ArrayList<Band>(this.sourceBandNames.length);
        for (String sourceBandName : this.sourceBandNames) {
            Band sourceBand = this.sourceProduct.getBand(sourceBandName);
            if (sourceBand == null) continue;
            sourceBandList.add(sourceBand);
        }
        for (Band srcBand : sourceBands = sourceBandList.toArray(new Band[sourceBandList.size()])) {
            if (srcBand instanceof VirtualBand && copyVirtualBands) {
                ProductUtils.copyVirtualBand((Product)this.targetProduct, (VirtualBand)((VirtualBand)srcBand), (String)srcBand.getName());
                continue;
            }
            if (this.geometry != null && !this.geometry.isEmpty()) {
                String expression = this.geometry + " ? " + srcBand.getName() + ".raw : " + srcBand.getNoDataValue();
                if (this.invertGeometry.booleanValue()) {
                    expression = '!' + expression;
                }
                Band targetBand = ProductUtils.copyBand((String)srcBand.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
                VirtualBandOpImage.Builder builder = VirtualBandOpImage.builder((String)expression, (Product)this.sourceProduct).dataType(srcBand.getDataType()).sourceSize(new Dimension(srcBand.getRasterWidth(), srcBand.getRasterHeight()));
                VirtualBandOpImage virtualBandImage = builder.create();
                targetBand.setSourceImage((RenderedImage)virtualBandImage);
                continue;
            }
            ProductUtils.copyBand((String)srcBand.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
        }
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            if (this.dem == null) {
                this.createDEM();
            }
            TileData[] trgTiles = this.getTargetTiles(targetTiles, targetRectangle, this.sourceProduct);
            Tile targetTile = trgTiles[0].targetTile;
            int minX = targetRectangle.x;
            int minY = targetRectangle.y;
            int maxX = targetRectangle.x + targetRectangle.width;
            int maxY = targetRectangle.y + targetRectangle.height;
            TileIndex srcTileIndex = new TileIndex(trgTiles[0].srcTile);
            TileIndex trgTileIndex = new TileIndex(trgTiles[0].targetTile);
            TileGeoreferencing tileGeoRef = new TileGeoreferencing(this.targetProduct, minX, minY, maxX - minX, maxY - minY);
            double demNoDataValue = this.dem.getDescriptor().getNoDataValue();
            double[][] localDEM = new double[maxY - minY + 2][maxX - minX + 2];
            DEMFactory.getLocalDEM((ElevationModel)this.dem, (double)demNoDataValue, null, (TileGeoreferencing)tileGeoRef, (int)minX, (int)minY, (int)(maxX - minX), (int)(maxY - minY), null, (boolean)true, (double[][])localDEM);
            for (int y = minY; y < maxY; ++y) {
                srcTileIndex.calculateStride(y);
                trgTileIndex.calculateStride(y);
                int yy = y - minY;
                int eMinY = Math.max(minY, y - this.shorelineExtension);
                int eMaxY = Math.min(maxY, y + this.shorelineExtension);
                for (int x = minX; x < maxX; ++x) {
                    boolean valid;
                    int trgIndex = trgTileIndex.getIndex(x);
                    Double elev = localDEM[yy][x - minX];
                    if (this.landMask.booleanValue()) {
                        valid = this.useSRTM.booleanValue() ? elev.equals(demNoDataValue) : elev < -10.0;
                    } else if (this.useSRTM.booleanValue()) {
                        valid = !elev.equals(demNoDataValue);
                    } else {
                        boolean bl = valid = elev > -10.0;
                    }
                    if (valid) {
                        int srcIndex = srcTileIndex.getIndex(x);
                        TileData[] tileDataArray = trgTiles;
                        int n = tileDataArray.length;
                        for (int i = 0; i < n; ++i) {
                            TileData tileData = tileDataArray[i];
                            if (tileData.isInt) {
                                tileData.tileDataBuffer.setElemIntAt(trgIndex, tileData.srcDataBuffer.getElemIntAt(srcIndex));
                                continue;
                            }
                            tileData.tileDataBuffer.setElemDoubleAt(trgIndex, tileData.srcDataBuffer.getElemDoubleAt(srcIndex));
                        }
                        continue;
                    }
                    if (this.shorelineExtension > 0) {
                        int eMinX = Math.max(minX, x - this.shorelineExtension);
                        int eMaxX = Math.min(maxX, x + this.shorelineExtension);
                        for (int ey = eMinY; ey < eMaxY; ++ey) {
                            for (int ex = eMinX; ex < eMaxX; ++ex) {
                                int eIndex = targetTile.getDataBufferIndex(ex, ey);
                                if (trgTiles[0].tileDataBuffer.getElemDoubleAt(eIndex) == trgTiles[0].noDataValue) continue;
                                for (TileData tileData : trgTiles) {
                                    if (tileData.isInt) {
                                        tileData.tileDataBuffer.setElemIntAt(eIndex, (int)tileData.noDataValue);
                                        continue;
                                    }
                                    tileData.tileDataBuffer.setElemDoubleAt(eIndex, tileData.noDataValue);
                                }
                            }
                        }
                        continue;
                    }
                    for (TileData tileData : trgTiles) {
                        tileData.tileDataBuffer.setElemDoubleAt(trgIndex, tileData.noDataValue);
                    }
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private synchronized void createDEM() throws IOException {
        if (this.dem != null) {
            return;
        }
        this.dem = this.useSRTM != false ? DEMFactory.createElevationModel((String)"SRTM 3Sec", (String)"NEAREST_NEIGHBOUR") : DEMFactory.createElevationModel((String)"ACE2_5Min", (String)"NEAREST_NEIGHBOUR");
    }

    private TileData[] getTargetTiles(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Product srcProduct) {
        ArrayList<TileData> trgTileList = new ArrayList<TileData>();
        Set<Band> keySet = targetTiles.keySet();
        for (Band targetBand : keySet) {
            trgTileList.add(new TileData(targetBand, targetTiles.get(targetBand), this.getSourceTile((RasterDataNode)srcProduct.getBand(targetBand.getName()), targetRectangle)));
        }
        return trgTileList.toArray(new TileData[trgTileList.size()]);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(CreateLandMaskOp.class);
        }
    }

    private static class TileData {
        final Tile targetTile;
        final Tile srcTile;
        final ProductData tileDataBuffer;
        final ProductData srcDataBuffer;
        final double noDataValue;
        final boolean isInt;

        TileData(Band targetBand, Tile targetTile, Tile srcTile) {
            this.targetTile = targetTile;
            this.srcTile = srcTile;
            this.tileDataBuffer = targetTile.getDataBuffer();
            this.srcDataBuffer = srcTile.getDataBuffer();
            this.noDataValue = targetBand.getNoDataValue();
            this.isInt = this.tileDataBuffer instanceof ProductData.Int;
        }
    }
}

