/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.border;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderZero;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public class BorderOpImage
extends OpImage {
    protected BorderExtender extender;
    private Range noData;
    private final boolean hasNoData;
    private byte destNoDataByte;
    private short destNoDataShort;
    private int destNoDataInt;
    private float destNoDataFloat;
    private double destNoDataDouble;
    private byte[] byteLookupTable;
    private final boolean checkBorders;

    public BorderOpImage(RenderedImage source, Map config, ImageLayout layout, int leftPad, int rightPad, int topPad, int bottomPad, BorderExtender extender, Range noData, double destinationNoData) {
        block10: {
            block9: {
                super(BorderOpImage.vectorize((RenderedImage)source), BorderOpImage.layoutHelper(layout, source, leftPad, rightPad, topPad, bottomPad), config, true);
                int dataType = this.getSampleModel().getDataType();
                if (noData == null) break block9;
                this.noData = noData;
                this.hasNoData = true;
                switch (dataType) {
                    case 0: {
                        this.destNoDataByte = ImageUtil.clampRoundByte((double)destinationNoData);
                        this.byteLookupTable = new byte[256];
                        int lookupTableLenght = this.byteLookupTable.length;
                        for (int i = 0; i < lookupTableLenght; ++i) {
                            byte value = (byte)i;
                            this.byteLookupTable[i] = noData.contains(value) ? this.destNoDataByte : value;
                        }
                        break block10;
                    }
                    case 1: {
                        this.destNoDataShort = ImageUtil.clampRoundUShort((double)destinationNoData);
                        break block10;
                    }
                    case 2: {
                        this.destNoDataShort = ImageUtil.clampRoundShort((double)destinationNoData);
                        break block10;
                    }
                    case 3: {
                        this.destNoDataInt = ImageUtil.clampRoundInt((double)destinationNoData);
                        break block10;
                    }
                    case 4: {
                        this.destNoDataFloat = ImageUtil.clampFloat((double)destinationNoData);
                        break block10;
                    }
                    case 5: {
                        this.destNoDataDouble = destinationNoData;
                        break block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong image data type");
                    }
                }
            }
            this.noData = null;
            this.hasNoData = false;
        }
        this.extender = extender;
        boolean notZeroExtender = !(extender instanceof BorderExtenderZero);
        this.checkBorders = this.hasNoData && notZeroExtender;
    }

    private static ImageLayout layoutHelper(ImageLayout layout, RenderedImage source, int leftPad, int rightPad, int topPad, int bottomPad) {
        ImageLayout il = layout == null ? new ImageLayout() : (ImageLayout)layout.clone();
        il.setMinX(source.getMinX() - leftPad);
        il.setMinY(source.getMinY() - topPad);
        il.setWidth(source.getWidth() + leftPad + rightPad);
        il.setHeight(source.getHeight() + topPad + bottomPad);
        if (!il.isValid(16)) {
            il.setTileGridXOffset(il.getMinX(null));
        }
        if (!il.isValid(32)) {
            il.setTileGridYOffset(il.getMinY(null));
        }
        il.setSampleModel(source.getSampleModel());
        il.setColorModel(source.getColorModel());
        return il;
    }

    public Rectangle mapSourceRect(Rectangle sourceRect, int sourceIndex) {
        if (sourceRect == null) {
            throw new IllegalArgumentException("Source Rectangle Not Defined");
        }
        if (sourceIndex < 0 || sourceIndex >= this.getNumSources()) {
            throw new IllegalArgumentException("Source index Out Of Bounds");
        }
        return new Rectangle(sourceRect);
    }

    public Rectangle mapDestRect(Rectangle destRect, int sourceIndex) {
        if (destRect == null) {
            throw new IllegalArgumentException("Destination Rectangle Not Defined");
        }
        if (sourceIndex < 0 || sourceIndex >= this.getNumSources()) {
            throw new IllegalArgumentException("Source index Out Of Bounds");
        }
        Rectangle srcBounds = this.getSourceImage(0).getBounds();
        return destRect.intersection(srcBounds);
    }

    public Raster computeTile(int tileX, int tileY) {
        Rectangle destRect;
        WritableRaster dest = this.createTile(tileX, tileY);
        int dataType = dest.getSampleModel().getDataType();
        PlanarImage sourceImage = this.getSourceImage(0);
        Rectangle imageBounds = sourceImage.getBounds();
        if (imageBounds.contains(destRect = dest.getBounds())) {
            this.copyRasterData(dest, sourceImage);
        } else {
            Rectangle isect = imageBounds.intersection(destRect);
            if (!isect.isEmpty()) {
                WritableRaster isectRaster = dest.createWritableChild(isect.x, isect.y, isect.width, isect.height, isect.x, isect.y, null);
                this.copyRasterData(isectRaster, sourceImage);
            }
            this.extender.extend(dest, sourceImage);
            if (this.checkBorders) {
                switch (dataType) {
                    case 0: {
                        this.fillNoDataByte(dest);
                        break;
                    }
                    case 1: {
                        this.fillNoDataUshort(dest);
                        break;
                    }
                    case 2: {
                        this.fillNoDataShort(dest);
                        break;
                    }
                    case 3: {
                        this.fillNoDataInt(dest);
                        break;
                    }
                    case 4: {
                        this.fillNoDataFloat(dest);
                        break;
                    }
                    case 5: {
                        this.fillNoDataDouble(dest);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong data type");
                    }
                }
            }
        }
        return dest;
    }

    private WritableRaster copyRasterData(WritableRaster dest, PlanarImage sourceImage) {
        Rectangle imageBounds;
        Rectangle destRect = dest.getBounds();
        Rectangle region = destRect.intersection(imageBounds = sourceImage.getBounds());
        if (region.isEmpty()) {
            return dest;
        }
        int dataType = dest.getSampleModel().getDataType();
        int startTileX = sourceImage.XToTileX(region.x);
        int startTileY = sourceImage.YToTileY(region.y);
        int endTileX = sourceImage.XToTileX(region.x + region.width - 1);
        int endTileY = sourceImage.YToTileY(region.y + region.height - 1);
        SampleModel[] sampleModels = new SampleModel[]{sourceImage.getSampleModel()};
        int tagID = RasterAccessor.findCompatibleTag((SampleModel[])sampleModels, (SampleModel)dest.getSampleModel());
        RasterFormatTag srcTag = new RasterFormatTag(sampleModels[0], tagID);
        RasterFormatTag dstTag = new RasterFormatTag(dest.getSampleModel(), tagID);
        for (int ty = startTileY; ty <= endTileY; ++ty) {
            for (int tx = startTileX; tx <= endTileX; ++tx) {
                Raster tile = sourceImage.getTile(tx, ty);
                Rectangle subRegion = region.intersection(tile.getBounds());
                RasterAccessor src = new RasterAccessor(tile, subRegion, srcTag, sourceImage.getColorModel());
                RasterAccessor dst = new RasterAccessor((Raster)dest, subRegion, dstTag, null);
                switch (dataType) {
                    case 0: {
                        this.byteLoop(src, dst);
                        break;
                    }
                    case 1: {
                        this.ushortLoop(src, dst);
                        break;
                    }
                    case 2: {
                        this.shortLoop(src, dst);
                        break;
                    }
                    case 3: {
                        this.intLoop(src, dst);
                        break;
                    }
                    case 4: {
                        this.floatLoop(src, dst);
                        break;
                    }
                    case 5: {
                        this.doubleLoop(src, dst);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong data type");
                    }
                }
                if (!dst.isDataCopy()) continue;
                dst.clampDataArrays();
                dst.copyDataToRaster();
            }
        }
        return dest;
    }

    private void byteLoop(RasterAccessor src, RasterAccessor dst) {
        int srcPixelStride = src.getPixelStride();
        int srcLineStride = src.getScanlineStride();
        int[] srcBandOffsets = src.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstLineStride = dst.getScanlineStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        int width = dst.getWidth();
        int height = dst.getHeight();
        int bands = dst.getNumBands();
        byte[][] bSrcData = src.getByteDataArrays();
        byte[][] bDstData = dst.getByteDataArrays();
        if (this.hasNoData) {
            for (int b = 0; b < bands; ++b) {
                byte[] s = bSrcData[b];
                byte[] d = bDstData[b];
                int dstLineOffset = dstBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int y = 0; y < height; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    for (int x = 0; x < width; ++x) {
                        int value = s[srcPixelOffset] & 0xFF;
                        d[dstPixelOffset] = this.byteLookupTable[value];
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                }
            }
        } else {
            for (int b = 0; b < bands; ++b) {
                byte[] s = bSrcData[b];
                byte[] d = bDstData[b];
                int dstLineOffset = dstBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int y = 0; y < height; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    for (int x = 0; x < width; ++x) {
                        d[dstPixelOffset] = s[srcPixelOffset];
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                }
            }
        }
    }

    private void ushortLoop(RasterAccessor src, RasterAccessor dst) {
        int srcPixelStride = src.getPixelStride();
        int srcLineStride = src.getScanlineStride();
        int[] srcBandOffsets = src.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstLineStride = dst.getScanlineStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        int width = dst.getWidth();
        int height = dst.getHeight();
        int bands = dst.getNumBands();
        short[][] bSrcData = src.getShortDataArrays();
        short[][] bDstData = dst.getShortDataArrays();
        if (this.hasNoData) {
            for (int b = 0; b < bands; ++b) {
                short[] s = bSrcData[b];
                short[] d = bDstData[b];
                int dstLineOffset = dstBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int y = 0; y < height; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    for (int x = 0; x < width; ++x) {
                        int value = s[srcPixelOffset] & 0xFFFF;
                        short valueShort = (short)value;
                        d[dstPixelOffset] = this.noData.contains(valueShort) ? this.destNoDataShort : valueShort;
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                }
            }
        } else {
            for (int b = 0; b < bands; ++b) {
                short[] s = bSrcData[b];
                short[] d = bDstData[b];
                int dstLineOffset = dstBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int y = 0; y < height; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    for (int x = 0; x < width; ++x) {
                        d[dstPixelOffset] = s[srcPixelOffset];
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                }
            }
        }
    }

    private void shortLoop(RasterAccessor src, RasterAccessor dst) {
        int srcPixelStride = src.getPixelStride();
        int srcLineStride = src.getScanlineStride();
        int[] srcBandOffsets = src.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstLineStride = dst.getScanlineStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        int width = dst.getWidth();
        int height = dst.getHeight();
        int bands = dst.getNumBands();
        short[][] bSrcData = src.getShortDataArrays();
        short[][] bDstData = dst.getShortDataArrays();
        if (this.hasNoData) {
            for (int b = 0; b < bands; ++b) {
                short[] s = bSrcData[b];
                short[] d = bDstData[b];
                int dstLineOffset = dstBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int y = 0; y < height; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    for (int x = 0; x < width; ++x) {
                        short value = s[srcPixelOffset];
                        d[dstPixelOffset] = this.noData.contains(value) ? this.destNoDataShort : value;
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                }
            }
        } else {
            for (int b = 0; b < bands; ++b) {
                short[] s = bSrcData[b];
                short[] d = bDstData[b];
                int dstLineOffset = dstBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int y = 0; y < height; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    for (int x = 0; x < width; ++x) {
                        d[dstPixelOffset] = s[srcPixelOffset];
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                }
            }
        }
    }

    private void intLoop(RasterAccessor src, RasterAccessor dst) {
        int srcPixelStride = src.getPixelStride();
        int srcLineStride = src.getScanlineStride();
        int[] srcBandOffsets = src.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstLineStride = dst.getScanlineStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        int width = dst.getWidth();
        int height = dst.getHeight();
        int bands = dst.getNumBands();
        int[][] bSrcData = src.getIntDataArrays();
        int[][] bDstData = dst.getIntDataArrays();
        if (this.hasNoData) {
            for (int b = 0; b < bands; ++b) {
                int[] s = bSrcData[b];
                int[] d = bDstData[b];
                int dstLineOffset = dstBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int y = 0; y < height; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    for (int x = 0; x < width; ++x) {
                        int value = s[srcPixelOffset];
                        d[dstPixelOffset] = this.noData.contains(value) ? this.destNoDataInt : value;
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                }
            }
        } else {
            for (int b = 0; b < bands; ++b) {
                int[] s = bSrcData[b];
                int[] d = bDstData[b];
                int dstLineOffset = dstBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int y = 0; y < height; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    for (int x = 0; x < width; ++x) {
                        d[dstPixelOffset] = s[srcPixelOffset];
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                }
            }
        }
    }

    private void floatLoop(RasterAccessor src, RasterAccessor dst) {
        int srcPixelStride = src.getPixelStride();
        int srcLineStride = src.getScanlineStride();
        int[] srcBandOffsets = src.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstLineStride = dst.getScanlineStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        int width = dst.getWidth();
        int height = dst.getHeight();
        int bands = dst.getNumBands();
        float[][] bSrcData = src.getFloatDataArrays();
        float[][] bDstData = dst.getFloatDataArrays();
        if (this.hasNoData) {
            for (int b = 0; b < bands; ++b) {
                float[] s = bSrcData[b];
                float[] d = bDstData[b];
                int dstLineOffset = dstBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int y = 0; y < height; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    for (int x = 0; x < width; ++x) {
                        float value = s[srcPixelOffset];
                        d[dstPixelOffset] = this.noData.contains(value) ? this.destNoDataFloat : value;
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                }
            }
        } else {
            for (int b = 0; b < bands; ++b) {
                float[] s = bSrcData[b];
                float[] d = bDstData[b];
                int dstLineOffset = dstBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int y = 0; y < height; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    for (int x = 0; x < width; ++x) {
                        d[dstPixelOffset] = s[srcPixelOffset];
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                }
            }
        }
    }

    private void doubleLoop(RasterAccessor src, RasterAccessor dst) {
        int srcPixelStride = src.getPixelStride();
        int srcLineStride = src.getScanlineStride();
        int[] srcBandOffsets = src.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstLineStride = dst.getScanlineStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        int width = dst.getWidth();
        int height = dst.getHeight();
        int bands = dst.getNumBands();
        double[][] bSrcData = src.getDoubleDataArrays();
        double[][] bDstData = dst.getDoubleDataArrays();
        if (this.hasNoData) {
            for (int b = 0; b < bands; ++b) {
                double[] s = bSrcData[b];
                double[] d = bDstData[b];
                int dstLineOffset = dstBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int y = 0; y < height; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    for (int x = 0; x < width; ++x) {
                        double value = s[srcPixelOffset];
                        d[dstPixelOffset] = this.noData.contains(value) ? this.destNoDataDouble : value;
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                }
            }
        } else {
            for (int b = 0; b < bands; ++b) {
                double[] s = bSrcData[b];
                double[] d = bDstData[b];
                int dstLineOffset = dstBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int y = 0; y < height; ++y) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    for (int x = 0; x < width; ++x) {
                        d[dstPixelOffset] = s[srcPixelOffset];
                        dstPixelOffset += dstPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                    dstLineOffset += dstLineStride;
                    srcLineOffset += srcLineStride;
                }
            }
        }
    }

    private void fillNoDataByte(WritableRaster dest) {
        Rectangle destBounds;
        Rectangle srcBounds = this.getSourceImage(0).getBounds();
        if (!srcBounds.contains(destBounds = dest.getBounds()) && !destBounds.intersection(srcBounds).isEmpty()) {
            int minX = dest.getMinX();
            int minY = dest.getMinY();
            int maxX = minX + dest.getWidth();
            int maxY = minY + dest.getHeight();
            int numBands = dest.getNumBands();
            for (int i = minX; i < maxX; ++i) {
                for (int j = minY; j < maxY; ++j) {
                    for (int b = 0; b < numBands; ++b) {
                        int sample = dest.getSample(i, j, b) & 0xFF;
                        dest.setSample(i, j, b, this.byteLookupTable[sample]);
                    }
                }
            }
        }
    }

    private void fillNoDataUshort(WritableRaster dest) {
        Rectangle destBounds;
        Rectangle srcBounds = this.getSourceImage(0).getBounds();
        if (!srcBounds.contains(destBounds = dest.getBounds()) && !destBounds.intersection(srcBounds).isEmpty()) {
            int minX = dest.getMinX();
            int minY = dest.getMinY();
            int maxX = minX + dest.getWidth();
            int maxY = minY + dest.getHeight();
            int numBands = dest.getNumBands();
            for (int i = minX; i < maxX; ++i) {
                for (int j = minY; j < maxY; ++j) {
                    for (int b = 0; b < numBands; ++b) {
                        int sample = dest.getSample(i, j, b) & 0xFFFF;
                        short sampleShort = (short)sample;
                        if (this.noData.contains(sampleShort)) {
                            dest.setSample(i, j, b, this.destNoDataShort);
                            continue;
                        }
                        dest.setSample(i, j, b, sampleShort);
                    }
                }
            }
        }
    }

    private void fillNoDataShort(WritableRaster dest) {
        Rectangle destBounds;
        Rectangle srcBounds = this.getSourceImage(0).getBounds();
        if (!srcBounds.contains(destBounds = dest.getBounds()) && !destBounds.intersection(srcBounds).isEmpty()) {
            int minX = dest.getMinX();
            int minY = dest.getMinY();
            int maxX = minX + dest.getWidth();
            int maxY = minY + dest.getHeight();
            int numBands = dest.getNumBands();
            for (int i = minX; i < maxX; ++i) {
                for (int j = minY; j < maxY; ++j) {
                    for (int b = 0; b < numBands; ++b) {
                        short sample = (short)dest.getSample(i, j, b);
                        if (this.noData.contains(sample)) {
                            dest.setSample(i, j, b, this.destNoDataShort);
                            continue;
                        }
                        dest.setSample(i, j, b, sample);
                    }
                }
            }
        }
    }

    private void fillNoDataInt(WritableRaster dest) {
        Rectangle destBounds;
        Rectangle srcBounds = this.getSourceImage(0).getBounds();
        if (!srcBounds.contains(destBounds = dest.getBounds()) && !destBounds.intersection(srcBounds).isEmpty()) {
            int minX = dest.getMinX();
            int minY = dest.getMinY();
            int maxX = minX + dest.getWidth();
            int maxY = minY + dest.getHeight();
            int numBands = dest.getNumBands();
            for (int i = minX; i < maxX; ++i) {
                for (int j = minY; j < maxY; ++j) {
                    for (int b = 0; b < numBands; ++b) {
                        int sample = dest.getSample(i, j, b);
                        if (this.noData.contains(sample)) {
                            dest.setSample(i, j, b, this.destNoDataInt);
                            continue;
                        }
                        dest.setSample(i, j, b, sample);
                    }
                }
            }
        }
    }

    private void fillNoDataFloat(WritableRaster dest) {
        Rectangle destBounds;
        Rectangle srcBounds = this.getSourceImage(0).getBounds();
        if (!srcBounds.contains(destBounds = dest.getBounds()) && !destBounds.intersection(srcBounds).isEmpty()) {
            int minX = dest.getMinX();
            int minY = dest.getMinY();
            int maxX = minX + dest.getWidth();
            int maxY = minY + dest.getHeight();
            int numBands = dest.getNumBands();
            for (int i = minX; i < maxX; ++i) {
                for (int j = minY; j < maxY; ++j) {
                    for (int b = 0; b < numBands; ++b) {
                        float sample = dest.getSampleFloat(i, j, b);
                        if (this.noData.contains(sample)) {
                            dest.setSample(i, j, b, this.destNoDataFloat);
                            continue;
                        }
                        dest.setSample(i, j, b, sample);
                    }
                }
            }
        }
    }

    private void fillNoDataDouble(WritableRaster dest) {
        Rectangle destBounds;
        Rectangle srcBounds = this.getSourceImage(0).getBounds();
        if (!srcBounds.contains(destBounds = dest.getBounds()) && !destBounds.intersection(srcBounds).isEmpty()) {
            int minX = dest.getMinX();
            int minY = dest.getMinY();
            int maxX = minX + dest.getWidth();
            int maxY = minY + dest.getHeight();
            int numBands = dest.getNumBands();
            for (int i = minX; i < maxX; ++i) {
                for (int j = minY; j < maxY; ++j) {
                    for (int b = 0; b < numBands; ++b) {
                        double sample = dest.getSampleDouble(i, j, b);
                        if (this.noData.contains(sample)) {
                            dest.setSample(i, j, b, this.destNoDataDouble);
                            continue;
                        }
                        dest.setSample(i, j, b, sample);
                    }
                }
            }
        }
    }
}

