/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.jexp;

import org.esa.snap.core.jexp.EvalEnv;
import org.esa.snap.core.jexp.EvalException;
import org.esa.snap.core.jexp.Function;
import org.esa.snap.core.jexp.Symbol;
import org.esa.snap.core.jexp.TermVisitor;
import org.esa.snap.core.jexp.Variable;

public abstract class Term {
    private static final int Assign_PRE = 990;
    private static final int Cond_PRE = 890;
    private static final int OrB_PRE = 790;
    private static final int AndB_PRE = 780;
    private static final int Comp_PRE = 690;
    private static final int OrI_PRE = 590;
    private static final int XOrI_PRE = 580;
    private static final int AndI_PRE = 570;
    private static final int Add_PRE = 490;
    private static final int Mul_PRE = 390;
    private static final int Unary_PRE = 290;
    private static final int Primary_PRE = 0;
    public static final int TYPE_B = 1;
    public static final int TYPE_I = 2;
    public static final int TYPE_D = 3;
    public static final int TYPE_S = 4;
    private static final Term[] _EMPTY_TERM_ARRAY = new Term[0];

    public abstract int getRetType();

    public abstract boolean evalB(EvalEnv var1);

    public abstract int evalI(EvalEnv var1);

    public abstract double evalD(EvalEnv var1);

    public abstract <T> T accept(TermVisitor<T> var1);

    public String evalS(EvalEnv env) {
        return this.toString();
    }

    public Term[] getChildren() {
        return _EMPTY_TERM_ARRAY;
    }

    public abstract String toString();

    public final boolean isB() {
        return this.getRetType() == 1;
    }

    public final boolean isI() {
        return this.getRetType() == 2;
    }

    public final boolean isD() {
        return this.getRetType() == 3;
    }

    public final boolean isN() {
        return this.isI() || this.isD();
    }

    public final boolean isS() {
        return this.getRetType() == 4;
    }

    public static boolean toB(int value) {
        return value != 0;
    }

    public static boolean toB(double value) {
        return value != 0.0;
    }

    public static int toI(boolean value) {
        return value ? 1 : 0;
    }

    public static int toI(double value) {
        return (int)value;
    }

    public static double toD(boolean value) {
        return value ? 1.0 : 0.0;
    }

    public static String toS(boolean value) {
        return Boolean.toString(value);
    }

    public static String toS(int value) {
        return Integer.toString(value);
    }

    public static String toS(double value) {
        return Double.toString(value);
    }

    public abstract boolean isConst();

    public abstract int compare(Term var1);

    private static String getParamString(String name, Term[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append('(');
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(args[i].toString());
        }
        sb.append(')');
        return sb.toString();
    }

    public abstract int pre();

    private static int numType(Term t) {
        return t.isD() ? 3 : 2;
    }

    private static int numType(Term t1, Term t2) {
        return t1.isD() || t2.isD() ? 3 : 2;
    }

    public static final class GeD
    extends BinaryB {
        public GeD(Term arg1, Term arg2) {
            super("GeD", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalD(env) >= this.arg2.evalD(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 690;
        }
    }

    public static final class GeI
    extends BinaryB {
        public GeI(Term arg1, Term arg2) {
            super("GeI", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalI(env) >= this.arg2.evalI(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 690;
        }
    }

    public static final class GtD
    extends BinaryB {
        public GtD(Term arg1, Term arg2) {
            super("GtD", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalD(env) > this.arg2.evalD(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 690;
        }
    }

    public static final class GtI
    extends BinaryB {
        public GtI(Term arg1, Term arg2) {
            super("GtI", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalI(env) > this.arg2.evalI(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 690;
        }
    }

    public static final class LeD
    extends BinaryB {
        public LeD(Term arg1, Term arg2) {
            super("LeD", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalD(env) <= this.arg2.evalD(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 690;
        }
    }

    public static final class LeI
    extends BinaryB {
        public LeI(Term arg1, Term arg2) {
            super("LeI", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalI(env) <= this.arg2.evalI(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 690;
        }
    }

    public static final class LtD
    extends BinaryB {
        public LtD(Term arg1, Term arg2) {
            super("LtD", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalD(env) < this.arg2.evalD(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 690;
        }
    }

    public static final class LtI
    extends BinaryB {
        public LtI(Term arg1, Term arg2) {
            super("LtI", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalI(env) < this.arg2.evalI(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 690;
        }
    }

    public static final class NEqD
    extends BinaryB {
        public NEqD(Term arg1, Term arg2) {
            super("NEqD", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalD(env) != this.arg2.evalD(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 690;
        }
    }

    public static final class NEqI
    extends BinaryB {
        public NEqI(Term arg1, Term arg2) {
            super("NEqI", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalI(env) != this.arg2.evalI(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 690;
        }
    }

    public static final class NEqB
    extends BinaryB {
        public NEqB(Term arg1, Term arg2) {
            super("NEqB", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalB(env) != this.arg2.evalB(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 690;
        }
    }

    public static final class EqD
    extends BinaryB {
        public EqD(Term arg1, Term arg2) {
            super("EqD", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalD(env) == this.arg2.evalD(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 690;
        }
    }

    public static final class EqI
    extends BinaryB {
        public EqI(Term arg1, Term arg2) {
            super("EqI", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalI(env) == this.arg2.evalI(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 690;
        }
    }

    public static final class EqB
    extends BinaryB {
        public EqB(Term arg1, Term arg2) {
            super("EqB", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalB(env) == this.arg2.evalB(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 690;
        }
    }

    public static final class Mod
    extends BinaryN {
        public Mod(Term arg1, Term arg2) {
            this(Term.numType(arg1, arg2), arg1, arg2);
        }

        public Mod(int type, Term arg1, Term arg2) {
            super("Mod", type, arg1, arg2);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.arg1.evalI(env) % this.arg2.evalI(env);
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.arg1.evalD(env) % this.arg2.evalD(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 390;
        }
    }

    public static final class Div
    extends BinaryN {
        public Div(Term arg1, Term arg2) {
            this(Term.numType(arg1, arg2), arg1, arg2);
        }

        public Div(int type, Term arg1, Term arg2) {
            super("Div", type, arg1, arg2);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.arg1.evalI(env) / this.arg2.evalI(env);
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.arg1.evalD(env) / this.arg2.evalD(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 390;
        }
    }

    public static final class Mul
    extends BinaryN {
        public Mul(Term arg1, Term arg2) {
            this(Term.numType(arg1, arg2), arg1, arg2);
        }

        public Mul(int type, Term arg1, Term arg2) {
            super("Mul", type, arg1, arg2);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.arg1.evalI(env) * this.arg2.evalI(env);
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.arg1.evalD(env) * this.arg2.evalD(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 390;
        }
    }

    public static final class Sub
    extends BinaryN {
        public Sub(Term arg1, Term arg2) {
            this(Term.numType(arg1, arg2), arg1, arg2);
        }

        public Sub(int type, Term arg1, Term arg2) {
            super("Sub", type, arg1, arg2);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.arg1.evalI(env) - this.arg2.evalI(env);
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.arg1.evalD(env) - this.arg2.evalD(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 490;
        }
    }

    public static final class Add
    extends BinaryN {
        public Add(Term arg1, Term arg2) {
            this(Term.numType(arg1, arg2), arg1, arg2);
        }

        public Add(int type, Term arg1, Term arg2) {
            super("Add", type, arg1, arg2);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.arg1.evalI(env) + this.arg2.evalI(env);
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.arg1.evalD(env) + this.arg2.evalD(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 490;
        }
    }

    public static final class Neg
    extends UnaryN {
        public Neg(Term arg) {
            this(Term.numType(arg), arg);
        }

        public Neg(int type, Term arg) {
            super("Neg", type, arg);
        }

        @Override
        public int evalI(EvalEnv env) {
            return -this.arg.evalI(env);
        }

        @Override
        public double evalD(EvalEnv env) {
            return -this.arg.evalD(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class OrI
    extends BinaryI {
        public OrI(Term arg1, Term arg2) {
            super("OrI", arg1, arg2);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.arg1.evalI(env) | this.arg2.evalI(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 590;
        }
    }

    public static final class AndI
    extends BinaryI {
        public AndI(Term arg1, Term arg2) {
            super("AndI", arg1, arg2);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.arg1.evalI(env) & this.arg2.evalI(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 570;
        }
    }

    public static final class XOrI
    extends BinaryI {
        public XOrI(Term arg1, Term arg2) {
            super("XOrI", arg1, arg2);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.arg1.evalI(env) ^ this.arg2.evalI(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 580;
        }
    }

    public static final class NotI
    extends UnaryI {
        public NotI(Term arg) {
            super("NotI", arg);
        }

        @Override
        public int evalI(EvalEnv env) {
            return ~this.arg.evalI(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class OrB
    extends BinaryB {
        public OrB(Term arg1, Term arg2) {
            super("OrB", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalB(env) || this.arg2.evalB(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 790;
        }
    }

    public static final class AndB
    extends BinaryB {
        public AndB(Term arg1, Term arg2) {
            super("AndB", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalB(env) && this.arg2.evalB(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 780;
        }
    }

    public static final class NotB
    extends UnaryB {
        public NotB(Term arg) {
            super("NotB", arg);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return !this.arg.evalB(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Assign
    extends Binary {
        public Assign(Term arg1, Term arg2) {
            super("Assign", arg1.getRetType(), arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv context) {
            throw new EvalException("not implemented");
        }

        @Override
        public int evalI(EvalEnv env) {
            throw new EvalException("not implemented");
        }

        @Override
        public double evalD(EvalEnv env) {
            throw new EvalException("not implemented");
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 990;
        }
    }

    public static final class Cond
    extends Op {
        protected final Term arg1;
        protected final Term arg2;
        protected final Term arg3;

        public Cond(int type, Term arg1, Term arg2, Term arg3) {
            super("Cond", type, new Term[]{arg1, arg2, arg3});
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalB(env) ? this.arg2.evalB(env) : this.arg3.evalB(env);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.arg1.evalB(env) ? this.arg2.evalI(env) : this.arg3.evalI(env);
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.arg1.evalB(env) ? this.arg2.evalD(env) : this.arg3.evalD(env);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public int pre() {
            return 890;
        }
    }

    public static abstract class BinaryN
    extends Binary {
        protected BinaryN(String name, int type, Term arg1, Term arg2) {
            super(name, type, arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.type == 2 ? BinaryN.toB(this.evalI(env)) : BinaryN.toB(this.evalD(env));
        }
    }

    public static abstract class BinaryI
    extends Binary {
        protected BinaryI(String name, Term arg1, Term arg2) {
            super(name, 2, arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return BinaryI.toB(this.evalI(env));
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.evalI(env);
        }
    }

    public static abstract class BinaryB
    extends Binary {
        protected BinaryB(String name, Term arg1, Term arg2) {
            super(name, 1, arg1, arg2);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.evalB(env) ? 1 : 0;
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.evalB(env) ? 1.0 : 0.0;
        }
    }

    public static abstract class Binary
    extends Op {
        protected final Term arg1;
        protected final Term arg2;

        protected Binary(String name, int type, Term arg1, Term arg2) {
            super(name, type, new Term[]{arg1, arg2});
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
    }

    public static abstract class UnaryN
    extends Unary {
        protected UnaryN(String name, int type, Term arg) {
            super(name, type, arg);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return UnaryN.toB(this.evalD(env));
        }
    }

    public static abstract class UnaryI
    extends Unary {
        protected UnaryI(String name, Term arg) {
            super(name, 2, arg);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return UnaryI.toB(this.evalI(env));
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.evalI(env);
        }
    }

    public static abstract class UnaryB
    extends Unary {
        protected UnaryB(String name, Term arg) {
            super(name, 1, arg);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.evalB(env) ? 1 : 0;
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.evalB(env) ? 1.0 : 0.0;
        }
    }

    public static abstract class Unary
    extends Op {
        protected final Term arg;

        protected Unary(String name, int type, Term arg) {
            super(name, type, new Term[]{arg});
            this.arg = arg;
        }

        @Override
        public final int pre() {
            return 290;
        }
    }

    public static abstract class Op
    extends Term {
        protected final String name;
        protected final int type;
        protected final Term[] args;

        protected Op(String name, int type, Term[] args) {
            this.name = name.intern();
            this.type = type;
            this.args = args;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public int getRetType() {
            return this.type;
        }

        public int getArgCount() {
            return this.args.length;
        }

        public Term getArg() {
            return this.args[0];
        }

        public Term getArg(int index) {
            return this.args[index];
        }

        public Term[] getArgs() {
            return this.args;
        }

        @Override
        public Term[] getChildren() {
            return this.getArgs();
        }

        @Override
        public String toString() {
            return Term.getParamString(this.name, this.args);
        }

        @Override
        public boolean isConst() {
            for (Term arg : this.args) {
                if (arg.isConst()) continue;
                return false;
            }
            return true;
        }

        @Override
        public int compare(Term other) {
            if (other instanceof Const) {
                return 1;
            }
            if (other instanceof Ref) {
                return 1;
            }
            if (other instanceof Call) {
                return 1;
            }
            if (other instanceof Op) {
                Op otherOp = (Op)other;
                int i = this.getName().compareTo(otherOp.getName());
                if (i != 0) {
                    return i;
                }
                i = this.getArgCount() - otherOp.getArgCount();
                if (i != 0) {
                    return i;
                }
                for (int j = 0; j < this.getArgCount(); ++j) {
                    i = this.getArg(j).compare(otherOp.getArg(j));
                    if (i == 0) continue;
                    return i;
                }
                return 0;
            }
            return -1;
        }
    }

    public static final class Call
    extends Term {
        protected final Function function;
        protected final Term[] args;

        public Call(Function function, Term ... args) {
            this.function = function;
            this.args = args;
        }

        @Override
        public int getRetType() {
            return this.function.getRetType();
        }

        public Function getFunction() {
            return this.function;
        }

        public int getArgCount() {
            return this.args.length;
        }

        public Term getArg() {
            return this.args[0];
        }

        public Term getArg(int index) {
            return this.args[index];
        }

        public Term[] getArgs() {
            return this.args;
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.function.evalB(env, this.args);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.function.evalI(env, this.args);
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.function.evalD(env, this.args);
        }

        @Override
        public Term[] getChildren() {
            return this.getArgs();
        }

        @Override
        public String toString() {
            return Term.getParamString(this.function.getName(), this.args);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public boolean isConst() {
            return this.function.isConst(this.args);
        }

        @Override
        public int compare(Term other) {
            if (other instanceof Const) {
                return 1;
            }
            if (other instanceof Ref) {
                return 1;
            }
            if (other instanceof Call) {
                Call otherCall = (Call)other;
                int i = this.function.getName().compareTo(otherCall.function.getName());
                if (i != 0) {
                    return i;
                }
                i = this.getArgCount() - otherCall.getArgCount();
                if (i != 0) {
                    return i;
                }
                for (int j = 0; j < this.getArgCount(); ++j) {
                    i = this.getArg(j).compare(otherCall.getArg(j));
                    if (i == 0) continue;
                    return i;
                }
                return 0;
            }
            return -1;
        }

        @Override
        public int pre() {
            return 0;
        }
    }

    public static final class Ref
    extends Term {
        protected final Symbol symbol;

        public Ref(Symbol symbol) {
            this.symbol = symbol;
        }

        public Symbol getSymbol() {
            return this.symbol;
        }

        public Variable getVariable() {
            return this.symbol instanceof Variable ? (Variable)this.symbol : null;
        }

        @Override
        public int getRetType() {
            return this.symbol.getRetType();
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.symbol.evalB(env);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.symbol.evalI(env);
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.symbol.evalD(env);
        }

        @Override
        public String evalS(EvalEnv env) {
            return this.symbol.evalS(env);
        }

        @Override
        public String toString() {
            return this.symbol.getName();
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public boolean isConst() {
            return this.symbol.isConst();
        }

        @Override
        public int compare(Term other) {
            if (other instanceof Const) {
                return 1;
            }
            if (other instanceof Ref) {
                return this.symbol.getName().compareTo(((Ref)other).symbol.getName());
            }
            return -1;
        }

        @Override
        public int pre() {
            return 0;
        }
    }

    public static class ConstS
    extends Const {
        private final String value;

        public ConstS(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public int getRetType() {
            return 4;
        }

        @Override
        protected boolean toB() {
            if (this.value.equalsIgnoreCase("true")) {
                return true;
            }
            if (this.value.equalsIgnoreCase("false")) {
                return false;
            }
            throw new EvalException("Cannot convert '" + this.value + "' to boolean.");
        }

        @Override
        protected int toI() {
            try {
                return Integer.valueOf(this.value);
            }
            catch (NumberFormatException e) {
                throw new EvalException("Cannot convert '" + this.value + "' to int.");
            }
        }

        @Override
        protected double toD() {
            try {
                return Double.valueOf(this.value);
            }
            catch (NumberFormatException e) {
                throw new EvalException("Cannot convert '" + this.value + "' to double.");
            }
        }

        @Override
        protected String toS() {
            return this.value;
        }

        @Override
        public String toString() {
            return "\"" + this.value + "\"";
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class ConstD
    extends Const {
        public static final ConstD NAN = new ConstD(Double.NaN);
        public static final ConstD ZERO = new ConstD(0.0);
        public static final ConstD ONE = new ConstD(1.0);
        public static final ConstD TWO = new ConstD(2.0);
        public static final ConstD HALF = new ConstD(0.5);
        public static final ConstD PI = new ConstD(Math.PI);
        public static final ConstD E = new ConstD(Math.E);
        private final double value;

        public static ConstD lookup(double value) {
            if (Double.isNaN(value)) {
                return NAN;
            }
            if (ConstD.eq(value, 0.0)) {
                return ZERO;
            }
            if (ConstD.eq(value, 0.5)) {
                return HALF;
            }
            if (ConstD.eq(value, 1.0)) {
                return ONE;
            }
            if (ConstD.eq(value, 2.0)) {
                return TWO;
            }
            if (ConstD.eq(value, Math.PI)) {
                return PI;
            }
            if (ConstD.eq(value, Math.E)) {
                return E;
            }
            return null;
        }

        public ConstD(double value) {
            this.value = value;
        }

        public double getValue() {
            return this.value;
        }

        @Override
        public int getRetType() {
            return 3;
        }

        @Override
        protected boolean toB() {
            return ConstD.toB(this.value);
        }

        @Override
        protected int toI() {
            return ConstD.toI(this.value);
        }

        @Override
        protected double toD() {
            return this.value;
        }

        @Override
        protected String toS() {
            return ConstD.toS(this.value);
        }

        @Override
        public String toString() {
            return String.valueOf(this.value);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }

        public static boolean eq(double v1, double v2) {
            return Math.abs(v1 - v2) <= 1.0E-15;
        }
    }

    public static final class ConstI
    extends Const {
        public static final ConstI ZERO = new ConstI(0);
        public static final ConstI ONE = new ConstI(1);
        public static final ConstI TWO = new ConstI(2);
        private final int value;

        public static ConstI lookup(int value) {
            if (value == 0) {
                return ZERO;
            }
            if (value == 1) {
                return ONE;
            }
            if (value == 2) {
                return TWO;
            }
            return null;
        }

        public ConstI(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        @Override
        public int getRetType() {
            return 2;
        }

        @Override
        protected boolean toB() {
            return ConstI.toB(this.value);
        }

        @Override
        protected int toI() {
            return this.value;
        }

        @Override
        protected double toD() {
            return this.value;
        }

        @Override
        protected String toS() {
            return ConstI.toS(this.value);
        }

        @Override
        public String toString() {
            return String.valueOf(this.value);
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class ConstB
    extends Const {
        public static final ConstB FALSE = new ConstB(false);
        public static final ConstB TRUE = new ConstB(true);
        private final boolean value;

        public ConstB(boolean value) {
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }

        @Override
        public int getRetType() {
            return 1;
        }

        @Override
        protected boolean toB() {
            return this.value;
        }

        @Override
        protected int toI() {
            return ConstB.toI(this.value);
        }

        @Override
        protected double toD() {
            return ConstB.toD(this.value);
        }

        @Override
        protected String toS() {
            return ConstB.toS(this.value);
        }

        @Override
        public String toString() {
            return this.toS();
        }

        @Override
        public <T> T accept(TermVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static abstract class Const
    extends Term {
        @Override
        public boolean evalB(EvalEnv env) {
            return this.toB();
        }

        protected abstract boolean toB();

        @Override
        public int evalI(EvalEnv env) {
            return this.toI();
        }

        protected abstract int toI();

        @Override
        public double evalD(EvalEnv env) {
            return this.toD();
        }

        protected abstract double toD();

        @Override
        public String evalS(EvalEnv env) {
            return this.toS();
        }

        protected abstract String toS();

        @Override
        public final boolean isConst() {
            return true;
        }

        @Override
        public final int compare(Term other) {
            if (other instanceof ConstB) {
                return this.toI() - ((ConstB)other).toI();
            }
            if (other instanceof ConstI) {
                return this.toI() - ((ConstI)other).toI();
            }
            if (other instanceof ConstD) {
                double delta = this.toD() - ((ConstD)other).toD();
                return delta == 0.0 ? 0 : (delta < 0.0 ? -1 : 1);
            }
            if (other instanceof ConstS) {
                return this.toS().compareTo(((ConstS)other).toS());
            }
            return -1;
        }

        @Override
        public int pre() {
            return 0;
        }
    }
}

