/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.image;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.media.jai.PlanarImage;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.image.SingleBandedOpImage;
import org.esa.snap.core.util.ImageUtils;

public abstract class RasterDataNodeOpImage
extends SingleBandedOpImage {
    private final RasterDataNode rasterDataNode;

    private static Dimension getPreferredTileSize(RasterDataNode rdn) {
        Product product = rdn.getProduct();
        if (product != null && product.getPreferredTileSize() != null) {
            return product.getPreferredTileSize();
        }
        return null;
    }

    protected RasterDataNodeOpImage(RasterDataNode rasterDataNode, ResolutionLevel level) {
        super(ImageManager.getDataBufferType(rasterDataNode.getDataType()), rasterDataNode.getRasterWidth(), rasterDataNode.getRasterHeight(), RasterDataNodeOpImage.getPreferredTileSize(rasterDataNode), null, level);
        this.rasterDataNode = rasterDataNode;
    }

    public RasterDataNode getRasterDataNode() {
        return this.rasterDataNode;
    }

    protected ProductData getGeophysicalProductData(RasterDataNode band, Rectangle region) {
        return this.getProductData(band.getGeophysicalImage().getImage(this.getLevel()), band.getGeophysicalDataType(), region);
    }

    protected ProductData getRawProductData(RasterDataNode band, Rectangle region) {
        return this.getProductData(band.getSourceImage().getImage(this.getLevel()), band.getDataType(), region);
    }

    private ProductData getProductData(RenderedImage image, int productDataType, Rectangle region) {
        boolean directMode;
        Raster raster = image.getData(region);
        boolean bl = directMode = raster.getDataBuffer().getSize() == region.width * region.height;
        if (directMode) {
            return ProductData.createInstance(productDataType, ImageUtils.getPrimitiveArray(raster.getDataBuffer()));
        }
        ProductData instance = ProductData.createInstance(productDataType, region.width * region.height);
        raster.getDataElements(region.x, region.y, region.width, region.height, instance.getElems());
        return instance;
    }

    protected void computeRect(PlanarImage[] sourceImages, WritableRaster tile, Rectangle destRect) {
        boolean directMode = tile.getDataBuffer().getSize() == destRect.width * destRect.height;
        ProductData productData = directMode ? ProductData.createInstance(this.rasterDataNode.getDataType(), ImageUtils.getPrimitiveArray(tile.getDataBuffer())) : ProductData.createInstance(this.rasterDataNode.getDataType(), destRect.width * destRect.height);
        try {
            this.computeProductData(productData, destRect);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!directMode) {
            tile.setDataElements(destRect.x, destRect.y, destRect.width, destRect.height, productData.getElems());
        }
    }

    protected abstract void computeProductData(ProductData var1, Rectangle var2) throws IOException;

    public String toString() {
        String className = ((Object)((Object)this)).getClass().getSimpleName();
        String productName = "";
        if (this.rasterDataNode.getProduct() != null) {
            productName = ":" + this.rasterDataNode.getProduct().getName();
        }
        String bandName = "." + this.rasterDataNode.getName();
        return className + productName + bandName;
    }

    protected int[] getSourceCoords(int sourceLength, int targetLength) {
        int[] sourceCoords = new int[targetLength];
        for (int i = 0; i < targetLength; ++i) {
            sourceCoords[i] = this.getSourceCoord(i, 0, sourceLength - 1);
        }
        return sourceCoords;
    }

    protected static void copyLine(int y, int destWidth, ProductData src, ProductData dest, int[] sourceCoords) {
        int destOffset = y * destWidth;
        switch (src.getType()) {
            case 10: 
            case 20: {
                byte[] srcArrayB = (byte[])src.getElems();
                byte[] destArrayB = (byte[])dest.getElems();
                for (int coord : sourceCoords) {
                    destArrayB[destOffset++] = srcArrayB[coord];
                }
                return;
            }
            case 11: 
            case 21: {
                short[] srcArrayS = (short[])src.getElems();
                short[] destArrayS = (short[])dest.getElems();
                for (int coord : sourceCoords) {
                    destArrayS[destOffset++] = srcArrayS[coord];
                }
                return;
            }
            case 12: 
            case 22: {
                int[] srcArrayI = (int[])src.getElems();
                int[] destArrayI = (int[])dest.getElems();
                for (int coord : sourceCoords) {
                    destArrayI[destOffset++] = srcArrayI[coord];
                }
                return;
            }
            case 30: {
                float[] srcArrayF = (float[])src.getElems();
                float[] destArrayF = (float[])dest.getElems();
                for (int coord : sourceCoords) {
                    destArrayF[destOffset++] = srcArrayF[coord];
                }
                return;
            }
            case 31: {
                double[] srcArrayD = (double[])src.getElems();
                double[] destArrayD = (double[])dest.getElems();
                for (int coord : sourceCoords) {
                    destArrayD[destOffset++] = srcArrayD[coord];
                }
                return;
            }
        }
        throw new IllegalArgumentException("wrong product data type: " + src.getType());
    }
}

