/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.maptransf;

import java.awt.geom.Point2D;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.dataop.maptransf.DefaultMapTransformUI;
import org.esa.snap.core.dataop.maptransf.ISEAG;
import org.esa.snap.core.dataop.maptransf.MapProjection;
import org.esa.snap.core.dataop.maptransf.MapProjectionRegistry;
import org.esa.snap.core.dataop.maptransf.MapTransform;
import org.esa.snap.core.dataop.maptransf.MapTransformDescriptor;
import org.esa.snap.core.dataop.maptransf.MapTransformUI;
import org.esa.snap.core.param.Parameter;
import org.esa.snap.core.util.Guardian;

@Deprecated
public class IntegerizedSinusoidalDescriptor
implements MapTransformDescriptor {
    public static final String TYPE_ID = "ISEAG";
    public static final String NAME = "Integerized Sinusoidal Equal Area Grid";
    public static final String MAP_UNIT = "units";
    public static final int DEFAULT_ROW_COUNT_VALUE = 2160;
    private static final Parameter[] PARAMETERS = new Parameter[]{new Parameter("rowCount", 2160)};
    private static final double[] PARAMETER_DEFAULT_VALUES = new double[]{2160.0};

    @Override
    public void registerProjections() {
        MapProjectionRegistry.registerProjection(new MapProjection(this.getName(), this.createTransform(null), false));
    }

    @Override
    public String getTypeID() {
        return TYPE_ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getMapUnit() {
        return MAP_UNIT;
    }

    @Override
    public double[] getParameterDefaultValues() {
        double[] values = new double[PARAMETER_DEFAULT_VALUES.length];
        System.arraycopy(PARAMETER_DEFAULT_VALUES, 0, values, 0, values.length);
        return values;
    }

    @Override
    public Parameter[] getParameters() {
        return PARAMETERS;
    }

    @Override
    public boolean hasTransformUI() {
        return false;
    }

    @Override
    public MapTransformUI getTransformUI(MapTransform transform) {
        return new DefaultMapTransformUI(transform);
    }

    @Override
    public MapTransform createTransform(double[] parameterValues) {
        if (parameterValues == null) {
            parameterValues = this.getParameterDefaultValues();
        }
        return new MT(parameterValues);
    }

    private class MT
    implements MapTransform {
        private final ISEAG.RC _rcTemp = new ISEAG.RC();
        private final ISEAG.LL _llTemp = new ISEAG.LL();
        private ISEAG _grid;

        private MT(double[] parameterValues) {
            this((int)parameterValues[0]);
        }

        private MT(int rowCount) {
            Guardian.assertGreaterThan("rowCount", rowCount, 3L);
            this._grid = new ISEAG(rowCount);
        }

        @Override
        public MapTransformDescriptor getDescriptor() {
            return IntegerizedSinusoidalDescriptor.this;
        }

        @Override
        public double[] getParameterValues() {
            return new double[]{this._grid.getRowCount()};
        }

        @Override
        public Point2D forward(GeoPos geoPoint, Point2D mapPoint) {
            if (mapPoint == null) {
                mapPoint = new Point2D.Float();
            }
            this._grid.ll2rc(geoPoint.lat, geoPoint.lon, this._rcTemp);
            int ncols = this._grid.getColumnCount(this._rcTemp.row);
            double x = (double)this._rcTemp.col - 0.5 * (double)ncols;
            double y = this._rcTemp.row;
            mapPoint.setLocation(x, y);
            return mapPoint;
        }

        @Override
        public GeoPos inverse(Point2D mapPoint, GeoPos geoPoint) {
            if (geoPoint == null) {
                geoPoint = new GeoPos();
            }
            int ncols = this._grid.getColumnCount(this._rcTemp.row);
            double x = mapPoint.getX();
            double y = mapPoint.getY();
            int col = (int)Math.floor(x + 0.5 * (double)ncols);
            int row = (int)Math.floor(y);
            this._grid.rc2ll(row, col, this._llTemp);
            geoPoint.lon = (float)this._llTemp.lon;
            geoPoint.lat = (float)this._llTemp.lat;
            return geoPoint;
        }

        @Override
        public MapTransform createDeepClone() {
            return new MT(this._grid.getRowCount());
        }
    }
}

