/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.media.jai.Interpolation;
import javax.media.jai.operator.CropDescriptor;
import javax.media.jai.operator.ScaleDescriptor;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.BasicPixelGeoCoding;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.PixelGeoCoding;
import org.esa.snap.core.datamodel.PixelGeoCoding2;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Scene;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.runtime.Config;

public class GeoCodingFactory {
    public static final String USE_ALTERNATE_PIXEL_GEO_CODING_PROPERTY = "snap.useAlternatePixelGeoCoding";

    public static BasicPixelGeoCoding createPixelGeoCoding(Band latBand, Band lonBand, String validMask, int searchRadius) {
        if (GeoCodingFactory.useAlternatePixelGeoCoding()) {
            return new PixelGeoCoding(latBand, lonBand, validMask, searchRadius);
        }
        return new PixelGeoCoding2(latBand, lonBand, validMask, 2);
    }

    public static BasicPixelGeoCoding createPixelGeoCoding(Band latBand, Band lonBand, String validMask, int searchRadius, ProgressMonitor pm) throws IOException {
        if (GeoCodingFactory.useAlternatePixelGeoCoding()) {
            return new PixelGeoCoding(latBand, lonBand, validMask, searchRadius, pm);
        }
        return new PixelGeoCoding2(latBand, lonBand, validMask, 2);
    }

    private static boolean useAlternatePixelGeoCoding() {
        return Config.instance().preferences().getBoolean(USE_ALTERNATE_PIXEL_GEO_CODING_PROPERTY, false);
    }

    static void copyReferencedRasters(String validMaskExpression, Scene sourceScene, Scene targetScene, ProductSubsetDef subsetDef) throws ParseException {
        RasterDataNode[] nodes;
        Product targetProduct = targetScene.getProduct();
        for (RasterDataNode node : nodes = BandArithmetic.getRefRasters(validMaskExpression, sourceScene.getProduct())) {
            if (targetProduct.containsRasterDataNode(node.getName())) continue;
            if (node instanceof TiePointGrid) {
                TiePointGrid tpg = TiePointGrid.createSubset((TiePointGrid)node, subsetDef);
                targetProduct.addTiePointGrid(tpg);
            }
            if (!(node instanceof Band)) continue;
            Band sourceBand = (Band)node;
            Band band = GeoCodingFactory.createSubset(sourceBand, targetScene, subsetDef);
            targetProduct.addBand(band);
            GeoCodingFactory.setFlagCoding(band, sourceBand.getFlagCoding());
        }
    }

    static Band createSubset(Band sourceBand, Scene targetScene, ProductSubsetDef subsetDef) {
        Band targetBand = new Band(sourceBand.getName(), sourceBand.getDataType(), targetScene.getRasterWidth(), targetScene.getRasterHeight());
        ProductUtils.copyRasterDataNodeProperties(sourceBand, targetBand);
        targetBand.setSourceImage(GeoCodingFactory.getSourceImage(subsetDef, sourceBand));
        return targetBand;
    }

    static Mask createSubset(Mask sourceMask, Scene targetScene, ProductSubsetDef subsetDef) {
        Mask targetMask = Mask.BandMathsType.create(sourceMask.getName(), sourceMask.getDescription(), targetScene.getRasterWidth(), targetScene.getRasterHeight(), Mask.BandMathsType.getExpression(sourceMask), sourceMask.getImageColor(), sourceMask.getImageTransparency());
        targetMask.setSourceImage(GeoCodingFactory.getSourceImage(subsetDef, sourceMask));
        return targetMask;
    }

    private static void setFlagCoding(Band band, FlagCoding flagCoding) {
        if (flagCoding != null) {
            String flagCodingName = flagCoding.getName();
            Product product = band.getProduct();
            if (!product.getFlagCodingGroup().contains(flagCodingName)) {
                GeoCodingFactory.addFlagCoding(product, flagCoding);
            }
            band.setSampleCoding(product.getFlagCodingGroup().get(flagCodingName));
        }
    }

    private static void addFlagCoding(Product product, FlagCoding flagCoding) {
        FlagCoding targetFlagCoding = new FlagCoding(flagCoding.getName());
        targetFlagCoding.setDescription(flagCoding.getDescription());
        ProductUtils.copyMetadata(flagCoding, targetFlagCoding);
        product.getFlagCodingGroup().add(targetFlagCoding);
    }

    private static RenderedImage getSourceImage(ProductSubsetDef subsetDef, Band band) {
        MultiLevelImage sourceImage = band.getSourceImage();
        if (subsetDef != null) {
            int subSamplingY;
            int subSamplingX;
            Rectangle region = subsetDef.getRegion();
            if (region != null) {
                float x = region.x;
                float y = region.y;
                float width = region.width;
                float height = region.height;
                sourceImage = CropDescriptor.create((RenderedImage)sourceImage, (Float)Float.valueOf(x), (Float)Float.valueOf(y), (Float)Float.valueOf(width), (Float)Float.valueOf(height), null);
            }
            if (GeoCodingFactory.mustSubSample(subSamplingX = subsetDef.getSubSamplingX(), subSamplingY = subsetDef.getSubSamplingY()) || GeoCodingFactory.mustTranslate(region)) {
                float scaleX = 1.0f / (float)subSamplingX;
                float scaleY = 1.0f / (float)subSamplingY;
                float transX = region != null ? (float)(-region.x) : 0.0f;
                float transY = region != null ? (float)(-region.y) : 0.0f;
                Interpolation interpolation = Interpolation.getInstance((int)0);
                sourceImage = ScaleDescriptor.create((RenderedImage)sourceImage, (Float)Float.valueOf(scaleX), (Float)Float.valueOf(scaleY), (Float)Float.valueOf(transX), (Float)Float.valueOf(transY), (Interpolation)interpolation, null);
            }
        }
        return sourceImage;
    }

    private static boolean mustTranslate(Rectangle region) {
        return region != null && (region.x != 0 || region.y != 0);
    }

    private static boolean mustSubSample(int subSamplingX, int subSamplingY) {
        return subSamplingX != 1 || subSamplingY != 1;
    }

    public static double interpolateLon(double wx, double wy, double d00, double d10, double d01, double d11) {
        double range = GeoCodingFactory.computeRange(d00, d01, d10, d11);
        if (range > 180.0) {
            return GeoCodingFactory.interpolateSperical(wx, wy, d00, d10, d01, d11);
        }
        return MathUtils.interpolate2D(wx, wy, d00, d10, d01, d11);
    }

    private static double computeRange(double d00, double d01, double d10, double d11) {
        double min = Math.min(d00, Math.min(d01, Math.min(d10, d11)));
        double max = Math.max(d00, Math.max(d01, Math.max(d10, d11)));
        return max - min;
    }

    private static double interpolateSperical(double wx, double wy, double d00, double d10, double d01, double d11) {
        double r00 = Math.toRadians(d00);
        double s00 = Math.sin(r00);
        double c00 = Math.cos(r00);
        double r01 = Math.toRadians(d01);
        double s01 = Math.sin(r01);
        double c01 = Math.cos(r01);
        double r10 = Math.toRadians(d10);
        double s10 = Math.sin(r10);
        double c10 = Math.cos(r10);
        double r11 = Math.toRadians(d11);
        double s11 = Math.sin(r11);
        double c11 = Math.cos(r11);
        double sinAngle = MathUtils.interpolate2D(wx, wy, s00, s10, s01, s11);
        double cosAngle = MathUtils.interpolate2D(wx, wy, c00, c10, c01, c11);
        return 57.29577951308232 * Math.atan2(sinAngle, cosAngle);
    }
}

