/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.crs;

import com.bc.ceres.swing.TableLayout;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.crs.CrsForm;
import org.esa.snap.ui.crs.CrsInfo;
import org.esa.snap.ui.crs.CrsInfoListModel;
import org.esa.snap.ui.crs.PredefinedCrsPanel;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PredefinedCrsForm
extends CrsForm {
    private CrsInfo selectedCrsInfo;

    public PredefinedCrsForm(AppContext appContext) {
        super(appContext);
    }

    @Override
    protected String getLabelText() {
        return "Predefined CRS";
    }

    @Override
    public CoordinateReferenceSystem getCRS(GeoPos referencePos) throws FactoryException {
        if (this.selectedCrsInfo != null) {
            return this.selectedCrsInfo.getCrs(referencePos);
        }
        return null;
    }

    @Override
    public void prepareShow() {
    }

    @Override
    public void prepareHide() {
    }

    @Override
    protected JComponent createCrsComponent() {
        TableLayout tableLayout = new TableLayout(2);
        JPanel panel = new JPanel((LayoutManager)tableLayout);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setColumnWeightX(0, Double.valueOf(1.0));
        tableLayout.setColumnWeightX(1, Double.valueOf(0.0));
        JTextField crsCodeField = new JTextField();
        crsCodeField.setEditable(false);
        JButton crsButton = new JButton("Select...");
        PredefinedCrsPanel predefinedCrsForm = new PredefinedCrsPanel(new CrsInfoListModel(CrsInfo.generateCRSList()));
        crsButton.addActionListener(e -> {
            ModalDialog dialog = new ModalDialog(null, "Select Coordinate Reference System", predefinedCrsForm, 33, null);
            if (dialog.show() == 1) {
                this.selectedCrsInfo = predefinedCrsForm.getSelectedCrsInfo();
                if (this.selectedCrsInfo != null) {
                    crsCodeField.setText(this.selectedCrsInfo.toString());
                    this.fireCrsChanged();
                }
            }
        });
        panel.add(crsCodeField);
        panel.add(crsButton);
        panel.addPropertyChangeListener("enabled", evt -> {
            crsCodeField.setEnabled((Boolean)evt.getNewValue());
            crsButton.setEnabled((Boolean)evt.getNewValue());
        });
        return panel;
    }
}

