/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.crs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.ui.AppContext;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class CrsForm {
    private AppContext appContext;
    private Product referenceProduct;
    private ArrayList<PropertyChangeListener> changeListeners;
    private JComponent crsComponent;
    private JRadioButton radioButton;

    protected CrsForm(AppContext appContext) {
        this.appContext = appContext;
        this.changeListeners = new ArrayList();
    }

    protected abstract String getLabelText();

    boolean wrapAfterButton() {
        return false;
    }

    public final JRadioButton getRadioButton() {
        if (this.radioButton == null) {
            this.radioButton = this.createRadioButton();
        }
        return this.radioButton;
    }

    protected JRadioButton createRadioButton() {
        return new JRadioButton(this.getLabelText());
    }

    public abstract CoordinateReferenceSystem getCRS(GeoPos var1) throws FactoryException;

    public final JComponent getCrsUI() {
        if (this.crsComponent == null) {
            this.crsComponent = this.createCrsComponent();
        }
        return this.crsComponent;
    }

    protected abstract JComponent createCrsComponent();

    public void setReferenceProduct(Product product) {
        this.referenceProduct = product;
    }

    protected Product getReferenceProduct() {
        return this.referenceProduct;
    }

    protected AppContext getAppContext() {
        return this.appContext;
    }

    protected void fireCrsChanged() {
        for (PropertyChangeListener listener : this.changeListeners) {
            listener.propertyChange(new PropertyChangeEvent(this, "crs", null, null));
        }
    }

    protected boolean addCrsChangeListener(PropertyChangeListener listener) {
        if (!this.changeListeners.contains(listener)) {
            return this.changeListeners.add(listener);
        }
        return false;
    }

    protected boolean removeCrsChangeListener(PropertyChangeListener listener) {
        if (this.changeListeners.contains(listener)) {
            return this.changeListeners.remove(listener);
        }
        return false;
    }

    public abstract void prepareShow();

    public abstract void prepareHide();
}

