/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import com.bc.ceres.binding.ConversionException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.converters.RectangleConverter;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.runtime.Config;
import sun.swing.FilePane;

public class SnapFileChooser
extends JFileChooser {
    private static final Object syncFileFiltersObject = new Object();
    private static final String PREFERENCES_BOUNDS_OPEN = "snap.fileChooser.dialogBounds.open";
    private static final String PREFERENCES_BOUNDS_SAVE = "snap.fileChooser.dialogBounds.save";
    private static final String PREFERENCES_BOUNDS_CUSTOM = "snap.fileChooser.dialogBounds.custom";
    private static final String PREFERENCES_VIEW_TYPE = "snap.fileChooser.viewType";
    private final ResizeHandler resizeHandler;
    private final CloseHandler windowCloseHandler;
    private final Preferences snapPreferences = Config.instance((String)"snap").preferences();
    private String lastFilename;
    private Rectangle dialogBounds;

    public SnapFileChooser() {
        this((File)null, (FileSystemView)null);
    }

    public SnapFileChooser(FileSystemView fsv) {
        this((File)null, fsv);
    }

    public SnapFileChooser(File currentDirectory) {
        this(currentDirectory, null);
    }

    public SnapFileChooser(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
        this.resizeHandler = new ResizeHandler();
        this.windowCloseHandler = new CloseHandler();
        this.init();
    }

    @Override
    public Icon getIcon(File f) {
        Icon icon = null;
        if (f != null) {
            icon = super.getIcon(f);
            if (f.isDirectory() && this.isCompoundDocument(f)) {
                return new CompoundDocumentIcon(icon);
            }
        }
        return icon;
    }

    @Override
    public boolean isTraversable(File f) {
        return f.isDirectory() && !this.isCompoundDocument(f);
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        JDialog dialog = super.createDialog(parent);
        Rectangle dialogBounds = this.loadDialogBounds();
        if (dialogBounds != null) {
            dialog.setBounds(dialogBounds);
        }
        dialog.addComponentListener(this.resizeHandler);
        dialog.addWindowListener(this.windowCloseHandler);
        this.initViewType();
        return dialog;
    }

    @Override
    public void approveSelection() {
        Debug.trace((String)("SnapFileChooser: approveSelection(): selectedFile = " + this.getSelectedFile()));
        Debug.trace((String)("SnapFileChooser: approveSelection(): currentFilename = " + this.getCurrentFilename()));
        Debug.trace((String)("SnapFileChooser: approveSelection(): currentDirectory = " + this.getCurrentDirectory()));
        if (this.getDialogType() != 0) {
            this.ensureSelectedFileHasValidExtension();
        }
        super.approveSelection();
    }

    public Rectangle getDialogBounds() {
        return this.dialogBounds;
    }

    public void setDialogBounds(Rectangle rectangle) {
        this.dialogBounds = rectangle;
        this.storeDialogBounds(this.dialogBounds);
    }

    public String getCurrentFilename() {
        File selectedFile = this.getSelectedFile();
        if (selectedFile != null) {
            return selectedFile.getName();
        }
        return null;
    }

    public void setCurrentFilename(String currentFilename) {
        Debug.trace((String)("SnapFileChooser: setCurrentFilename(\"" + currentFilename + "\")"));
        String defaultExtension = this.getDefaultExtension();
        if (this.getDialogType() != 0 && currentFilename != null && defaultExtension != null) {
            FileNameExtensionFilter filter;
            FileFilter fileFilter = this.getFileFilter();
            if (fileFilter instanceof SnapFileFilter) {
                SnapFileFilter filter2 = (SnapFileFilter)fileFilter;
                if (!filter2.checkExtension(currentFilename)) {
                    currentFilename = FileUtils.exchangeExtension((String)currentFilename, (String)defaultExtension);
                }
            } else if (fileFilter instanceof FileNameExtensionFilter && !SnapFileFilter.checkExtensions((String)currentFilename, (String[])(filter = (FileNameExtensionFilter)fileFilter).getExtensions())) {
                currentFilename = FileUtils.exchangeExtension((String)currentFilename, (String)defaultExtension);
            }
        }
        if (currentFilename != null && currentFilename.length() > 0) {
            this.setSelectedFile(new File(this.getCurrentDirectory(), currentFilename));
        }
    }

    public SnapFileFilter getSnapFileFilter() {
        FileFilter ff = this.getFileFilter();
        if (ff instanceof SnapFileFilter) {
            return (SnapFileFilter)ff;
        }
        return null;
    }

    public String getDefaultExtension() {
        if (this.getSnapFileFilter() != null) {
            return this.getSnapFileFilter().getDefaultExtension();
        }
        return null;
    }

    public boolean checkExtension(String filename) {
        FileFilter[] fileFilters;
        if (filename != null && (fileFilters = this.getChoosableFileFilters()) != null) {
            for (FileFilter filter : fileFilters) {
                SnapFileFilter snapFileFilter;
                if (!(filter instanceof SnapFileFilter) || !(snapFileFilter = (SnapFileFilter)filter).checkExtension(filename)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileFilter[] getChoosableFileFilters() {
        Object object = syncFileFiltersObject;
        synchronized (object) {
            return super.getChoosableFileFilters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChoosableFileFilter(FileFilter filter) {
        Object object = syncFileFiltersObject;
        synchronized (object) {
            super.addChoosableFileFilter(filter);
        }
    }

    protected Window getWindow() {
        Container w = this;
        while (!(w instanceof Window)) {
            w = w.getParent();
        }
        return (Window)w;
    }

    private void init() {
        this.setAcceptAllFileFilterUsed(false);
        this.addPropertyChangeListener("SelectedFileChangedProperty", evt -> {
            Object newValue = evt.getNewValue();
            if (newValue instanceof File) {
                this.lastFilename = ((File)newValue).getName();
            }
        });
        this.addPropertyChangeListener("fileFilterChanged", evt -> {
            SnapFileFilter snapFileFilter = this.getSnapFileFilter();
            if (snapFileFilter != null) {
                this.setFileSelectionMode(snapFileFilter.getFileSelectionMode().getValue());
            } else {
                this.setFileSelectionMode(0);
            }
            if (this.getSelectedFile() != null) {
                return;
            }
            if (this.lastFilename == null || this.lastFilename.length() == 0) {
                return;
            }
            this.setCurrentFilename(this.lastFilename);
        });
    }

    private boolean isCompoundDocument(File file) {
        FileFilter[] filters;
        for (FileFilter fileFilter : filters = this.getChoosableFileFilters()) {
            SnapFileFilter snapFileFilter;
            if (!(fileFilter instanceof SnapFileFilter) || !(snapFileFilter = (SnapFileFilter)fileFilter).isCompoundDocument(file)) continue;
            return true;
        }
        return false;
    }

    private void ensureSelectedFileHasValidExtension() {
        SnapFileFilter mff;
        File selectedFile = this.getSelectedFile();
        if (selectedFile != null && (mff = this.getSnapFileFilter()) != null && mff.getDefaultExtension() != null && !mff.checkExtension(selectedFile)) {
            selectedFile = FileUtils.exchangeExtension((File)selectedFile, (String)mff.getDefaultExtension());
            Debug.trace((String)("mod. selected file: " + selectedFile.getPath()));
            this.setSelectedFile(selectedFile);
        }
    }

    private void storeDialogBounds(Rectangle bounds) {
        int dialogType = this.getDialogType();
        switch (dialogType) {
            case 0: {
                this.putRectangleToPreferences(PREFERENCES_BOUNDS_OPEN, bounds);
                break;
            }
            case 1: {
                this.putRectangleToPreferences(PREFERENCES_BOUNDS_SAVE, bounds);
                break;
            }
            default: {
                this.putRectangleToPreferences(PREFERENCES_BOUNDS_CUSTOM, bounds);
            }
        }
    }

    private Rectangle loadDialogBounds() {
        switch (this.getDialogType()) {
            case 0: {
                return this.getRectangleFromPreferences(PREFERENCES_BOUNDS_OPEN);
            }
            case 1: {
                return this.getRectangleFromPreferences(PREFERENCES_BOUNDS_SAVE);
            }
        }
        return this.getRectangleFromPreferences(PREFERENCES_BOUNDS_CUSTOM);
    }

    private void putRectangleToPreferences(String key, Rectangle bounds) {
        this.snapPreferences.put(key, new RectangleConverter().format(bounds));
    }

    private Rectangle getRectangleFromPreferences(String key) {
        String rectString = this.snapPreferences.get(key, null);
        if (rectString != null) {
            try {
                GraphicsDevice[] screenDevices;
                Rectangle rectangle = new RectangleConverter().parse(rectString);
                for (GraphicsDevice screenDevice : screenDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                    if (!screenDevice.getDefaultConfiguration().getBounds().contains(rectangle.getLocation())) continue;
                    return rectangle;
                }
            }
            catch (ConversionException e) {
                SystemUtils.LOG.log(Level.WARNING, "Not able to parse preferences value: " + rectString, e);
            }
        }
        return null;
    }

    private void initViewType() {
        FilePane filePane = this.findFilePane(this);
        if (filePane != null) {
            int viewType = this.snapPreferences.getInt(PREFERENCES_VIEW_TYPE, 0);
            filePane.setViewType(viewType);
        }
    }

    private FilePane findFilePane(Container root) {
        Component[] components;
        for (Component component : components = root.getComponents()) {
            FilePane filePane;
            if (component instanceof FilePane) {
                return (FilePane)component;
            }
            if (!(component instanceof Container) || (filePane = this.findFilePane((Container)component)) == null) continue;
            return filePane;
        }
        return null;
    }

    private class CloseHandler
    extends WindowAdapter {
        private CloseHandler() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            FilePane filePane = SnapFileChooser.this.findFilePane(SnapFileChooser.this);
            if (filePane != null) {
                SnapFileChooser.this.snapPreferences.putInt(SnapFileChooser.PREFERENCES_VIEW_TYPE, filePane.getViewType());
                this.flushPreferences();
            }
        }

        private void flushPreferences() {
            try {
                SnapFileChooser.this.snapPreferences.flush();
            }
            catch (BackingStoreException bse) {
                SystemUtils.LOG.severe("Could not store preferences: " + bse.getMessage());
            }
        }
    }

    private static class CompoundDocumentIcon
    implements Icon {
        private final Icon baseIcon;
        private static final Icon compoundDocumentIcon = new ImageIcon(CompoundDocumentIcon.class.getResource("CompoundDocument12.png"));

        public CompoundDocumentIcon(Icon baseIcon) {
            this.baseIcon = baseIcon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.baseIcon.paintIcon(c, g, x, y);
            compoundDocumentIcon.paintIcon(c, g, x + this.baseIcon.getIconWidth() - compoundDocumentIcon.getIconWidth(), y + this.baseIcon.getIconHeight() - compoundDocumentIcon.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return this.baseIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.baseIcon.getIconHeight();
        }
    }

    private class ResizeHandler
    extends ComponentAdapter {
        private ResizeHandler() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            SnapFileChooser.this.setDialogBounds(e.getComponent().getBounds());
        }

        @Override
        public void componentResized(ComponentEvent e) {
            SnapFileChooser.this.setDialogBounds(e.getComponent().getBounds());
        }
    }
}

