/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.dataio.ProductSubsetBuilder;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.common.WriteOp;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.gpf.CommonReaders;
import org.esa.snap.engine_utilities.util.ProductFunctions;
import org.esa.snap.engine_utilities.util.TestUtils;

public class TestProcessor {
    private final int subsetX;
    private final int subsetY;
    private final int subsetWidth;
    private final int subsetHeight;
    private final int maxIteration;
    private final boolean canTestReadersOnAllProducts;
    private final boolean canTestProcessingOnAllProducts;
    private static final ProductFunctions.ValidProductFileFilter fileFilter = new ProductFunctions.ValidProductFileFilter(false);

    public TestProcessor() {
        this(100, 100, 100, 100, 1, false, false);
    }

    public TestProcessor(int subsetX, int subsetY, int subsetWidth, int subsetHeight, int maxIteration, boolean canTestReaders, boolean canTestProcessing) {
        this.subsetX = subsetX;
        this.subsetY = subsetY;
        this.subsetWidth = subsetWidth;
        this.subsetHeight = subsetHeight;
        this.maxIteration = maxIteration;
        this.canTestReadersOnAllProducts = canTestReaders;
        this.canTestProcessingOnAllProducts = canTestProcessing;
    }

    public static void executeOperator(Operator op) throws Exception {
        Product targetProduct = op.getTargetProduct();
        TestUtils.verifyProduct(targetProduct, true, true, true);
    }

    public Product createSubsetProduct(Product sourceProduct) throws IOException {
        int bandWidth = sourceProduct.getSceneRasterWidth();
        int bandHeight = sourceProduct.getSceneRasterHeight();
        ProductSubsetBuilder subsetReader = new ProductSubsetBuilder();
        ProductSubsetDef subsetDef = new ProductSubsetDef();
        subsetDef.addNodeNames(sourceProduct.getTiePointGridNames());
        subsetDef.addNodeNames(sourceProduct.getBandNames());
        int w = TestProcessor.within(this.subsetWidth, bandWidth);
        int h = TestProcessor.within(this.subsetHeight, bandHeight);
        subsetDef.setRegion(TestProcessor.within(this.subsetX, bandWidth - w), TestProcessor.within(this.subsetY, bandHeight - h), w, h);
        subsetDef.setIgnoreMetadata(false);
        subsetDef.setTreatVirtualBandsAsRealBands(false);
        Product subsetProduct = subsetReader.readProductNodes((Object)sourceProduct, subsetDef);
        subsetProduct.setFileLocation(sourceProduct.getFileLocation());
        if (subsetProduct.getSceneRasterWidth() > this.subsetWidth || subsetProduct.getSceneRasterHeight() > this.subsetHeight) {
            throw new IOException("product size mismatch");
        }
        return subsetProduct;
    }

    public Product writeSubsetProduct(Product sourceProduct) throws IOException {
        int bandWidth = sourceProduct.getSceneRasterWidth();
        int bandHeight = sourceProduct.getSceneRasterHeight();
        ProductSubsetBuilder subsetReader = new ProductSubsetBuilder();
        ProductSubsetDef subsetDef = new ProductSubsetDef();
        subsetDef.addNodeNames(sourceProduct.getTiePointGridNames());
        String bandName = ProductUtils.findSuitableQuicklookBandName((Product)sourceProduct);
        subsetDef.addNodeNames(new String[]{bandName});
        int w = TestProcessor.within(this.subsetWidth, bandWidth);
        int h = TestProcessor.within(this.subsetHeight, bandHeight);
        subsetDef.setRegion(TestProcessor.within(this.subsetX, bandWidth - w), TestProcessor.within(this.subsetY, bandHeight - h), w, h);
        subsetDef.setIgnoreMetadata(false);
        subsetDef.setTreatVirtualBandsAsRealBands(true);
        Product subsetProduct = subsetReader.readProductNodes((Object)sourceProduct, subsetDef);
        File tmpFile = new File(SystemUtils.getCacheDir(), "tmp_subset.dim");
        WriteOp writer = new WriteOp(subsetProduct, tmpFile, "BEAM-DIMAP");
        writer.writeProduct(ProgressMonitor.NULL);
        return ProductIO.readProduct((File)tmpFile);
    }

    private static int within(int val, int max) {
        return Math.max(0, Math.min(val, max));
    }

    public static void recurseFindReadableProducts(File origFolder, ArrayList<File> productList, int maxCount) throws Exception {
        File[] fileList;
        File[] folderList = origFolder.listFiles(ProductFunctions.directoryFileFilter);
        if (folderList != null) {
            for (File folder : folderList) {
                if (folder.getName().contains("skipTest")) continue;
                TestProcessor.recurseFindReadableProducts(folder, productList, maxCount);
            }
        }
        if ((fileList = origFolder.listFiles(new ProductFunctions.ValidProductFileFilter())) != null) {
            for (File file : fileList) {
                if (maxCount > 0 && productList.size() >= maxCount) {
                    return;
                }
                try {
                    ProductReader reader = ProductIO.getProductReaderForInput((Object)file);
                    if (reader != null) {
                        productList.add(file);
                        continue;
                    }
                    SystemUtils.LOG.warning(file.getAbsolutePath() + " is non valid");
                }
                catch (Exception e) {
                    boolean ok = false;
                    if (ok) continue;
                    SystemUtils.LOG.severe("Failed to process " + file.toString());
                    throw e;
                }
            }
        }
    }

    private int recurseProcessFolder(OperatorSpi spi, File origFolder, String format, int iterations, String[] productTypeExemptions, String[] exceptionExemptions) throws Exception {
        File[] fileList;
        File[] folderList = origFolder.listFiles(ProductFunctions.directoryFileFilter);
        if (folderList != null) {
            for (File folder : folderList) {
                if (this.maxIteration > 0 && iterations >= this.maxIteration) break;
                if (folder.getName().contains("skipTest")) continue;
                iterations = this.recurseProcessFolder(spi, folder, format, iterations, productTypeExemptions, exceptionExemptions);
            }
        }
        ProductReader reader = null;
        if (format != null) {
            reader = ProductIO.getProductReader((String)format);
        }
        if ((fileList = origFolder.listFiles(new ProductFunctions.ValidProductFileFilter())) != null) {
            for (File file : fileList) {
                if (this.maxIteration > 0 && iterations >= this.maxIteration) break;
                try {
                    if (reader != null) {
                        if (reader.getReaderPlugIn().getDecodeQualification((Object)file) != DecodeQualification.INTENDED) {
                            continue;
                        }
                    } else {
                        reader = CommonReaders.findCommonProductReader(file);
                        if (reader == null) {
                            reader = ProductIO.getProductReaderForInput((Object)file);
                        }
                    }
                    if (reader != null) {
                        Product sourceProduct = reader.readProductNodes((Object)file, null);
                        if (productTypeExemptions != null && TestProcessor.containsProductType(productTypeExemptions, sourceProduct.getProductType())) continue;
                        TestUtils.verifyProduct(sourceProduct, true, true, false);
                        Product subsetProduct = this.createSubsetProduct(sourceProduct);
                        Operator op = spi.createOperator();
                        op.setSourceProduct(subsetProduct);
                        SystemUtils.LOG.info(spi.getOperatorAlias() + " Processing [" + iterations + "] " + file.toString());
                        TestProcessor.executeOperator(op);
                        SystemUtils.freeAllMemory();
                        ++iterations;
                        continue;
                    }
                    SystemUtils.LOG.warning(file.getAbsolutePath() + " is non valid");
                }
                catch (Exception e) {
                    boolean ok = false;
                    if (exceptionExemptions != null) {
                        for (String exemption : exceptionExemptions) {
                            if (e.getMessage() == null || !e.getMessage().contains(exemption)) continue;
                            ok = true;
                            SystemUtils.LOG.info("Exemption for " + e.getMessage());
                            break;
                        }
                    }
                    if (ok) continue;
                    SystemUtils.LOG.severe("Failed to process " + file.toString());
                    throw e;
                }
            }
        }
        return iterations;
    }

    public static boolean containsProductType(String[] productTypeExemptions, String productType) {
        if (productTypeExemptions != null) {
            for (String str : productTypeExemptions) {
                if (!productType.contains(str)) continue;
                return true;
            }
        }
        return false;
    }

    public void testProcessAllInPath(OperatorSpi spi, File[] folderPaths, String[] productTypeExemptions, String[] exceptionExemptions) throws Exception {
        this.testProcessAllInPath(spi, folderPaths, null, productTypeExemptions, exceptionExemptions);
    }

    public void testProcessAllInPath(OperatorSpi spi, File[] folderPaths, String format, String[] productTypeExemptions, String[] exceptionExemptions) throws Exception {
        if (this.canTestProcessingOnAllProducts) {
            for (File folder : folderPaths) {
                if (!folder.exists()) {
                    TestUtils.skipTest(spi, folder + " not found");
                    continue;
                }
                int iterations = 0;
                this.recurseProcessFolder(spi, folder, format, iterations, productTypeExemptions, exceptionExemptions);
            }
        }
    }

    public void recurseReadFolder(Object callingClass, File[] folderPaths, ProductReaderPlugIn readerPlugin, ProductReader reader, String[] productTypeExemptions, String[] exceptionExemptions) throws Exception {
        if (!this.canTestReadersOnAllProducts) {
            return;
        }
        for (File folderPath : folderPaths) {
            if (!folderPath.exists()) {
                TestUtils.skipTest(callingClass, "Folder " + folderPath + " not found");
                continue;
            }
            this.recurseReadFolder(folderPath, readerPlugin, reader, productTypeExemptions, exceptionExemptions, 0);
        }
    }

    private int recurseReadFolder(File origFolder, ProductReaderPlugIn readerPlugin, ProductReader reader, String[] productTypeExemptions, String[] exceptionExemptions, int iterations) throws Exception {
        File[] files;
        File[] folderList = origFolder.listFiles(ProductFunctions.directoryFileFilter);
        if (folderList != null) {
            for (File folder : folderList) {
                if (folder.getName().contains("skipTest")) continue;
                iterations = this.recurseReadFolder(folder, readerPlugin, reader, productTypeExemptions, exceptionExemptions, iterations);
                if (this.maxIteration <= 0 || iterations < this.maxIteration) continue;
                return iterations;
            }
        }
        if ((files = origFolder.listFiles(fileFilter)) != null) {
            for (File file : files) {
                if (readerPlugin.getDecodeQualification((Object)file) != DecodeQualification.INTENDED) continue;
                try {
                    SystemUtils.LOG.info("Reading [" + iterations + "] " + file.toString());
                    Product product = reader.readProductNodes((Object)file, null);
                    if (productTypeExemptions != null && TestProcessor.containsProductType(productTypeExemptions, product.getProductType())) continue;
                    TestUtils.verifyProduct(product, true, true, false);
                    if (this.maxIteration <= 0 || ++iterations < this.maxIteration) continue;
                    break;
                }
                catch (Exception e) {
                    boolean ok = false;
                    if (exceptionExemptions != null) {
                        for (String exemption : exceptionExemptions) {
                            if (e.getMessage() == null || !e.getMessage().contains(exemption)) continue;
                            ok = true;
                            SystemUtils.LOG.info("Exemption for " + e.getMessage());
                            break;
                        }
                    }
                    if (ok) continue;
                    SystemUtils.LOG.severe("Failed to read " + file.toString());
                    throw e;
                }
            }
        }
        return iterations;
    }
}

