/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.db;

import com.bc.ceres.core.ProgressMonitor;
import java.sql.SQLException;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.db.DBQuery;
import org.esa.snap.engine_utilities.db.ProductDB;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.engine_utilities.db.ProductQueryInterface;

public class DBProductQuery
implements ProductQueryInterface {
    private static DBProductQuery instance;
    private ProductEntry[] productEntryList = null;
    private ProductDB db;
    private static final String[] emptyStringList;

    private DBProductQuery() {
    }

    public static DBProductQuery instance() {
        if (instance == null) {
            instance = new DBProductQuery();
        }
        return instance;
    }

    @Override
    public boolean isReady() {
        return this.db != null && this.db.isReady();
    }

    public ProductDB getDB() {
        return this.db;
    }

    @Override
    public boolean partialQuery(DBQuery dbQuery) throws Exception {
        return this.fullQuery(dbQuery, ProgressMonitor.NULL);
    }

    @Override
    public boolean fullQuery(DBQuery dbQuery, ProgressMonitor pm) throws Exception {
        if (this.db == null) {
            this.db = ProductDB.instance();
        }
        if (this.productEntryList != null) {
            ProductEntry.dispose(this.productEntryList);
        }
        if (this.db.isReady()) {
            this.productEntryList = dbQuery.queryDatabase(this.db);
            return true;
        }
        return false;
    }

    @Override
    public ProductEntry[] getProductEntryList() {
        return this.productEntryList;
    }

    @Override
    public String[] getAllMissions() {
        try {
            if (this.db != null) {
                return this.db.getAllMissions();
            }
        }
        catch (SQLException e) {
            SystemUtils.LOG.severe("Error getting missions from database " + e.getMessage());
        }
        return emptyStringList;
    }

    @Override
    public String[] getAllProductTypes(String[] missions) {
        try {
            if (this.db != null) {
                return this.db.getProductTypes(missions);
            }
        }
        catch (SQLException e) {
            SystemUtils.LOG.severe("Error getting product types from database " + e.getMessage());
        }
        return emptyStringList;
    }

    @Override
    public String[] getAllAcquisitionModes(String[] missions) {
        try {
            if (this.db != null) {
                return this.db.getAcquisitionModes(missions);
            }
        }
        catch (SQLException e) {
            SystemUtils.LOG.severe("Error getting acquisition modes from database " + e.getMessage());
        }
        return emptyStringList;
    }

    static {
        emptyStringList = new String[0];
    }
}

