/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.datamodel;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.runtime.Config;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;

public class Credentials {
    private final Preferences credentialsPreferences = Config.instance((String)"Credentials").load().preferences();
    private static final String PREFIX = "credential.";
    private static final String USER = ".user";
    private static final String PASSWORD = ".password";
    private static Credentials instance;
    private StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();

    private Credentials() {
        this.encryptor.setPassword("Mzg1YWFkNjY0MjA2MGY1ZTIyMThjYjFj");
    }

    public static Credentials instance() {
        if (instance == null) {
            instance = new Credentials();
        }
        return instance;
    }

    public void put(String host, String user, String password) {
        this.credentialsPreferences.put(PREFIX + host + USER, user);
        this.credentialsPreferences.put(PREFIX + host + PASSWORD, this.encryptor.encrypt(password));
        try {
            this.credentialsPreferences.flush();
        }
        catch (BackingStoreException e) {
            SystemUtils.LOG.severe(e.getMessage());
        }
    }

    public CredentialInfo get(String host) {
        String user = this.credentialsPreferences.get(PREFIX + host + USER, null);
        String encryptedPassword = this.credentialsPreferences.get(PREFIX + host + PASSWORD, null);
        String password = null;
        try {
            password = this.encryptor.decrypt(encryptedPassword);
        }
        catch (Exception e) {
            SystemUtils.LOG.severe(e.getMessage());
        }
        return user == null || password == null ? null : new CredentialInfo(user, password);
    }

    public static class CredentialInfo {
        private final String user;
        private final String password;

        CredentialInfo(String user, String password) {
            this.user = user;
            this.password = password;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

