/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.netcdf.AbstractNetCdfReaderPlugIn;
import org.esa.snap.dataio.netcdf.GenericNetCdfReader;
import org.esa.snap.dataio.netcdf.util.Constants;
import org.esa.snap.dataio.netcdf.util.NetcdfFileOpener;
import ucar.nc2.NetcdfFile;

public class GenericNetCdfReaderPlugIn
implements ProductReaderPlugIn {
    private static AbstractNetCdfReaderPlugIn[] netCdfReaderPlugIns;
    private static final Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecodeQualification getDecodeQualification(Object input) {
        block18: {
            DecodeQualification decodeQualification;
            if (input == null) {
                return DecodeQualification.UNABLE;
            }
            NetcdfFile netcdfFile = null;
            try {
                String inputPath = input.toString();
                List<String> extensionList = Arrays.asList(this.getDefaultFileExtensions());
                for (String extension : extensionList) {
                    if (!inputPath.endsWith(extension)) continue;
                    netcdfFile = NetcdfFileOpener.open(inputPath);
                    LOGGER.warning("GenericNetCdfReaderPlugIn.getDecodeQualification(" + inputPath + ") extension=" + extension + " netcdfFile=" + netcdfFile);
                    break;
                }
                if (netcdfFile == null) {
                    DecodeQualification decodeQualification2 = DecodeQualification.UNABLE;
                    return decodeQualification2;
                }
                AbstractNetCdfReaderPlugIn[] plugIns = GenericNetCdfReaderPlugIn.getAllNetCdfReaderPlugIns();
                decodeQualification = this.getDecodeQualification(plugIns, netcdfFile);
            }
            catch (Throwable ignored) {
                ignored.printStackTrace();
                break block18;
            }
            finally {
                try {
                    if (netcdfFile != null) {
                        netcdfFile.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return decodeQualification;
        }
        return DecodeQualification.UNABLE;
    }

    private DecodeQualification getDecodeQualification(AbstractNetCdfReaderPlugIn[] plugIns, NetcdfFile netcdfFile) {
        for (AbstractNetCdfReaderPlugIn plugIn : plugIns) {
            try {
                DecodeQualification decodeQualification = plugIn.getDecodeQualification(netcdfFile);
                if (!DecodeQualification.INTENDED.equals((Object)decodeQualification) && !DecodeQualification.SUITABLE.equals((Object)decodeQualification)) continue;
                return DecodeQualification.SUITABLE;
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return Constants.READER_INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new GenericNetCdfReader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }

    public String[] getFormatNames() {
        return new String[]{"NetCDF"};
    }

    public String[] getDefaultFileExtensions() {
        AbstractNetCdfReaderPlugIn[] abstractNetCdfReaderPlugIns;
        HashSet<String> extensionSet = new HashSet<String>();
        for (AbstractNetCdfReaderPlugIn plugIn : abstractNetCdfReaderPlugIns = GenericNetCdfReaderPlugIn.getAllNetCdfReaderPlugIns()) {
            String[] fileExtensions = plugIn.getDefaultFileExtensions();
            extensionSet.addAll(Arrays.asList(fileExtensions));
        }
        return extensionSet.toArray(new String[extensionSet.size()]);
    }

    public String getDescription(Locale locale) {
        return "Generic NetCDF Data Product";
    }

    static AbstractNetCdfReaderPlugIn[] getAllNetCdfReaderPlugIns() {
        if (netCdfReaderPlugIns == null) {
            ProductIOPlugInManager plugInManager = ProductIOPlugInManager.getInstance();
            Iterator allReaderPlugIns = plugInManager.getAllReaderPlugIns();
            ArrayList<AbstractNetCdfReaderPlugIn> netCdfReaderPlugInList = new ArrayList<AbstractNetCdfReaderPlugIn>();
            while (allReaderPlugIns.hasNext()) {
                ProductReaderPlugIn readerPlugIn = (ProductReaderPlugIn)allReaderPlugIns.next();
                if (!(readerPlugIn instanceof AbstractNetCdfReaderPlugIn)) continue;
                AbstractNetCdfReaderPlugIn netCdfReaderPlugIn = (AbstractNetCdfReaderPlugIn)readerPlugIn;
                netCdfReaderPlugInList.add(netCdfReaderPlugIn);
            }
            netCdfReaderPlugIns = netCdfReaderPlugInList.toArray(new AbstractNetCdfReaderPlugIn[netCdfReaderPlugInList.size()]);
        }
        return netCdfReaderPlugIns;
    }

    static {
        LOGGER = Logger.getLogger(GenericNetCdfReaderPlugIn.class.getName());
    }
}

