/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.AverageVisitor;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MedianVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.StandardDeviationVisitor;
import org.geotools.feature.visitor.SumVisitor;
import org.geotools.util.Converters;
import org.opengis.filter.expression.Expression;

public enum Aggregate {
    AVERAGE{

        @Override
        public FeatureCalc create(Expression aggregateAttribute) {
            return new AverageVisitor(aggregateAttribute);
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            return new AverageVisitor.AverageResult(value);
        }
    }
    ,
    COUNT{

        @Override
        public FeatureCalc create(Expression aggregateAttribute) {
            return new CountVisitor();
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            int count = (Integer)Converters.convert((Object)value, Integer.class);
            return new CountVisitor.CountResult(count);
        }
    }
    ,
    MAX{

        @Override
        public FeatureCalc create(Expression aggregateAttribute) {
            return new MaxVisitor(aggregateAttribute);
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            return new MaxVisitor.MaxResult((Comparable)value);
        }
    }
    ,
    MEDIAN{

        @Override
        public FeatureCalc create(Expression aggregateAttribute) {
            return new MedianVisitor(aggregateAttribute);
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            return new MedianVisitor.MedianResult(value);
        }
    }
    ,
    MIN{

        @Override
        public FeatureCalc create(Expression aggregateAttribute) {
            return new MinVisitor(aggregateAttribute);
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            return new MinVisitor.MinResult((Comparable)value);
        }
    }
    ,
    STD_DEV{

        @Override
        public FeatureCalc create(Expression expr) {
            return new StandardDeviationVisitor(expr);
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            if (value == null) {
                return AbstractCalcResult.NULL_RESULT;
            }
            Double deviation = (Double)Converters.convert((Object)value, Double.class);
            return new StandardDeviationVisitor.Result(deviation);
        }
    }
    ,
    SUM{

        @Override
        public FeatureCalc create(Expression expr) {
            return new SumVisitor(expr);
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            return new SumVisitor.SumResult(value);
        }
    };


    public abstract FeatureCalc create(Expression var1);

    public abstract CalcResult wrap(Expression var1, Object var2);

    public static Aggregate valueOfIgnoreCase(String visitorName) {
        if ("stddev".equalsIgnoreCase(visitorName)) {
            return STD_DEV;
        }
        return Aggregate.valueOf(visitorName.toUpperCase());
    }
}

