/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.dem.dataio.DEMFactory;
import org.esa.snap.dem.dataio.FileElevationModel;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileGeoreferencing;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="AddElevation", category="Raster/DEM Tools", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2017 by Array Systems Computing Inc.", description="Creates a DEM band")
public final class AddElevationOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The digital elevation model.", defaultValue="SRTM 3Sec", label="Digital Elevation Model")
    private String demName = "SRTM 3Sec";
    @Parameter(defaultValue="BICUBIC_INTERPOLATION", label="DEM Resampling Method")
    private String demResamplingMethod = "BICUBIC_INTERPOLATION";
    @Parameter(label="External DEM")
    private File externalDEMFile = null;
    @Parameter(label="DEM No Data Value", defaultValue="0")
    private double externalDEMNoDataValue = 0.0;
    @Parameter(description="The elevation band name.", defaultValue="elevation", label="Elevation Band Name")
    private String elevationBandName = "elevation";
    private ElevationModel dem = null;
    private double demNoDataValue = 0.0;
    private Band elevationBand = null;
    public static final String externalDEMStr = "External DEM";

    public void initialize() throws OperatorException {
        this.ensureSingleRasterSize(new Product[]{this.sourceProduct});
        try {
            if (!this.demName.contains(externalDEMStr)) {
                DEMFactory.checkIfDEMInstalled(this.demName);
            }
            DEMFactory.validateDEM(this.demName, this.sourceProduct);
            this.initElevationModel();
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        for (Band band : this.sourceProduct.getBands()) {
            if (band.getName().equalsIgnoreCase(this.elevationBandName)) {
                throw new OperatorException("Band " + this.elevationBandName + " already exists. Try another name.");
            }
            if (band instanceof VirtualBand) {
                ProductUtils.copyVirtualBand((Product)this.targetProduct, (VirtualBand)((VirtualBand)band), (String)band.getName());
                continue;
            }
            if (this.targetProduct.containsBand(band.getName())) continue;
            Band targetBand = ProductUtils.copyBand((String)band.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
            targetBand.setSourceImage(band.getSourceImage());
        }
        this.elevationBand = this.targetProduct.addBand(this.elevationBandName, 30);
        this.elevationBand.setNoDataValue(this.demNoDataValue);
        this.elevationBand.setNoDataValueUsed(true);
        this.elevationBand.setUnit("meters");
        this.elevationBand.setDescription(this.demName);
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            Rectangle targetRectangle = targetTile.getRectangle();
            int x0 = targetRectangle.x;
            int y0 = targetRectangle.y;
            int w = targetRectangle.width;
            int h = targetRectangle.height;
            ProductData tgtData = targetTile.getDataBuffer();
            TileGeoreferencing tileGeoRef = new TileGeoreferencing(this.targetProduct, x0, y0, w, h);
            double[][] localDEM = new double[h + 2][w + 2];
            boolean valid = DEMFactory.getLocalDEM(this.dem, this.demNoDataValue, this.demResamplingMethod, tileGeoRef, x0, y0, w, h, this.sourceProduct, true, localDEM);
            TileIndex tgtIndex = new TileIndex(targetTile);
            int maxX = x0 + w;
            int maxY = y0 + h;
            if (valid) {
                for (int y = y0; y < maxY; ++y) {
                    int yy = y - y0 + 1;
                    tgtIndex.calculateStride(y);
                    for (int x = x0; x < maxX; ++x) {
                        tgtData.setElemDoubleAt(tgtIndex.getIndex(x), localDEM[yy][x - x0 + 1]);
                    }
                }
            } else {
                for (int y = y0; y < maxY; ++y) {
                    tgtIndex.calculateStride(y);
                    for (int x = x0; x < maxX; ++x) {
                        tgtData.setElemDoubleAt(tgtIndex.getIndex(x), this.demNoDataValue);
                    }
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void initElevationModel() throws IOException {
        if (this.demName.contains(externalDEMStr) && this.externalDEMFile != null) {
            this.dem = new FileElevationModel(this.externalDEMFile, this.demResamplingMethod, this.externalDEMNoDataValue);
            this.demNoDataValue = this.externalDEMNoDataValue;
            this.demName = this.externalDEMFile.getPath();
        } else {
            this.dem = DEMFactory.createElevationModel(this.demName, this.demResamplingMethod);
            this.demNoDataValue = this.dem.getDescriptor().getNoDataValue();
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(AddElevationOp.class);
        }
    }
}

