/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.srtm1_hgt;

import java.io.IOException;
import org.esa.snap.core.dataop.dem.AbstractElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.dem.dataio.srtm1_hgt.SRTM1HgtElevationModel;

public class SRTM1HgtElevationModelDescriptor
extends AbstractElevationModelDescriptor {
    private static final String NAME = "SRTM 1Sec HGT";
    private static final int NUM_X_TILES = 360;
    private static final int NUM_Y_TILES = 120;
    private static final int DEGREE_RES = 1;
    public static final int PIXEL_RES = 3600;
    public static final int NO_DATA_VALUE = Short.MIN_VALUE;
    private static final int RASTER_WIDTH = 1296000;
    private static final int RASTER_HEIGHT = 432000;

    public String getName() {
        return NAME;
    }

    public int getNumXTiles() {
        return 360;
    }

    public int getNumYTiles() {
        return 120;
    }

    public float getNoDataValue() {
        return -32768.0f;
    }

    public int getRasterWidth() {
        return 1296000;
    }

    public int getRasterHeight() {
        return 432000;
    }

    public int getTileWidthInDegrees() {
        return 1;
    }

    public int getTileWidth() {
        return 3600;
    }

    public boolean canBeDownloaded() {
        return true;
    }

    public ElevationModel createDem(Resampling resampling) {
        try {
            return new SRTM1HgtElevationModel(this, resampling);
        }
        catch (IOException e) {
            return null;
        }
    }
}

