/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.srtm1_hgt;

import java.io.File;
import java.io.IOException;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.dataop.dem.BaseElevationModel;
import org.esa.snap.core.dataop.dem.ElevationFile;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.dem.dataio.srtm1_hgt.SRTM1HgtElevationModelDescriptor;
import org.esa.snap.dem.dataio.srtm1_hgt.SRTM1HgtFile;
import org.esa.snap.dem.dataio.srtm1_hgt.SRTMHGTReaderPlugIn;

public class SRTM1HgtElevationModel
extends BaseElevationModel {
    private static final ProductReaderPlugIn productReaderPlugIn = SRTM1HgtElevationModel.getReaderPlugIn((String)SRTMHGTReaderPlugIn.FORMAT_NAMES[0]);

    public SRTM1HgtElevationModel(SRTM1HgtElevationModelDescriptor descriptor, Resampling resamplingMethod) throws IOException {
        super((ElevationModelDescriptor)descriptor, resamplingMethod);
    }

    public double getIndexX(GeoPos geoPos) {
        return (geoPos.lon + 180.0) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILEinv;
    }

    public double getIndexY(GeoPos geoPos) {
        return (60.0 - geoPos.lat) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILEinv;
    }

    public GeoPos getGeoPos(PixelPos pixelPos) {
        double pixelLat = ((double)this.RASTER_HEIGHT - pixelPos.y) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 60.0;
        double pixelLon = pixelPos.x * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 180.0;
        return new GeoPos(pixelLat, pixelLon);
    }

    protected void createElevationFile(ElevationFile[][] elevationFiles, int x, int y, File demInstallDir) {
        int minLon = x * this.DEGREE_RES - 180;
        int minLat = y * this.DEGREE_RES - 60;
        String fileName = this.createTileFilename(minLat, minLon);
        File localFile = new File(demInstallDir, fileName);
        elevationFiles[x][this.NUM_Y_TILES - 1 - y] = new SRTM1HgtFile(this, localFile, productReaderPlugIn.createReaderInstance());
    }

    private String createTileFilename(int minLat, int minLon) {
        StringBuilder name = new StringBuilder();
        name.append(minLat < 0 ? "S" : "N");
        String latString = String.valueOf(Math.abs(minLat));
        while (latString.length() < 2) {
            latString = '0' + latString;
        }
        name.append(latString);
        name.append(minLon < 0 ? "W" : "E");
        String lonString = String.valueOf(Math.abs(minLon));
        while (lonString.length() < 3) {
            lonString = '0' + lonString;
        }
        name.append(lonString);
        name.append(".SRTMGL1.hgt.zip");
        return name.toString();
    }
}

