/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.srtm1_esrigrid;

import java.io.File;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.dataop.dem.BaseElevationModel;
import org.esa.snap.core.dataop.dem.ElevationFile;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.dem.dataio.srtm1_esrigrid.SRTM1GridElevationModelDescriptor;
import org.esa.snap.dem.dataio.srtm1_esrigrid.SRTM1GridFile;

public final class SRTM1GridElevationModel
extends BaseElevationModel {
    private static final ProductReaderPlugIn productReaderPlugIn = SRTM1GridElevationModel.getReaderPlugIn((String)"ARC_INFO_BIN_GRID");

    public SRTM1GridElevationModel(SRTM1GridElevationModelDescriptor descriptor, Resampling resamplingMethod) {
        super((ElevationModelDescriptor)descriptor, resamplingMethod);
        this.setMaxCacheSize(12);
    }

    public double getIndexX(GeoPos geoPos) {
        return (geoPos.lon + 180.0) / this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE;
    }

    public double getIndexY(GeoPos geoPos) {
        return (double)this.RASTER_HEIGHT - (geoPos.lat + 60.0) / this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE;
    }

    public GeoPos getGeoPos(PixelPos pixelPos) {
        double pixelLat = ((double)this.RASTER_HEIGHT - pixelPos.y) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 60.0;
        double pixelLon = pixelPos.x * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 180.0;
        return new GeoPos(pixelLat, pixelLon);
    }

    protected void createElevationFile(ElevationFile[][] elevationFiles, int x, int y, File demInstallDir) {
        int minLon = x * this.DEGREE_RES - 180;
        int minLat = y * this.DEGREE_RES - 60;
        String folderName = this.createTileFilename(minLat, minLon);
        File localFolder = new File(demInstallDir, folderName);
        File localFile = new File(localFolder, "hdr.adf");
        elevationFiles[x][this.NUM_Y_TILES - 1 - y] = new SRTM1GridFile(this, localFile, productReaderPlugIn.createReaderInstance());
    }

    private String createTileFilename(int minLat, int minLon) {
        StringBuilder name = new StringBuilder(12);
        name.append(minLon < 0 ? "w" : "e");
        String lonString = String.valueOf(Math.abs(minLon));
        while (lonString.length() < 2) {
            lonString = '0' + lonString;
        }
        name.append(lonString);
        name.append('_');
        name.append(minLat < 0 ? "s" : "n");
        String latString = String.valueOf(Math.abs(minLat));
        while (latString.length() < 2) {
            latString = '0' + latString;
        }
        name.append(latString);
        return name.toString();
    }
}

