/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.cdem;

import java.io.IOException;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.dem.BaseElevationTile;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.dem.dataio.EarthGravitationalModel96;
import org.esa.snap.dem.dataio.cdem.CDEMElevationModel;
import org.esa.snap.engine_utilities.gpf.TileGeoreferencing;

public final class CDEMElevationTile
extends BaseElevationTile
implements Resampling.Raster {
    private final EarthGravitationalModel96 egm = EarthGravitationalModel96.instance();

    public CDEMElevationTile(CDEMElevationModel dem, Product product) throws IOException {
        super((ElevationModel)dem, product);
    }

    protected void addGravitationalModel(int index, float[] line) throws Exception {
        GeoPos geoPos = new GeoPos();
        TileGeoreferencing tileGeoRef = new TileGeoreferencing(this.product, 0, index, line.length, 1);
        double[][] v = new double[4][4];
        for (int i = 0; i < line.length; ++i) {
            if (line[i] == this.noDataValue) continue;
            tileGeoRef.getGeoPos(i, index, geoPos);
            int n = i;
            line[n] = line[n] + this.egm.getEGM(geoPos.lat, geoPos.lon, v);
        }
    }

    public int getWidth() {
        return this.product != null ? this.product.getSceneRasterWidth() : 0;
    }

    public int getHeight() {
        return this.product != null ? this.product.getSceneRasterHeight() : 0;
    }

    public GeoCoding getTileGeocoding() {
        return this.product != null ? this.product.getSceneGeoCoding() : null;
    }

    public boolean getSamples(int[] x, int[] y, double[][] samples) throws Exception {
        boolean allValid = true;
        for (int i = 0; i < y.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                samples[i][j] = this.getSample(x[i], y[j]);
                if ((double)this.noDataValue != samples[i][j]) continue;
                samples[i][j] = Double.NaN;
                allValid = false;
            }
        }
        return allValid;
    }
}

