/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.aster;

import java.io.File;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.dataop.dem.BaseElevationModel;
import org.esa.snap.core.dataop.dem.ElevationFile;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.util.io.FileUnpacker;
import org.esa.snap.dem.dataio.aster.AsterElevationModelDescriptor;
import org.esa.snap.dem.dataio.aster.AsterFile;

public final class AsterElevationModel
extends BaseElevationModel {
    private static final ProductReaderPlugIn productReaderPlugIn = AsterElevationModel.getReaderPlugIn((String)"GeoTIFF");

    public AsterElevationModel(AsterElevationModelDescriptor descriptor, Resampling resamplingMethod) {
        super((ElevationModelDescriptor)descriptor, resamplingMethod);
        this.unpackTileBundles();
        this.setMaxCacheSize(6);
    }

    public double getIndexX(GeoPos geoPos) {
        return (geoPos.lon + 180.0) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILEinv;
    }

    public double getIndexY(GeoPos geoPos) {
        return (83.0 - geoPos.lat) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILEinv;
    }

    public GeoPos getGeoPos(PixelPos pixelPos) {
        double pixelLat = ((double)this.RASTER_HEIGHT - pixelPos.y) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 83.0;
        double pixelLon = pixelPos.x * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 180.0;
        return new GeoPos(pixelLat, pixelLon);
    }

    protected void createElevationFile(ElevationFile[][] elevationFiles, int x, int y, File demInstallDir) {
        int minLon = x * this.DEGREE_RES - 180;
        int minLat = y * this.DEGREE_RES - 83;
        String fileName = this.createTileFilename(minLat, minLon);
        File localFile = new File(demInstallDir, fileName);
        elevationFiles[x][this.NUM_Y_TILES - 1 - y] = new AsterFile(this, localFile, productReaderPlugIn.createReaderInstance());
    }

    private void unpackTileBundles() {
        File parentFolder = this.descriptor.getDemInstallDir();
        File[] files = parentFolder.listFiles();
        if (files == null) {
            return;
        }
        try {
            for (File f : files) {
                String name = f.getName().toLowerCase();
                if (!name.startsWith("tiles_") || !name.endsWith(".zip")) continue;
                FileUnpacker.unpackZip((File)f, (File)parentFolder, null);
                f.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String createTileFilename(int minLat, int minLon) {
        StringBuilder name = new StringBuilder("ASTGTM_");
        name.append(minLat < 0 ? "S" : "N");
        String latString = String.valueOf(Math.abs(minLat));
        while (latString.length() < 2) {
            latString = '0' + latString;
        }
        name.append(latString);
        name.append(minLon < 0 ? "W" : "E");
        String lonString = String.valueOf(Math.abs(minLon));
        while (lonString.length() < 3) {
            lonString = '0' + lonString;
        }
        name.append(lonString);
        name.append(".zip");
        return name.toString();
    }
}

