/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.runtime;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.esa.snap.runtime.Config;
import org.esa.snap.runtime.EnginePreferences;

public class EngineConfig
extends Config {
    public static final String PROPERTY_INSTALL_DIR = "snap.home";
    public static final String PROPERTY_USER_DIR = "snap.userdir";
    public static final String PROPERTY_CONFIG_FILE = "snap.config";
    public static final String PROPERTY_EXCLUDED_CLUSTER_NAMES = "snap.excludedClusters";
    public static final String PROPERTY_EXCLUDED_MODULE_NAMES = "snap.excludedModules";
    public static final String PROPERTY_IGNORE_USER_CONFIG = "snap.ignoreUserConfig";
    public static final String PROPERTY_IGNORE_DEFAULT_CONFIG = "snap.ignoreDefaultConfig";
    public static final String PROPERTY_DEBUG = "snap.debug";
    public static final String PROPERTY_LOGGER_NAME = "snap.logger.name";
    public static final String PROPERTY_LOG_LEVEL = "snap.log.level";
    static String[] DEFAULT_EXCLUDED_CLUSTER_NAMES = new String[]{"bin", "etc", "platform", "ide", "java"};
    static String[] DEFAULT_EXCLUDED_MODULE_NAMES = new String[]{"org.esa.snap:netbeans-docwin", "org.esa.snap:netbeans-tile", "org.esa.snap:snap-worldwind", "org.esa.snap:snap-rcp", "org.esa.snap:snap-ui", "org.esa.snap:ceres-ui", "org.esa.snap:snap-gpf-ui", "org.esa.snap:snap-dem-ui", "org.esa.snap:snap-pixel-extraction-ui", "org.esa.snap:snap-unmix-ui", "org.esa.snap:snap-binning-ui", "org.esa.snap:snap-collocation-ui"};
    private static EngineConfig INSTANCE = new EngineConfig();
    private Logger logger;

    private EngineConfig() {
        super("snap", new EnginePreferences("snap"));
        EngineConfig.add(this);
        this.initLogger();
    }

    public static EngineConfig instance() {
        return INSTANCE;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    public EngineConfig debug(boolean value) {
        this.preferences().putBoolean(PROPERTY_DEBUG, value);
        return this;
    }

    @Override
    public boolean debug() {
        return this.preferences().getBoolean(PROPERTY_DEBUG, false);
    }

    public EngineConfig installDir(Path value) {
        this.preferences().put(PROPERTY_INSTALL_DIR, value.toString());
        return this;
    }

    @Override
    public Path installDir() {
        String value = this.preferences().get(PROPERTY_INSTALL_DIR, null);
        if (value != null) {
            return Paths.get(value, new String[0]).normalize();
        }
        return Paths.get(System.getProperty("user.dir"), new String[0]).normalize();
    }

    public EngineConfig userDir(Path value) {
        this.preferences().put(PROPERTY_USER_DIR, value.toString());
        return this;
    }

    @Override
    public Path userDir() {
        String value = this.preferences().get(PROPERTY_USER_DIR, null);
        if (value != null) {
            return Paths.get(value, new String[0]);
        }
        return Paths.get(System.getProperty("user.home"), ".snap");
    }

    public EngineConfig configFile(Path value) {
        this.preferences().put(PROPERTY_CONFIG_FILE, value.toString());
        return this;
    }

    public Path configFile() {
        String value = this.preferences().get(PROPERTY_CONFIG_FILE, null);
        return value != null ? Paths.get(value, new String[0]) : null;
    }

    public EngineConfig ignoreDefaultConfig(boolean value) {
        this.preferences().putBoolean(PROPERTY_IGNORE_DEFAULT_CONFIG, value);
        return this;
    }

    public String loggerName() {
        return this.preferences().get(PROPERTY_LOGGER_NAME, "org.esa.snap");
    }

    public Config loggerName(String name) {
        this.preferences().put(PROPERTY_LOGGER_NAME, name);
        this.updateLogger();
        return this;
    }

    public Level logLevel() {
        return EngineConfig.parseLogLevelName(this.preferences().get(PROPERTY_LOG_LEVEL, "INFO"));
    }

    public EngineConfig logLevel(Level level) {
        return this.logLevel(level.getName());
    }

    public EngineConfig logLevel(String levelName) {
        this.preferences().put(PROPERTY_LOG_LEVEL, levelName);
        this.updateLogger();
        return this;
    }

    @Override
    public boolean ignoreDefaultConfig() {
        return this.preferences().getBoolean(PROPERTY_IGNORE_DEFAULT_CONFIG, false);
    }

    public EngineConfig ignoreUserConfig(boolean value) {
        this.preferences().putBoolean(PROPERTY_IGNORE_USER_CONFIG, value);
        return this;
    }

    @Override
    public boolean ignoreUserConfig() {
        return this.preferences().getBoolean(PROPERTY_IGNORE_USER_CONFIG, false);
    }

    public EngineConfig excludedClusterNames(String ... values) {
        this.preferences().put(PROPERTY_EXCLUDED_CLUSTER_NAMES, String.join((CharSequence)",", values));
        return this;
    }

    public String[] excludedClusterNames() {
        String value = this.preferences().get(PROPERTY_EXCLUDED_CLUSTER_NAMES, null);
        return value != null ? value.split(",") : DEFAULT_EXCLUDED_CLUSTER_NAMES;
    }

    public EngineConfig excludedModuleNames(String ... values) {
        this.preferences().put(PROPERTY_EXCLUDED_MODULE_NAMES, String.join((CharSequence)",", values));
        return this;
    }

    public String[] excludedModuleNames() {
        String value = this.preferences().get(PROPERTY_EXCLUDED_MODULE_NAMES, null);
        return value != null ? value.split(",") : DEFAULT_EXCLUDED_MODULE_NAMES;
    }

    @Override
    public EngineConfig load() {
        super.load();
        Set<String> clusterNames = this.loadOtherClusterNames();
        for (String clusterName : clusterNames) {
            EngineConfig.instance(clusterName).load();
        }
        return this;
    }

    @Override
    protected Properties loadProperties(Path propertiesFile, boolean mustExist) {
        Properties properties = super.loadProperties(propertiesFile, mustExist);
        if (properties != null) {
            this.updateLogger();
        }
        return properties;
    }

    private Set<String> loadOtherClusterNames() {
        Set<String> clusterNames = Collections.emptySet();
        Path clustersFile = this.installDir().resolve("etc").resolve("snap.clusters");
        if (Files.isRegularFile(clustersFile, new LinkOption[0])) {
            try {
                clusterNames = Files.readAllLines(clustersFile).stream().filter(name -> !name.trim().isEmpty()).collect(Collectors.toSet());
            }
            catch (IOException e) {
                this.logger().log(Level.SEVERE, String.format("Failed to load clusters file from '%s'", clustersFile), e);
            }
        }
        for (String clusterName : this.excludedClusterNames()) {
            clusterNames.remove(clusterName);
        }
        clusterNames.remove("snap");
        return clusterNames;
    }

    private static Level parseLogLevelName(String levelName) {
        if ("DEBUG".equalsIgnoreCase(levelName)) {
            return Level.FINE;
        }
        if ("ERROR".equalsIgnoreCase(levelName)) {
            return Level.SEVERE;
        }
        try {
            return Level.parse(levelName);
        }
        catch (IllegalArgumentException e) {
            return Level.INFO;
        }
    }

    private void initLogger() {
        System.setProperty("hsqldb.reconfig_logging", "false");
        this.setLogger(this.loggerName(), this.logLevel());
    }

    void updateLogger() {
        String loggerName = this.loggerName();
        Level logLevel = this.logLevel();
        if (this.logger == null || !loggerName.equals(this.logger.getName()) || !logLevel.equals(this.logger.getLevel())) {
            this.setLogger(loggerName, logLevel);
        }
    }

    private void setLogger(String loggerName, Level logLevel) {
        this.logger = Logger.getLogger(loggerName);
        this.logger.setLevel(logLevel);
        this.replaceConsoleLoggerFormatter(Logger.getLogger(""));
        this.replaceConsoleLoggerFormatter(this.logger);
    }

    private void replaceConsoleLoggerFormatter(Logger logger) {
        Handler[] handlers;
        for (Handler handler : handlers = logger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            ConsoleHandler consoleHandler = (ConsoleHandler)handler;
            consoleHandler.setFormatter(new LogRecordFormatter());
        }
    }

    private static class LogRecordFormatter
    extends Formatter {
        private LogRecordFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            if (record.getThrown() != null) {
                StringWriter stackTrace = new StringWriter();
                record.getThrown().printStackTrace(new PrintWriter(stackTrace));
                return String.format("%s: %s: %s%n%s%n", record.getLevel(), record.getSourceClassName(), record.getMessage(), stackTrace.toString());
            }
            return String.format("%s: %s: %s%n", record.getLevel(), record.getSourceClassName(), record.getMessage());
        }
    }
}

