/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.runtime;

import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.esa.snap.runtime.Activator;
import org.esa.snap.runtime.EngineConfig;
import org.esa.snap.runtime.InstallationScanner;

public class Engine {
    private static Engine instance;
    private final ClassLoader clientClassLoader;

    private Engine(boolean standAloneMode) {
        this.getConfig().load();
        if (standAloneMode) {
            long t0 = System.currentTimeMillis();
            InstallationScanner.ScanResult scanResult = new InstallationScanner(this.getConfig()).scanInstallationDir();
            long t1 = System.currentTimeMillis();
            if (this.getConfig().debug()) {
                this.getLogger().info("Scanning of installation directory took " + (t1 - t0) + " ms");
            }
            this.setJavaLibraryPath(scanResult.libraryPathEntries);
            this.clientClassLoader = this.createClientClassLoader(scanResult.classPathEntries);
        } else {
            this.clientClassLoader = Thread.currentThread().getContextClassLoader();
        }
    }

    public static Engine getInstance() {
        return instance;
    }

    public EngineConfig getConfig() {
        return EngineConfig.instance();
    }

    public Logger getLogger() {
        return this.getConfig().logger();
    }

    public static Engine start() {
        return Engine.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Engine start(boolean setContextClassLoader) {
        if (instance != null) return instance;
        Class<Engine> clazz = Engine.class;
        synchronized (Engine.class) {
            if (instance != null) return instance;
            instance = new Engine(setContextClassLoader);
            if (setContextClassLoader) {
                instance.setContextClassLoader();
            }
            instance.runClientCode(() -> instance.informActivators(Lifecycle.START));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void stop() {
        if (instance != null) {
            instance.runClientCode(() -> instance.informActivators(Lifecycle.STOP));
            instance = null;
        }
    }

    public ClassLoader getClientClassLoader() {
        this.assertStarted();
        return this.clientClassLoader;
    }

    public ClassLoader setContextClassLoader() {
        this.assertStarted();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.clientClassLoader);
        return contextClassLoader;
    }

    public Engine runClientCode(Runnable runnable) {
        this.assertStarted();
        ClassLoader classLoader = this.setContextClassLoader();
        try {
            runnable.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return this;
    }

    public Runnable createClientRunnable(Runnable runnable) {
        this.assertStarted();
        return () -> this.runClientCode(runnable);
    }

    private void informActivators(Lifecycle lifecycle) {
        ServiceLoader<Activator> activators = ServiceLoader.load(Activator.class, this.clientClassLoader);
        ArrayList<Activator> activatorList = new ArrayList<Activator>();
        for (Activator activator : activators) {
            activatorList.add(activator);
        }
        activatorList.sort((a1, a2) -> lifecycle == Lifecycle.START ? a1.getStartLevel() - a2.getStartLevel() : a2.getStartLevel() - a1.getStartLevel());
        for (Activator activator : activatorList) {
            try {
                if (lifecycle == Lifecycle.START) {
                    activator.start();
                    continue;
                }
                activator.stop();
            }
            catch (Exception ex) {
                this.getConfig().logger().log(Level.SEVERE, String.format("Failed to %s %s", lifecycle == Lifecycle.START ? "start" : "stop", activator.getClass().getName()), ex);
            }
        }
    }

    private ClassLoader createClientClassLoader(List<Path> paths) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Path path : paths) {
            try {
                URL url = path.toUri().toURL();
                urls.add(url);
            }
            catch (MalformedURLException e) {
                this.getLogger().severe(e.getMessage());
            }
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (!urls.isEmpty()) {
            classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), classLoader);
        }
        if (this.getConfig().debug()) {
            this.traceClassLoader("classLoader", classLoader);
        }
        return classLoader;
    }

    private void setJavaLibraryPath(List<Path> paths) {
        String javaLibraryPath = System.getProperty("java.library.path");
        String extraLibraryPath = paths.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator));
        if (javaLibraryPath == null || javaLibraryPath.isEmpty()) {
            this.setJavaLibraryPath(extraLibraryPath);
        } else if (!extraLibraryPath.isEmpty()) {
            this.setJavaLibraryPath(extraLibraryPath + File.pathSeparator + javaLibraryPath);
        }
        if (this.getConfig().debug()) {
            this.traceLibraryPaths();
        }
    }

    private void setJavaLibraryPath(String extraLibraryPath) {
        if (!this.getConfig().setSystemProperty("java.library.path", extraLibraryPath)) {
            return;
        }
        try {
            Field sysPathsField = ClassLoader.class.getDeclaredField("sys_paths");
            sysPathsField.setAccessible(true);
            sysPathsField.set(null, null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            this.getLogger().log(Level.SEVERE, "Failed to modify class loader field 'sys_paths'", e);
        }
    }

    private void traceClassLoader(String name, ClassLoader classLoader) {
        Logger logger = this.getLogger();
        logger.info(name + ".class = " + classLoader.getClass() + " =========================================================");
        if (classLoader instanceof URLClassLoader) {
            URL[] classpath = ((URLClassLoader)classLoader).getURLs();
            for (int i = 0; i < classpath.length; ++i) {
                logger.info(name + ".url[" + i + "] = " + classpath[i]);
            }
        }
        if (classLoader.getParent() != null) {
            this.traceClassLoader(name + ".parent", classLoader.getParent());
        } else {
            logger.info(name + ".parent = null");
        }
    }

    private void traceLibraryPaths() {
        Logger logger = this.getLogger();
        String[] paths = System.getProperty("java.library.path", "").split(File.pathSeparator);
        if (paths.length > 0) {
            logger.info("JNI library paths:");
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                logger.info("java.library.path[" + i + "] = " + path);
            }
        } else {
            logger.info("JNI library paths: none");
        }
    }

    private void assertStarted() {
        if (instance == null) {
            throw new IllegalStateException("Please call " + Engine.class + ".start() first.");
        }
    }

    private static enum Lifecycle {
        START,
        STOP;

    }
}

