/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.BaseStatisticsOperationJAI;
import org.geotools.coverage.processing.CoverageProcessingException;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.parameter.ImagingParameters;
import org.geotools.parameter.Parameters;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.geometry.BoundingBox;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.InternationalString;

public class ZonalStatistics
extends BaseStatisticsOperationJAI {
    public static final String GT_SYNTHETIC_PROPERTY_ZONALSTATS = "JAI-EXT.zonalstats";
    public static final Logger LOGGER = Logging.getLogger((String)"org.geotools.coverage.processing.operation");

    public ZonalStatistics() throws OperationNotFoundException {
        super(ZonalStatistics.getOperationDescriptor("Zonal"));
    }

    @Override
    protected ParameterBlockJAI prepareParameters(ParameterValueGroup parameters) {
        ImagingParameters copy = (ImagingParameters)this.descriptor.createValue();
        Parameters.copy((ParameterValueGroup)parameters, (ParameterValueGroup)copy);
        ParameterBlockJAI block = (ParameterBlockJAI)copy.parameters;
        try {
            Object o;
            LinearTransform worldToGridTransform;
            GridCoverage2D source = (GridCoverage2D)((Object)parameters.parameter(this.operation.getSourceNames()[0]).getValue());
            AffineTransform gridToWorldTransformCorrected = new AffineTransform((AffineTransform)source.getGridGeometry().getGridToCRS2D(PixelOrientation.UPPER_LEFT));
            try {
                worldToGridTransform = ProjectiveTransform.create((AffineTransform)gridToWorldTransformCorrected.createInverse());
            }
            catch (NoninvertibleTransformException e) {
                CoverageProcessingException ce = new CoverageProcessingException(e);
                throw ce;
            }
            CoordinateReferenceSystem crs = source.getCoordinateReferenceSystem2D();
            Envelope2D envelope = source.getEnvelope2D();
            Object roilist = parameters.parameter("roilist").getValue();
            try {
                o = parameters.parameter("roi").getValue();
            }
            catch (ParameterNotFoundException p) {
                o = null;
            }
            ArrayList<Object> outputList = null;
            ReferencedEnvelope coverageEnvelope = new ReferencedEnvelope((BoundingBox)envelope);
            if (roilist != null && roilist instanceof List) {
                List geomList = (List)roilist;
                int numGeom = geomList.size();
                Iterator geomIter = geomList.iterator();
                outputList = new ArrayList(numGeom);
                while (geomIter.hasNext()) {
                    SimpleFeature zone = (SimpleFeature)geomIter.next();
                    Geometry geometry = (Geometry)zone.getDefaultGeometry();
                    ReferencedEnvelope geometryEnvelope = new ReferencedEnvelope(geometry.getEnvelopeInternal(), crs);
                    if (!coverageEnvelope.intersects((Envelope)geometryEnvelope)) continue;
                    if (!coverageEnvelope.contains((Envelope)geometryEnvelope)) {
                        geometry = JTS.toGeometry((Envelope)coverageEnvelope).intersection(geometry);
                        geometryEnvelope = new ReferencedEnvelope(geometry.getEnvelopeInternal(), crs);
                    }
                    Geometry rasterSpaceGeometry = JTS.transform((Geometry)geometry, (MathTransform)worldToGridTransform);
                    Geometry simplifiedGeometry = DouglasPeuckerSimplifier.simplify((Geometry)rasterSpaceGeometry, (double)1.0);
                    AffineTransformation at = new AffineTransformation();
                    at.setToTranslation(-0.5, -0.5);
                    simplifiedGeometry.apply((CoordinateSequenceFilter)at);
                    ROIGeometry roi = new ROIGeometry(simplifiedGeometry, false);
                    outputList.add(roi);
                }
            } else if (o != null && o instanceof Polygon) {
                outputList = new ArrayList<Object>(1);
                Polygon roiInput = (Polygon)o;
                if (new ReferencedEnvelope(roiInput.getEnvelopeInternal(), source.getCoordinateReferenceSystem2D()).intersects((Envelope)new ReferencedEnvelope((BoundingBox)envelope))) {
                    java.awt.Polygon shapePolygon = ZonalStatistics.convertPolygon(roiInput, (MathTransform)worldToGridTransform);
                    outputList.add(new ROIShape((Shape)shapePolygon));
                }
            }
            block.setParameter("roilist", outputList);
            Geometry mask = (Geometry)parameters.parameter("mask").getValue();
            if (mask != null) {
                ReferencedEnvelope maskEnvelope = new ReferencedEnvelope(mask.getEnvelopeInternal(), crs);
                if (coverageEnvelope.intersects((Envelope)maskEnvelope)) {
                    if (!coverageEnvelope.contains((Envelope)maskEnvelope)) {
                        mask = JTS.toGeometry((Envelope)coverageEnvelope).intersection(mask);
                        maskEnvelope = new ReferencedEnvelope(mask.getEnvelopeInternal(), crs);
                    }
                    Geometry maskSpaceGeometry = JTS.transform((Geometry)mask, (MathTransform)worldToGridTransform);
                    Geometry simplifiedMaskGeometry = DouglasPeuckerSimplifier.simplify((Geometry)maskSpaceGeometry, (double)1.0);
                    AffineTransformation at = new AffineTransformation();
                    at.setToTranslation(-0.5, -0.5);
                    simplifiedMaskGeometry.apply((CoordinateSequenceFilter)at);
                    ROIGeometry maskROI = new ROIGeometry(simplifiedMaskGeometry, false);
                    block.setParameter("mask", (Object)maskROI);
                } else {
                    throw new IllegalArgumentException("Mask is outside the Coverage Envelope");
                }
            }
            ZonalStatistics.handleROINoDataInternal(block, source, "Zonal", 4, 3);
            return block;
        }
        catch (Exception e) {
            CoverageProcessingException ce = new CoverageProcessingException(e);
            throw ce;
        }
    }

    @Override
    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform toCRS, GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        if (data instanceof RenderedOp) {
            RenderedOp result = (RenderedOp)data;
            HashMap<String, Object> synthProp = new HashMap<String, Object>();
            GridCoverage2D source = sources[0];
            CoverageUtilities.setROIProperty(synthProp, CoverageUtilities.getROIProperty(source));
            CoverageUtilities.setNoDataProperty(synthProp, CoverageUtilities.getNoDataProperty(source));
            Object results = result.getProperty(GT_SYNTHETIC_PROPERTY_ZONALSTATS);
            if (results != null && results instanceof List) {
                List geoms = (List)results;
                synthProp.put(GT_SYNTHETIC_PROPERTY_ZONALSTATS, geoms);
            }
            return Collections.unmodifiableMap(synthProp);
        }
        return super.getProperties(data, crs, name, toCRS, sources, parameters);
    }
}

