/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.ConverterRegistry;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.lang.reflect.Method;
import org.esa.snap.core.gpf.descriptor.DefaultParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.PropertyAttributeException;

@XStreamAlias(value="parameter")
public class ToolParameterDescriptor
extends DefaultParameterDescriptor {
    protected String parameterType = "RegularParameter";

    public ToolParameterDescriptor() {
    }

    public ToolParameterDescriptor(String name, Class<?> type) {
        super(name, type);
    }

    public ToolParameterDescriptor(DefaultParameterDescriptor object) {
        super(object.getName(), object.getDataType());
        super.setAlias(object.getAlias());
        super.setDefaultValue(object.getDefaultValue());
        super.setDescription(object.getDescription());
        super.setLabel(object.getLabel());
        super.setUnit(object.getUnit());
        super.setInterval(object.getInterval());
        super.setValueSet(object.getValueSet());
        super.setCondition(object.getCondition());
        super.setPattern(object.getPattern());
        super.setFormat(object.getFormat());
        super.setNotNull(object.isNotNull());
        super.setNotEmpty(object.isNotEmpty());
        super.setRasterDataNodeClass(object.getRasterDataNodeClass());
        super.setValidatorClass(object.getValidatorClass());
        super.setConverterClass(object.getConverterClass());
        super.setDomConverterClass(object.getDomConverterClass());
        super.setItemAlias(object.getItemAlias());
        this.parameterType = object instanceof ToolParameterDescriptor ? ((ToolParameterDescriptor)object).getParameterType() : "RegularParameter";
    }

    public ToolParameterDescriptor(DefaultParameterDescriptor object, String parameterTypeMask) {
        this(object);
        this.parameterType = parameterTypeMask;
    }

    public Object getAttribute(String propertyName) throws PropertyAttributeException {
        try {
            Method getter = DefaultParameterDescriptor.class.getDeclaredMethod("is" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1), new Class[0]);
            return getter.invoke((Object)this, new Object[0]);
        }
        catch (Exception exception) {
            try {
                Method getter = DefaultParameterDescriptor.class.getDeclaredMethod("get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1), new Class[0]);
                return getter.invoke((Object)this, new Object[0]);
            }
            catch (Exception e) {
                throw new PropertyAttributeException("Exception on getting the value of the attribute '" + propertyName + "' message: " + e.getMessage());
            }
        }
    }

    public void setAttribute(String propertyName, Object obj) throws PropertyAttributeException {
        try {
            Method setter = DefaultParameterDescriptor.class.getDeclaredMethod("set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1), obj.getClass());
            setter.invoke((Object)this, obj);
        }
        catch (Exception e) {
            throw new PropertyAttributeException("Exception on setting the value '" + obj.toString() + "' to the attribute '" + propertyName + "' message: " + e.getMessage());
        }
    }

    public String getParameterType() {
        if (this.parameterType == null) {
            this.parameterType = "RegularParameter";
        }
        return this.parameterType;
    }

    public boolean isTemplateParameter() {
        return "TemplateParameter".equals(this.parameterType) || "TemplateBeforeExecution".equals(this.parameterType) || "TemplateAfterExecution".equals(this.parameterType);
    }

    public boolean isTemplateBefore() {
        return this.getParameterType().equals("TemplateBeforeExecution");
    }

    public boolean isTemplateAfter() {
        return this.getParameterType().equals("TemplateAfterExecution");
    }

    public boolean isParameter() {
        return this.getParameterType().equals("RegularParameter") || this.getParameterType().equals("FolderParameter");
    }

    public void setParameterType(String type) {
        this.parameterType = type;
    }

    public Object getDefaultTypedValue() {
        Object value = null;
        String defaultValue = this.getDefaultValue();
        Class dataType = this.getDataType();
        if (ToolParameterDescriptor.isSimple((Class)dataType)) {
            try {
                Converter converter = ConverterRegistry.getInstance().getConverter(dataType);
                value = converter.parse(defaultValue);
            }
            catch (ConversionException e) {
                e.printStackTrace();
            }
        } else {
            value = defaultValue;
        }
        return value;
    }

    public void copyFrom(ToolParameterDescriptor source) {
        this.setName(source.getName());
        this.setAlias(source.getAlias());
        this.setDataType(source.getDataType());
        this.setDefaultValue(source.getDefaultValue());
        this.setDescription(source.getDescription());
        this.setLabel(source.getLabel());
        this.setUnit(source.getUnit());
        this.setInterval(source.getInterval());
        this.setValueSet(source.getValueSet());
        this.setCondition(source.getCondition());
        this.setPattern(source.getPattern());
        this.setFormat(source.getFormat());
        this.setNotNull(source.isNotNull());
        this.setNotEmpty(source.isNotEmpty());
        this.setRasterDataNodeClass(source.getRasterDataNodeClass());
        this.setValidatorClass(source.getValidatorClass());
        this.setConverterClass(source.getConverterClass());
        this.setDomConverterClass(source.getDomConverterClass());
        this.setItemAlias(source.getItemAlias());
        this.setDeprecated(source.isDeprecated());
        this.setParameterType(source.getParameterType());
    }
}

