/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import org.esa.snap.core.gpf.operators.tooladapter.LookupReference;
import org.esa.snap.core.gpf.operators.tooladapter.LookupWithDefaultReference;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterIO;
import org.esa.snap.runtime.Config;

@XStreamAlias(value="variable")
public class SystemVariable {
    private static final List<LookupReference> lookupReferences = new ArrayList<LookupReference>();
    String key;
    String value;
    boolean isShared;

    public static void addLookupReference(LookupReference reference) {
        lookupReferences.add(reference);
    }

    public static void addLookupReference(LookupWithDefaultReference reference) {
        lookupReferences.add(reference);
    }

    private SystemVariable() {
        this.key = "";
        this.value = "";
        this.isShared = false;
    }

    public SystemVariable(String key, String value) {
        this.key = key;
        this.value = value;
        this.isShared = false;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.resolve();
    }

    public void setValue(String value) {
        this.value = value;
        if (this.value != null && !this.value.isEmpty() && this.isShared) {
            ToolAdapterIO.saveVariable(this.key, this.value);
        }
    }

    public boolean isShared() {
        return this.isShared;
    }

    public void setShared(boolean value) {
        this.isShared = value;
    }

    public SystemVariable createCopy() {
        SystemVariable newVariable = new SystemVariable();
        newVariable.setKey(this.key);
        newVariable.setValue(this.value);
        newVariable.setShared(this.isShared);
        return newVariable;
    }

    protected String resolve() {
        if (this.value == null || this.value.isEmpty()) {
            this.value = ToolAdapterIO.getVariableValue(this.key, null, this.isShared);
        }
        for (LookupReference reference : lookupReferences) {
            if (this.value != null && !this.value.isEmpty()) break;
            this.value = (String)reference.apply(this.key);
        }
        return this.value;
    }

    static {
        SystemVariable.addLookupReference(System::getenv);
        SystemVariable.addLookupReference(System::getProperty);
        Preferences preferences = Config.instance((String)"s2tbx").preferences();
        SystemVariable.addLookupReference(preferences::get);
    }
}

