/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.tools.weka;

import java.util.HashMap;
import java.util.Vector;
import net.sf.javaml.clustering.Clusterer;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.DefaultDataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.tools.weka.ToWekaUtils;
import net.sf.javaml.tools.weka.WekaException;
import weka.core.Instances;

public class WekaClusterer
implements Clusterer {
    private weka.clusterers.Clusterer wekaCluster;

    public WekaClusterer(weka.clusterers.Clusterer wekaCluster) {
        this.wekaCluster = wekaCluster;
    }

    @Override
    public Dataset[] cluster(Dataset data) {
        try {
            HashMap<Integer, Object> classValueMapping = new HashMap<Integer, Object>();
            for (Instance i : data) {
                classValueMapping.put(i.getID(), i.classValue());
                i.setClassValue(null);
            }
            data.classes().clear();
            Instances insts = new ToWekaUtils(data).getDataset();
            Vector<DefaultDataset> output = new Vector<DefaultDataset>();
            this.wekaCluster.buildClusterer(insts);
            for (int i = 0; i < insts.numInstances(); ++i) {
                int clusterIndex = this.wekaCluster.clusterInstance(insts.instance(i));
                while (output.size() <= clusterIndex) {
                    output.add(new DefaultDataset());
                }
                data.instance(i).setClassValue(classValueMapping.get(data.instance(i).getID()));
                ((Dataset)output.get(clusterIndex)).add(data.instance(i));
            }
            return output.toArray(new Dataset[output.size()]);
        }
        catch (Exception e) {
            throw new WekaException(e);
        }
    }
}

