/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.clustering.mcl;

import java.util.Iterator;
import net.sf.javaml.clustering.mcl.SparseMatrix;
import net.sf.javaml.clustering.mcl.SparseVector;

public class MarkovClustering {
    public SparseMatrix run(SparseMatrix a, double maxResidual, double pGamma, double loopGain, double maxZero) {
        this.addLoops(a, loopGain);
        a.normaliseRows();
        double residual = 1.0;
        int i = 0;
        while (residual > maxResidual) {
            ++i;
            a = this.expand(a);
            residual = this.inflate(a, pGamma, maxZero);
        }
        return a;
    }

    public double inflate(SparseMatrix m, double p, double zeromax) {
        double res = 0.0;
        m.hadamardPower(p);
        m.prune(zeromax);
        SparseVector rowsums = m.normalise(1.0);
        Iterator i$ = rowsums.keySet().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            SparseVector row = (SparseVector)m.get(i);
            double max = row.max();
            double sumsq = row.sum(2.0);
            res = Math.max(res, max - sumsq);
        }
        return res;
    }

    public SparseMatrix expand(SparseMatrix m) {
        m = m.times(m);
        return m;
    }

    private void addLoops(SparseMatrix a, double loopGain) {
        if (loopGain <= 0.0) {
            return;
        }
        for (int i = 0; i < a.size(); ++i) {
            a.add(i, i, loopGain);
        }
    }
}

