/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.clustering.evaluation;

import net.sf.javaml.clustering.evaluation.ClusterEvaluation;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.CosineSimilarity;
import net.sf.javaml.distance.DistanceMeasure;
import net.sf.javaml.tools.DatasetTools;

public class SumOfCentroidSimilarities
implements ClusterEvaluation {
    private DistanceMeasure dm = new CosineSimilarity();

    @Override
    public double score(Dataset[] datas) {
        Instance[] centroids = new Instance[datas.length];
        for (int i = 0; i < datas.length; ++i) {
            centroids[i] = DatasetTools.average(datas[i]);
        }
        double sum = 0.0;
        for (int i = 0; i < datas.length; ++i) {
            for (int j = 0; j < datas[i].size(); ++j) {
                double error = this.dm.measure(datas[i].instance(j), centroids[i]);
                sum += error;
            }
        }
        return sum;
    }

    @Override
    public boolean compareScore(double score1, double score2) {
        return score2 < score1;
    }
}

