/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.classification.bayes;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.sf.javaml.classification.bayes.AbstractBayesianClassifier;
import net.sf.javaml.classification.bayes.ClassCounter;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;

public class NaiveBayesClassifier
extends AbstractBayesianClassifier {
    private static final long serialVersionUID = -3206001837043122519L;

    public NaiveBayesClassifier(boolean lap, boolean log, boolean sparse) {
        super(lap, log, sparse);
    }

    @Override
    public void buildClassifier(Dataset data) {
        super.buildClassifier(data);
    }

    protected HashMap<Object, Double> calculateProbs(Instance inst) {
        HashMap<Object, Double> out = new HashMap<Object, Double>(this.numClasses);
        this.coverAbsentFeatures_And_fill_helpMap(inst);
        Hashtable<Integer, Hashtable<Double, ClassCounter>> featureName_HT = this.trainResult.getFeatureTable();
        double[] freq = (double[])this.trainResult.getClassFreqs().clone();
        double total = 0.0;
        for (int k = 0; k < this.numClasses; ++k) {
            double denominator = freq[k];
            double classScore = this.fnc.log2(freq[k]) - this.fnc.log2(this.numInstances);
            for (Integer key : featureName_HT.keySet()) {
                int featureName = key;
                int numValues = featureName_HT.get(featureName).size();
                Double featureValue = this.getInstValue(featureName, inst);
                double numerator = featureName_HT.get(featureName).get(featureValue).getCountClass(k);
                classScore += this.fnc.log2(numerator + 1.0) - this.fnc.log2(denominator + (double)numValues);
            }
            out.put(this.classes[k], classScore);
            total += Math.pow(2.0, classScore);
        }
        for (int l = 0; l < this.classes.length; ++l) {
            double classScore = out.get(this.classes[l]);
            out.put(this.classes[l], Math.pow(2.0, classScore - this.fnc.log2(total)));
        }
        return out;
    }

    @Override
    public Map<Object, Double> classDistribution(Instance instance) {
        return this.calculateProbs(instance);
    }
}

