/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.dataio;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.landcover.dataio.FileLandCoverModel;
import org.esa.snap.landcover.dataio.FileLandCoverTile;
import org.esa.snap.landcover.dataio.LandCoverModelDescriptor;
import uk.me.jstott.jcoord.LatLng;

public class FileLandCoverUTMModel
extends FileLandCoverModel {
    private Map<Integer, FileLandCoverTile> zoneTileMap = new HashMap<Integer, FileLandCoverTile>();

    public FileLandCoverUTMModel(LandCoverModelDescriptor descriptor, File[] files, Resampling resamplingMethod) throws IOException {
        super(descriptor, files, resamplingMethod);
    }

    @Override
    public synchronized double getLandCover(GeoPos geoPos) throws Exception {
        try {
            LatLng ll = new LatLng(geoPos.lat, geoPos.lon);
            int zone = ll.toUTMRef().getLngZone();
            FileLandCoverTile tile = this.zoneTileMap.get(zone);
            if (tile == null) {
                tile = this.loadProduct(zone);
            }
            if (tile != null && tile.getTileGeocoding() != null) {
                PixelPos pix = tile.getTileGeocoding().getPixelPos(geoPos, null);
                if (!pix.isValid() || pix.x < 0.0 || pix.y < 0.0 || pix.x >= (double)tile.getWidth() || pix.y >= (double)tile.getHeight()) {
                    return tile.getNoDataValue();
                }
                this.resampling.computeIndex(pix.x, pix.y, tile.getWidth(), tile.getHeight(), this.resamplingIndex);
                double value = this.resampling.resample((Resampling.Raster)tile, this.resamplingIndex);
                if (Double.isNaN(value)) {
                    return tile.getNoDataValue();
                }
                return value;
            }
            return this.descriptor.getNoDataValue();
        }
        catch (Exception e) {
            throw new Exception("Problem reading : " + e.getMessage());
        }
    }

    private FileLandCoverTile loadProduct(int zone) throws Exception {
        for (File file : this.fileList) {
            if (!file.getName().contains("UTM" + zone)) continue;
            FileLandCoverTile tile = new FileLandCoverTile(this, file, productReaderPlugIn.createReaderInstance());
            this.zoneTileMap.put(zone, tile);
            this.tileList = this.zoneTileMap.values().toArray(new FileLandCoverTile[this.zoneTileMap.size()]);
            return tile;
        }
        return null;
    }
}

