/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.dataio.AAFC;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.engine_utilities.util.Settings;
import org.esa.snap.landcover.dataio.AAFC.FileLandCoverProvincialModel;
import org.esa.snap.landcover.dataio.AbstractLandCoverModelDescriptor;
import org.esa.snap.landcover.dataio.LandCoverModel;

public class AESBEOS2014CropModelDescriptor
extends AbstractLandCoverModelDescriptor {
    public static final String NAME = "AAFC Canada 2014 Crop";
    private static final File INSTALL_DIR = new File(Settings.instance().getAuxDataFolder().getAbsolutePath(), "LandCover" + File.separator + "AAFC" + File.separator + "AESB_EOS_Crop_2014");
    private static final File[] fileList = new File[]{new File(INSTALL_DIR, "AAFC_2014_CI_AB_30m_v1_TIF.zip"), new File(INSTALL_DIR, "AAFC_2014_CI_BC_30m_v2_TIF.zip"), new File(INSTALL_DIR, "AAFC_2014_CI_MB_30m_v1_TIF.zip"), new File(INSTALL_DIR, "AAFC_2014_CI_NB_30m_v2_TIF.zip"), new File(INSTALL_DIR, "AAFC_2014_CI_NFL_30m_v1_TIF.zip"), new File(INSTALL_DIR, "AAFC_2014_CI_NS_30m_v2_TIF.zip"), new File(INSTALL_DIR, "AAFC_2014_CI_ON_30m_v2_TIF.zip"), new File(INSTALL_DIR, "AAFC_2014_CI_PEI_30m_v2_TIF.zip"), new File(INSTALL_DIR, "AAFC_2014_CI_QC_30m_v2_TIF.zip"), new File(INSTALL_DIR, "AAFC_2014_CI_SK_30m_v1_TIF.zip")};

    public AESBEOS2014CropModelDescriptor() {
        this.remotePath = "http://step.esa.int/auxdata/landcover/AAFC/AESB_EOS_Crop_2014/";
        this.name = NAME;
        this.NO_DATA_VALUE = -9999.0;
        this.installDir = INSTALL_DIR;
        Path moduleBasePath = ResourceInstaller.findModuleCodeBasePath(this.getClass());
        this.colourIndexFile = moduleBasePath.resolve("org/esa/snap/landcover/auxdata/aafc/aafc_crop_index.col");
    }

    @Override
    public synchronized boolean installFiles() {
        this.installMetadata();
        if (this.installDir != null) {
            this.isInstalled = true;
        }
        return this.isInstalled;
    }

    @Override
    public LandCoverModel createLandCoverModel(Resampling resampling) throws IOException {
        return new FileLandCoverProvincialModel(this, fileList, resampling);
    }

    @Override
    public String createTileFilename(int minLat, int minLon) {
        return fileList[0].getName();
    }
}

