/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff.internal;

import org.esa.snap.core.util.geotiff.GeoTIFFCodes;

public class GeoKeyEntry {
    private final int keyId;
    private final int tiffTagLocation;
    private final int count;
    private final Integer intValue;
    private final String strValue;
    private final double[] dblValue;

    public GeoKeyEntry(int keyId, int tiffTagLocation, int count, Object value) {
        this.keyId = keyId;
        this.tiffTagLocation = tiffTagLocation;
        this.count = count;
        if (value instanceof Integer) {
            this.intValue = (Integer)value;
            this.strValue = null;
            this.dblValue = null;
        } else if (value instanceof String) {
            this.intValue = null;
            this.strValue = (String)value;
            this.dblValue = null;
        } else if (value instanceof double[]) {
            this.intValue = null;
            this.strValue = null;
            this.dblValue = (double[])value;
        } else {
            throw new IllegalArgumentException(value.getClass() + "not supported");
        }
    }

    public int getKeyId() {
        return this.keyId;
    }

    public String getName() {
        return GeoTIFFCodes.getInstance().getName(this.getKeyId());
    }

    boolean hasIntValue() {
        return this.intValue != null;
    }

    boolean hasStrValue() {
        return this.strValue != null;
    }

    boolean hasDblValue() {
        return this.dblValue != null;
    }

    public Integer getIntValue() {
        return this.intValue;
    }

    public String getStrValue() {
        return this.strValue;
    }

    public double[] getDblValue() {
        return this.dblValue;
    }

    public String toString() {
        String s2;
        String s1 = "" + this.keyId + ", " + this.tiffTagLocation + ", " + this.count + ", ";
        if (this.hasIntValue()) {
            s2 = String.valueOf(this.intValue);
        } else if (this.hasDblValue()) {
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            for (double v : this.dblValue) {
                sb.append(v);
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("]");
            s2 = sb.toString();
        } else {
            s2 = this.strValue;
        }
        return s1 + s2;
    }
}

