/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.watermask.util;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import org.esa.snap.watermask.operator.WatermaskUtils;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.style.Fill;

class ShapeFileRasterizer {
    private final File targetDir;
    private final String tempDir;

    ShapeFileRasterizer(File targetDir) {
        this.targetDir = targetDir;
        this.tempDir = System.getProperty("java.io.tmpdir", ".");
    }

    public static void main(String[] args) throws IOException {
        File resourceDir = new File(args[0]);
        File targetDir = new File(args[1]);
        targetDir.mkdirs();
        int sideLength = WatermaskUtils.computeSideLength(Integer.parseInt(args[2]));
        boolean createImage = false;
        if (args.length == 4) {
            createImage = Boolean.parseBoolean(args[3]);
        }
        ShapeFileRasterizer rasterizer = new ShapeFileRasterizer(targetDir);
        rasterizer.rasterizeShapeFiles(resourceDir, sideLength, createImage);
    }

    void rasterizeShapeFiles(File directory, int tileSize, boolean createImage) throws IOException {
        File[] subdirs;
        File[] shapeFiles = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".zip");
            }
        });
        if (shapeFiles != null) {
            this.rasterizeShapeFiles(shapeFiles, tileSize, createImage);
        }
        if ((subdirs = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) != null) {
            for (File subDir : subdirs) {
                this.rasterizeShapeFiles(subDir, tileSize, createImage);
            }
        }
    }

    void rasterizeShapeFiles(File[] zippedShapeFiles, int tileSize, boolean createImage) {
        ExecutorService executorService = Executors.newFixedThreadPool(12);
        for (int i = 0; i < zippedShapeFiles.length; ++i) {
            File shapeFile = zippedShapeFiles[i];
            int shapeFileIndex = i + 1;
            ShapeFileRunnable runnable = new ShapeFileRunnable(shapeFile, tileSize, shapeFileIndex, zippedShapeFiles.length, createImage);
            executorService.submit(runnable);
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            try {
                executorService.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    BufferedImage createImage(File shapeFile, int tileSize) throws Exception {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        String shapeFileName = shapeFile.getName();
        ReferencedEnvelope referencedEnvelope = this.parseEnvelopeFromShapeFileName(shapeFileName, (CoordinateReferenceSystem)crs);
        DefaultMapContext context = new DefaultMapContext((CoordinateReferenceSystem)crs);
        URL shapeFileUrl = shapeFile.toURI().toURL();
        FeatureSource<SimpleFeatureType, SimpleFeature> featureSource = this.getFeatureSource(shapeFileUrl);
        context.addLayer(featureSource, this.createPolygonStyle());
        BufferedImage landMaskImage = new BufferedImage(tileSize, tileSize, 12);
        Graphics2D graphics = landMaskImage.createGraphics();
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)context);
        Rectangle paintArea = new Rectangle(0, 0, tileSize, tileSize);
        AffineTransform transform = this.createWorldToScreenTransform(referencedEnvelope, paintArea);
        renderer.paint(graphics, paintArea, referencedEnvelope, transform);
        return landMaskImage;
    }

    private AffineTransform createWorldToScreenTransform(ReferencedEnvelope referencedEnvelope, Rectangle paintArea) throws Exception {
        GridEnvelope2D gridRange = new GridEnvelope2D(paintArea);
        GridToEnvelopeMapper mapper = new GridToEnvelopeMapper((GridEnvelope)gridRange, (Envelope)referencedEnvelope);
        mapper.setPixelAnchor(PixelInCell.CELL_CENTER);
        return mapper.createAffineTransform().createInverse();
    }

    private ReferencedEnvelope parseEnvelopeFromShapeFileName(String shapeFileName, CoordinateReferenceSystem crs) {
        int latMax;
        int lonMax;
        int lonMin = Integer.parseInt(shapeFileName.substring(1, 4));
        if (shapeFileName.startsWith("e")) {
            lonMax = lonMin + 1;
        } else if (shapeFileName.startsWith("w")) {
            --lonMin;
            lonMin *= -1;
            lonMax = lonMin--;
        } else {
            throw new IllegalStateException("Wrong shapefile-name: '" + shapeFileName + "'.");
        }
        int latMin = Integer.parseInt(shapeFileName.substring(5, 7));
        if (shapeFileName.charAt(4) == 'n') {
            latMax = latMin + 1;
        } else if (shapeFileName.charAt(4) == 's') {
            --latMin;
            latMin *= -1;
            latMax = latMin--;
        } else {
            throw new IllegalStateException("Wrong shapefile-name: '" + shapeFileName + "'.");
        }
        return new ReferencedEnvelope((double)lonMin, (double)lonMax, (double)latMin, (double)latMax, crs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(BufferedImage image, String name, boolean createImage) throws IOException {
        String fileName = ShapeFileRasterizer.getFilenameWithoutExtension(name);
        fileName = fileName.substring(0, fileName.length() - 1);
        String imgFileName = fileName + ".img";
        File outputFile = new File(this.targetDir.getAbsolutePath(), imgFileName);
        FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
        try {
            byte[] data = ((DataBufferByte)image.getData().getDataBuffer()).getData();
            fileOutputStream.write(data);
            if (createImage) {
                ImageIO.write((RenderedImage)image, "png", new File(this.targetDir.getAbsolutePath(), fileName + ".png"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    List<File> createTempFiles(ZipFile zipFile) {
        List<File> tempShapeFiles;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        try {
            tempShapeFiles = this.unzipTempFiles(zipFile, entries);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error generating temp files from shapefile '" + zipFile.getName() + "'.", e);
        }
        return tempShapeFiles;
    }

    private List<File> unzipTempFiles(ZipFile zipFile, Enumeration<? extends ZipEntry> entries) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File file = this.readIntoTempFile(zipFile, entry);
            files.add(file);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File readIntoTempFile(ZipFile zipFile, ZipEntry entry) throws IOException {
        File file = new File(this.tempDir, entry.getName());
        InputStream reader = zipFile.getInputStream(entry);
        FileOutputStream writer = new FileOutputStream(file);
        try {
            byte[] buffer = new byte[0x100000];
            int bytesRead = reader.read(buffer);
            while (bytesRead != -1) {
                writer.write(buffer, 0, bytesRead);
                bytesRead = reader.read(buffer);
            }
        }
        finally {
            reader.close();
            writer.close();
        }
        return file;
    }

    private void deleteTempFiles(List<File> tempFiles) {
        for (File tempFile : tempFiles) {
            tempFile.delete();
        }
        tempFiles.clear();
    }

    private static String getFilenameWithoutExtension(String fileName) {
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            return fileName.substring(0, i);
        }
        return fileName;
    }

    private FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(URL url) throws IOException {
        HashMap<String, Serializable> parameterMap = new HashMap<String, Serializable>();
        parameterMap.put(ShapefileDataStoreFactory.URLP.key, url);
        parameterMap.put(ShapefileDataStoreFactory.CREATE_SPATIAL_INDEX.key, Boolean.TRUE);
        DataStore shapefileStore = DataStoreFinder.getDataStore(parameterMap);
        String typeName = shapefileStore.getTypeNames()[0];
        SimpleFeatureSource featureSource = shapefileStore.getFeatureSource(typeName);
        return featureSource;
    }

    private Style createPolygonStyle() {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
        PolygonSymbolizer symbolizer = styleFactory.createPolygonSymbolizer();
        Stroke stroke = styleFactory.createStroke((Expression)filterFactory.literal((Object)"#FFFFFF"), (Expression)filterFactory.literal(0.0));
        symbolizer.setStroke((org.opengis.style.Stroke)stroke);
        org.geotools.styling.Fill fill = styleFactory.createFill((Expression)filterFactory.literal((Object)"#FFFFFF"), (Expression)filterFactory.literal(1.0));
        symbolizer.setFill((Fill)fill);
        Rule rule = styleFactory.createRule();
        rule.symbolizers().add(symbolizer);
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle();
        fts.rules().add(rule);
        Style style = styleFactory.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }

    private class ShapeFileRunnable
    implements Runnable {
        private final File shapeFile;
        private int tileSize;
        private int index;
        private int shapeFileCount;
        private boolean createImage;

        ShapeFileRunnable(File shapeFile, int tileSize, int shapeFileIndex, int shapeFileCount, boolean createImage) {
            this.shapeFile = shapeFile;
            this.tileSize = tileSize;
            this.index = shapeFileIndex;
            this.shapeFileCount = shapeFileCount;
            this.createImage = createImage;
        }

        @Override
        public void run() {
            try {
                List<File> tempShapeFiles;
                try (ZipFile zipFile = new ZipFile(this.shapeFile);){
                    tempShapeFiles = ShapeFileRasterizer.this.createTempFiles(zipFile);
                }
                for (File file : tempShapeFiles) {
                    if (!file.getName().endsWith("shp")) continue;
                    BufferedImage image = ShapeFileRasterizer.this.createImage(file, this.tileSize);
                    ShapeFileRasterizer.this.writeToFile(image, this.shapeFile.getName(), this.createImage);
                }
                ShapeFileRasterizer.this.deleteTempFiles(tempShapeFiles);
                System.out.printf("File %d of %d%n", this.index, this.shapeFileCount);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

