/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri.expression;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.olingo.odata2.api.edm.EdmLiteral;
import org.apache.olingo.odata2.core.uri.expression.ExpressionParserInternalError;
import org.apache.olingo.odata2.core.uri.expression.Token;
import org.apache.olingo.odata2.core.uri.expression.TokenKind;
import org.apache.olingo.odata2.core.uri.expression.TokenizerExpectError;

public class TokenList
implements Iterator<Token> {
    private ArrayList<Token> tokens = new ArrayList();
    int currentToken = 0;

    public void appendToken(int position, TokenKind kind, String uriLiteral) {
        Token token = new Token(kind, position, uriLiteral);
        this.tokens.add(token);
    }

    public void appendToken(int position, TokenKind kind, char charValue) {
        Token token = new Token(kind, position, Character.toString(charValue));
        this.tokens.add(token);
    }

    public void appendEdmTypedToken(int position, TokenKind kind, String uriLiteral, EdmLiteral javaLiteral) {
        Token token = new Token(kind, position, uriLiteral, javaLiteral);
        this.tokens.add(token);
    }

    public Token lookToken() {
        if (this.currentToken >= this.tokens.size()) {
            return null;
        }
        return this.tokens.get(this.currentToken);
    }

    public Token lookPrevToken() {
        if (this.currentToken - 1 < 0) {
            return null;
        }
        return this.tokens.get(this.currentToken - 1);
    }

    public boolean hasTokens() {
        return this.tokens.size() > 0;
    }

    public int tokenCount() {
        int i = this.tokens.size();
        return i;
    }

    public Token expectToken(TokenKind comma) throws TokenizerExpectError {
        Token actual = this.next();
        if (actual == null) {
            throw TokenizerExpectError.createNO_TOKEN_AVAILABLE(comma.toString());
        }
        if (comma != actual.getKind()) {
            throw TokenizerExpectError.createINVALID_TOKENKIND_AT(comma, actual);
        }
        return actual;
    }

    public Token expectToken(TokenKind comma, boolean throwFilterExpression) throws ExpressionParserInternalError {
        Token actual = this.next();
        if (actual == null) {
            throw ExpressionParserInternalError.createNO_TOKEN_AVAILABLE(comma.toString());
        }
        if (comma != actual.getKind() && throwFilterExpression) {
            throw ExpressionParserInternalError.createINVALID_TOKENKIND_AT(comma, actual);
        }
        return actual;
    }

    public Token expectToken(String literal) throws TokenizerExpectError {
        Token actual = this.next();
        if (actual == null) {
            throw TokenizerExpectError.createNO_TOKEN_AVAILABLE(literal);
        }
        if (!literal.equals(actual.getUriLiteral())) {
            throw TokenizerExpectError.createINVALID_TOKEN_AT(literal, actual);
        }
        return actual;
    }

    public Token expectToken(String literal, boolean throwInternal) throws ExpressionParserInternalError {
        Token actual = this.next();
        if (actual == null) {
            throw ExpressionParserInternalError.createNO_TOKEN_AVAILABLE(literal);
        }
        if (!literal.equals(actual.getUriLiteral()) && throwInternal) {
            throw ExpressionParserInternalError.createINVALID_TOKEN_AT(literal, actual);
        }
        return actual;
    }

    public void skip() {
        ++this.currentToken;
    }

    @Override
    public boolean hasNext() {
        return this.currentToken < this.tokens.size();
    }

    @Override
    public Token next() {
        if (this.currentToken >= this.tokens.size()) {
            return null;
        }
        Token ret = this.tokens.get(this.currentToken);
        ++this.currentToken;
        return ret;
    }

    @Override
    public void remove() {
        throw new IllegalArgumentException("Method not allowed");
    }

    public Token elementAt(int index) {
        return this.tokens.get(index);
    }
}

