/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.producer;

import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.odata2.api.edm.EdmCustomizableFeedMappings;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.core.ep.EntityProviderProducerException;
import org.apache.olingo.odata2.core.ep.aggregator.EntityComplexPropertyInfo;
import org.apache.olingo.odata2.core.ep.aggregator.EntityPropertyInfo;

public class XmlPropertyEntityProducer {
    private final boolean includeSimplePropertyType;
    private final boolean validateFacets;
    private boolean isDataBasedPropertySerialization = false;

    public XmlPropertyEntityProducer(EntityProviderWriteProperties writeProperties) {
        this(writeProperties.isIncludeSimplePropertyType(), writeProperties.isValidatingFacets());
        this.isDataBasedPropertySerialization = writeProperties.isDataBasedPropertySerialization();
    }

    public XmlPropertyEntityProducer(boolean includeSimplePropertyType, boolean validateFacets) {
        this.includeSimplePropertyType = includeSimplePropertyType;
        this.validateFacets = validateFacets;
    }

    public void append(XMLStreamWriter writer, String name, EntityPropertyInfo propertyInfo, Object value) throws EntityProviderException {
        try {
            writer.writeStartElement("http://schemas.microsoft.com/ado/2007/08/dataservices", name);
            if (propertyInfo.isComplex()) {
                this.appendProperty(writer, (EntityComplexPropertyInfo)propertyInfo, value);
            } else {
                this.appendProperty(writer, propertyInfo, value);
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, e);
        }
        catch (EdmException e) {
            throw new EntityProviderProducerException(e.getMessageReference(), e);
        }
    }

    public void appendCustomProperty(XMLStreamWriter writer, String name, EntityPropertyInfo propertyInfo, Object value) throws EntityProviderException {
        try {
            if (!propertyInfo.isComplex()) {
                this.writeStartElementWithCustomNamespace(writer, propertyInfo, name);
                this.appendProperty(writer, propertyInfo, value);
                writer.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, e);
        }
        catch (EdmException e) {
            throw new EntityProviderProducerException(e.getMessageReference(), e);
        }
    }

    public void append(XMLStreamWriter writer, EntityPropertyInfo propertyInfo, Object value) throws EntityProviderException {
        try {
            writer.writeStartElement(propertyInfo.getName());
            writer.writeDefaultNamespace("http://schemas.microsoft.com/ado/2007/08/dataservices");
            writer.writeNamespace("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
            if (propertyInfo.isComplex()) {
                this.appendProperty(writer, (EntityComplexPropertyInfo)propertyInfo, value);
            } else {
                this.appendProperty(writer, propertyInfo, value);
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, e);
        }
        catch (EdmException e) {
            throw new EntityProviderProducerException(e.getMessageReference(), e);
        }
    }

    private void appendProperty(XMLStreamWriter writer, EntityComplexPropertyInfo propertyInfo, Object value) throws XMLStreamException, EdmException, EntityProviderException {
        if (value == null) {
            writer.writeAttribute("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "null", "true");
        } else {
            writer.writeAttribute("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "type", this.getFqnTypeName(propertyInfo));
            List<EntityPropertyInfo> propertyInfos = propertyInfo.getPropertyInfos();
            for (EntityPropertyInfo childPropertyInfo : propertyInfos) {
                if (this.isDataBasedPropertySerialization && !((Map)value).containsKey(childPropertyInfo.getName())) continue;
                Object childValue = this.extractChildValue(value, childPropertyInfo.getName());
                this.append(writer, childPropertyInfo.getName(), childPropertyInfo, childValue);
            }
        }
    }

    private String getFqnTypeName(EntityComplexPropertyInfo propertyInfo) throws EdmException {
        return propertyInfo.getType().getNamespace() + "." + propertyInfo.getType().getName();
    }

    private Object extractChildValue(Object value, String name) {
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.get(name);
        }
        return String.valueOf(value);
    }

    private void appendProperty(XMLStreamWriter writer, EntityPropertyInfo prop, Object value) throws XMLStreamException, EdmException {
        EdmFacets facets;
        String valueAsString;
        Object contentValue = value;
        String mimeType = null;
        if (prop.getMimeType() != null) {
            mimeType = prop.getMimeType();
        } else if (prop.getMapping() != null && prop.getMapping().getMediaResourceMimeTypeKey() != null) {
            mimeType = (String)this.extractChildValue(value, prop.getMapping().getMediaResourceMimeTypeKey());
            contentValue = this.extractChildValue(value, prop.getName());
        }
        if (mimeType != null) {
            writer.writeAttribute("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "MimeType", mimeType);
        }
        EdmSimpleType type = (EdmSimpleType)prop.getType();
        if (this.includeSimplePropertyType) {
            String fqnTypeName = type.getNamespace() + "." + type.getName();
            writer.writeAttribute("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "type", fqnTypeName);
        }
        if ((valueAsString = type.valueToString(contentValue, EdmLiteralKind.DEFAULT, facets = this.validateFacets ? prop.getFacets() : null)) == null) {
            writer.writeAttribute("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "null", "true");
        } else {
            writer.writeCharacters(valueAsString);
        }
    }

    private void writeStartElementWithCustomNamespace(XMLStreamWriter writer, EntityPropertyInfo prop, String name) throws XMLStreamException, EntityProviderException {
        EdmCustomizableFeedMappings mapping = prop.getCustomMapping();
        String nsPrefix = mapping.getFcNsPrefix();
        String nsUri = mapping.getFcNsUri();
        if (nsUri == null || nsPrefix == null) {
            throw new EntityProviderProducerException(EntityProviderException.INVALID_NAMESPACE.addContent(new Object[]{name}));
        }
        writer.writeStartElement(nsPrefix, name, nsUri);
        writer.writeNamespace(nsPrefix, nsUri);
    }
}

