/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.batch;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.olingo.odata2.api.client.batch.BatchChangeSetPart;
import org.apache.olingo.odata2.core.batch.BatchHelper;

public class BatchChangeSetPartImpl
extends BatchChangeSetPart {
    private String method;
    private Map<String, String> headers = new HashMap<String, String>();
    private String body;
    private String uri;
    public String contentId;
    private static final String CHANGE_METHODS = "(PUT|POST|DELETE|MERGE|PATCH)";

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public String getBody() {
        return this.body;
    }

    public byte[] getBodyAsBytes() {
        if (this.body == null) {
            return new byte[0];
        }
        Charset charset = this.getCharset();
        return this.body.getBytes(charset);
    }

    private Charset getCharset() {
        return BatchHelper.extractCharset(this.headers);
    }

    public String getMethod() {
        return this.method;
    }

    public String getUri() {
        return this.uri;
    }

    public String getContentId() {
        return this.contentId;
    }

    public class BatchChangeSetRequestBuilderImpl
    extends BatchChangeSetPart.BatchChangeSetPartBuilder {
        private String method;
        private Map<String, String> headers = new HashMap<String, String>();
        private String body;
        private String uri;
        private String contentId;

        public BatchChangeSetPart build() {
            if (this.method == null || this.uri == null) {
                throw new IllegalArgumentException();
            }
            BatchChangeSetPartImpl.this.method = this.method;
            BatchChangeSetPartImpl.this.headers = this.headers;
            BatchChangeSetPartImpl.this.body = this.body;
            BatchChangeSetPartImpl.this.uri = this.uri;
            BatchChangeSetPartImpl.this.contentId = this.contentId;
            return BatchChangeSetPartImpl.this;
        }

        public BatchChangeSetPart.BatchChangeSetPartBuilder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public BatchChangeSetPart.BatchChangeSetPartBuilder body(String body) {
            this.body = body;
            return this;
        }

        public BatchChangeSetPart.BatchChangeSetPartBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public BatchChangeSetPart.BatchChangeSetPartBuilder method(String method) {
            if (method == null || !method.matches(BatchChangeSetPartImpl.CHANGE_METHODS)) {
                throw new IllegalArgumentException();
            }
            this.method = method;
            return this;
        }

        public BatchChangeSetPart.BatchChangeSetPartBuilder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }
    }
}

