/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.modules;

import java.time.LocalDateTime;
import java.util.Set;
import java.util.TreeSet;
import org.esa.snap.modules.AbstractBuilder;

public class UpdateBuilder
extends AbstractBuilder {
    private Set<String> moduleManifests = new TreeSet<String>();

    public UpdateBuilder moduleManifest(String value) {
        this.moduleManifests.add(value);
        return this;
    }

    @Override
    public String build(boolean standalone) {
        StringBuilder xmlBuilder = new StringBuilder();
        if (standalone) {
            xmlBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n").append("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.5//EN\")").append("\"http://www.netbeans.org/dtds/autoupdate-catalog-2_5.dtd\">");
        }
        LocalDateTime now = LocalDateTime.now();
        xmlBuilder.append("<module_updates timestamp=\"").append(String.format("%02d", now.getHour())).append("/").append(String.format("%02d", now.getMinute())).append("/").append(String.format("%02d", now.getSecond())).append("/").append(String.format("%02d", now.getDayOfMonth())).append("/").append(String.format("%02d", now.getMonth().getValue())).append("/").append(String.format("%02d", now.getYear())).append("\">\n");
        for (String moduleManifest : this.moduleManifests) {
            xmlBuilder.append(moduleManifest).append("\n");
        }
        xmlBuilder.append("</module_updates>");
        return xmlBuilder.toString();
    }
}

