/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.hdf;

import edu.ucar.ral.nujan.hdf.BaseBlk;
import edu.ucar.ral.nujan.hdf.HBuffer;
import edu.ucar.ral.nujan.hdf.HdfException;
import edu.ucar.ral.nujan.hdf.HdfFileWriter;
import edu.ucar.ral.nujan.hdf.HdfGroup;
import edu.ucar.ral.nujan.hdf.MsgAttribute;

abstract class MsgBase
extends BaseBlk {
    static final int MSG_HDR_LEN_V2 = 6;
    static final int FLAG_CONSTANT = 1;
    static final int TP_NIL = 0;
    static final int TP_DATASPACE = 1;
    static final int TP_LINKINFO = 2;
    static final int TP_DATATYPE = 3;
    static final int TP_OLD_FILL_VALUE = 4;
    static final int TP_FILL_VALUE = 5;
    static final int TP_LINKIT = 6;
    static final int TP_EXTERNAL_FILE = 7;
    static final int TP_LAYOUT = 8;
    static final int TP_BOGUS = 9;
    static final int TP_GROUPINFO = 10;
    static final int TP_FILTER = 11;
    static final int TP_ATTRIBUTE = 12;
    static final int TP_COMMENT = 13;
    static final int TP_OLD_MOD_TIME = 14;
    static final int TP_SHARED_MESSAGE = 15;
    static final int TP_OBJ_HDR_CONTIN = 16;
    static final int TP_SYMBOL_TABLE = 17;
    static final int TP_MOD_TIME = 18;
    static final int TP_K_VALUES = 19;
    static final int TP_DRIVER_INFO = 20;
    static final int TP_ATTR_INFO = 21;
    static final int TP_OBJ_REF_COUNT = 22;
    static final String[] hdrMsgTypeNames = new String[]{"Nil", "Dataspace", "LinkInfo", "Datatype", "Obsolete fill value", "Fill value", "Linkit", "External data files", "Layout", "Bogus - testing only", "GroupInfo", "Filter pipeline", "Attribute", "Object comment", "Obsolete object modification time", "Shared message table", "Object header continuation", "Symbol table message", "Object modification time", "Btree K values", "Driver info", "Attribute info", "Object reference count"};
    HdfGroup hdfGroup;
    int hdrMsgType;
    int hdrMsgCreOrder;
    int hdrMsgSize;
    int hdrMsgFlag;

    MsgBase(int hdrMsgType, HdfGroup hdfGroup, HdfFileWriter hdfFile) {
        super(hdrMsgTypeNames[hdrMsgType], hdfFile);
        this.hdrMsgType = hdrMsgType;
        this.hdfGroup = hdfGroup;
        this.hdrMsgCreOrder = 0;
        this.hdrMsgSize = 0;
        this.hdrMsgFlag = 1;
    }

    @Override
    public String toString() {
        String res = super.toString();
        res = res + "  hdrMsgType: " + hdrMsgTypeNames[this.hdrMsgType] + "  hdrMsgSize: " + this.hdrMsgSize + "  hdrMsgFlag: " + this.hdrMsgFlag;
        return res;
    }

    void formatFullMsg(int formatPass, HBuffer fmtBuf) throws HdfException {
        long svPos;
        ++this.hdfFile.indent;
        if (this.hdfFile.bugs >= 5) {
            String stg = String.format("formatFullMsg: msgType: %d (%s)  size: %d  flag: 0x%x  creOrder: %d  in grp: \"%s\"", this.hdrMsgType, hdrMsgTypeNames[this.hdrMsgType], this.hdrMsgSize, this.hdrMsgFlag, this.hdrMsgCreOrder, this.hdfGroup.getPath());
            if (this instanceof MsgAttribute) {
                stg = stg + "  attrName: " + ((MsgAttribute)this).attrName;
            }
            this.prtIndent(stg, new Object[0]);
        }
        this.blkPosition = svPos = (long)fmtBuf.getPos();
        fmtBuf.putBufByte("MsgBase: hdrMsgType", this.hdrMsgType);
        fmtBuf.putBufShort("MsgBase: hdrMsgSize", this.hdrMsgSize);
        fmtBuf.putBufByte("MsgBase: hdrMsgFlag", this.hdrMsgFlag);
        fmtBuf.putBufShort("MsgBase: hdrMsgCreOrder", this.hdrMsgCreOrder);
        long svCore = fmtBuf.getPos();
        this.formatMsgCore(formatPass, fmtBuf);
        this.hdrMsgSize = (int)((long)fmtBuf.getPos() - svCore);
        int specHdrLen = 0;
        specHdrLen = 6;
        if ((long)fmtBuf.getPos() != svPos + (long)specHdrLen + (long)this.hdrMsgSize) {
            MsgBase.throwerr("formatFullMsg: len mismatch.  svPos: 0x%x  HLEN: 0x%x  hmsgSize: 0x%x  curPos: 0x%x", svPos, specHdrLen, this.hdrMsgSize, fmtBuf.getPos());
        }
        --this.hdfFile.indent;
    }

    void formatNakedMsg(int formatPass, HBuffer fmtBuf) throws HdfException {
        long svPos;
        ++this.hdfFile.indent;
        if (this.hdfFile.bugs >= 5) {
            this.prtIndent("formatNakedMsg: msgType: %d (%s)  size: %d  flag: 0x%x", this.hdrMsgType, hdrMsgTypeNames[this.hdrMsgType], this.hdrMsgSize, this.hdrMsgFlag);
        }
        this.blkPosition = svPos = (long)fmtBuf.getPos();
        this.formatMsgCore(formatPass, fmtBuf);
        this.hdrMsgSize = (int)((long)fmtBuf.getPos() - svPos);
        --this.hdfFile.indent;
    }

    @Override
    void formatBuf(int formatPass, HBuffer fmtBuf) throws HdfException {
        MsgBase.throwerr("formatBuf illegal for Msg* classes", new Object[0]);
    }

    abstract void formatMsgCore(int var1, HBuffer var2) throws HdfException;
}

