/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.hdf;

import edu.ucar.ral.nujan.hdf.BaseBlk;
import edu.ucar.ral.nujan.hdf.CheckSumHack;
import edu.ucar.ral.nujan.hdf.GlobalHeap;
import edu.ucar.ral.nujan.hdf.HBuffer;
import edu.ucar.ral.nujan.hdf.HdfChunk;
import edu.ucar.ral.nujan.hdf.HdfException;
import edu.ucar.ral.nujan.hdf.HdfFileWriter;
import edu.ucar.ral.nujan.hdf.HdfModInt;
import edu.ucar.ral.nujan.hdf.HdfUtil;
import edu.ucar.ral.nujan.hdf.MsgAttrInfo;
import edu.ucar.ral.nujan.hdf.MsgAttribute;
import edu.ucar.ral.nujan.hdf.MsgBase;
import edu.ucar.ral.nujan.hdf.MsgDataSpace;
import edu.ucar.ral.nujan.hdf.MsgDataType;
import edu.ucar.ral.nujan.hdf.MsgFillValue;
import edu.ucar.ral.nujan.hdf.MsgFilter;
import edu.ucar.ral.nujan.hdf.MsgGroupInfo;
import edu.ucar.ral.nujan.hdf.MsgKvalue;
import edu.ucar.ral.nujan.hdf.MsgLayout;
import edu.ucar.ral.nujan.hdf.MsgLinkInfo;
import edu.ucar.ral.nujan.hdf.MsgLinkit;
import edu.ucar.ral.nujan.hdf.MsgModTime;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class HdfGroup
extends BaseBlk {
    public static final int DTYPE_UNKNOWN = 0;
    public static final int DTYPE_SFIXED08 = 1;
    public static final int DTYPE_UFIXED08 = 2;
    public static final int DTYPE_FIXED16 = 3;
    public static final int DTYPE_FIXED32 = 4;
    public static final int DTYPE_FIXED64 = 5;
    public static final int DTYPE_FLOAT32 = 6;
    public static final int DTYPE_FLOAT64 = 7;
    public static final int DTYPE_TEST_CHAR = 8;
    public static final int DTYPE_STRING_FIX = 9;
    public static final int DTYPE_STRING_VAR = 10;
    public static final int DTYPE_REFERENCE = 11;
    public static final int DTYPE_VLEN = 12;
    public static final int DTYPE_COMPOUND = 13;
    public static final String[] dtypeNames = new String[]{"UNKNOWN", "SFIXED08", "UFIXED08", "FIXED16", "FIXED32", "FIXED64", "FLOAT32", "FLOAT64", "TEST_CHAR", "STRING_FIX", "STRING_VAR", "REFERENCE", "VLEN", "COMPOUND"};
    final int signa = 79;
    final int signb = 72;
    final int signc = 68;
    final int signd = 82;
    ArrayList<HdfGroup> subGroupList = null;
    ArrayList<HdfGroup> subVariableList = null;
    MsgDataType msgDataType;
    MsgDataSpace msgDataSpace;
    MsgLayout msgLayout;
    MsgFillValue msgFillValue;
    MsgModTime msgModTime;
    MsgKvalue msgKvalue;
    MsgAttrInfo msgAttrInfo;
    MsgFilter msgFilter;
    boolean isVariable;
    String groupName;
    HdfGroup parentGroup;
    int stgFieldLen;
    int[] varDims;
    int[] specChunkDims;
    int varRank;
    long totNumEle;
    int elementLen;
    int compressionLevel;
    ArrayList<MsgBase> hdrMsgList;
    int dtype;
    int[] totChunkNums;
    HdfChunk[] hdfChunks;
    int linkCreationOrder = 0;

    HdfGroup(HdfFileWriter hdfFile) throws HdfException {
        super("HdfGroup: superBlockExtension", hdfFile);
        this.isVariable = false;
        this.groupName = "superBlockExtension";
        this.parentGroup = null;
        if (hdfFile.bugs >= 1) {
            HdfGroup.prtf("HdfGroup: new superblock extension group", new Object[0]);
        }
        this.subGroupList = new ArrayList();
        this.subVariableList = new ArrayList();
        this.msgModTime = new MsgModTime(hdfFile.utcModTimeMilliSec, this, hdfFile);
        this.msgKvalue = new MsgKvalue(this, hdfFile);
        this.hdrMsgList = new ArrayList();
        this.hdrMsgList.add(this.msgModTime);
        this.hdrMsgList.add(this.msgKvalue);
    }

    HdfGroup(String groupName, HdfGroup parentGroup, HdfFileWriter hdfFile) throws HdfException {
        super("HdfGroup: " + groupName, hdfFile);
        this.isVariable = false;
        this.groupName = groupName;
        this.parentGroup = parentGroup;
        if (hdfFile.bugs >= 1) {
            HdfGroup.prtf("HdfGroup: new group at path: \"" + this.getPath() + "\"", new Object[0]);
        }
        if (parentGroup != null) {
            HdfUtil.checkName(groupName, "subGroup in group \"" + parentGroup.groupName + "\"");
        }
        this.subGroupList = new ArrayList();
        this.subVariableList = new ArrayList();
        this.msgModTime = new MsgModTime(hdfFile.utcModTimeMilliSec, this, hdfFile);
        this.hdrMsgList = new ArrayList();
        this.hdrMsgList.add(this.msgModTime);
        this.msgAttrInfo = new MsgAttrInfo(this, hdfFile);
        this.hdrMsgList.add(this.msgAttrInfo);
    }

    HdfGroup(String groupName, HdfGroup parentGroup, int dtype, int[] dsubTypes, String[] subNames, int stgFieldLen, int[] varDims, int[] specChunkDims, Object fillValue, int compressionLevel, HdfFileWriter hdfFile) throws HdfException {
        super("HdfGroup: (var) " + groupName, hdfFile);
        int ii;
        int layoutClass;
        this.isVariable = true;
        this.groupName = groupName;
        this.parentGroup = parentGroup;
        this.dtype = dtype;
        this.stgFieldLen = stgFieldLen;
        this.compressionLevel = compressionLevel;
        if (hdfFile.bugs >= 1) {
            HdfGroup.prtf("HdfGroup: new dataset at path: \"" + this.getPath() + "\"" + "  type: " + HdfUtil.formatDtypeDim(dtype, varDims) + "  specChunkDims: " + HdfUtil.formatInts(specChunkDims), new Object[0]);
        }
        HdfUtil.checkName(groupName, "dataset in group \"" + parentGroup.groupName + "\"");
        this.varDims = (int[])(varDims == null ? null : Arrays.copyOf(varDims, varDims.length));
        if (specChunkDims == null) {
            layoutClass = 1;
            this.specChunkDims = null;
        } else {
            layoutClass = 2;
            this.specChunkDims = Arrays.copyOf(specChunkDims, specChunkDims.length);
        }
        if (varDims == null) {
            if (specChunkDims != null) {
                HdfGroup.throwerr("varDims == null but specChunkDims != null", new Object[0]);
            }
            if (compressionLevel > 0) {
                HdfGroup.throwerr("cannot use compression with null data", new Object[0]);
            }
        } else if (varDims.length == 0) {
            if (specChunkDims != null && specChunkDims.length > 0) {
                HdfGroup.throwerr("varDims len == 0 but specChunkDims != null", new Object[0]);
            }
            if (compressionLevel > 0) {
                HdfGroup.throwerr("cannot use compression with scalar data", new Object[0]);
            }
        } else {
            this.varDims = Arrays.copyOf(varDims, varDims.length);
        }
        this.varRank = 0;
        if (varDims != null) {
            this.varRank = varDims.length;
        }
        if (varDims == null) {
            this.totNumEle = 0L;
        } else if (varDims.length == 0) {
            this.totNumEle = 0L;
        } else {
            this.totNumEle = 1L;
            for (int ii2 : varDims) {
                this.totNumEle *= (long)ii2;
            }
        }
        if (hdfFile.bugs >= 1) {
            HdfGroup.prtf("HdfGroup: varRank: %d  totNumEle: %d", this.varRank, this.totNumEle);
        }
        if (specChunkDims != null) {
            if (specChunkDims.length != varDims.length) {
                HdfGroup.throwerr("specChunkDims len != varDims len", new Object[0]);
            }
            for (int ii3 = 0; ii3 < this.varRank; ++ii3) {
                if (specChunkDims[ii3] <= 0) {
                    HdfGroup.throwerr("invalid specChunkDims", new Object[0]);
                }
                if (specChunkDims[ii3] <= varDims[ii3]) continue;
                HdfGroup.throwerr("specChunkDims > varDims", new Object[0]);
            }
        }
        if (compressionLevel > 0 && layoutClass != 2) {
            HdfGroup.throwerr("if compressed, must use chunked", new Object[0]);
        }
        int[] numDimChunks = new int[this.varRank];
        int totNumChunks = 1;
        for (ii = 0; ii < this.varRank; ++ii) {
            if (specChunkDims == null) {
                numDimChunks[ii] = 1;
            } else {
                numDimChunks[ii] = varDims[ii] / specChunkDims[ii];
                if (numDimChunks[ii] * specChunkDims[ii] != varDims[ii]) {
                    int n = ii;
                    numDimChunks[n] = numDimChunks[n] + 1;
                }
            }
            totNumChunks *= numDimChunks[ii];
            if (hdfFile.bugs < 1) continue;
            HdfGroup.prtf("HdfGroup: %s: numDimChunks[%d]: %d", this.getPath(), ii, numDimChunks[ii]);
        }
        if (hdfFile.bugs >= 1) {
            HdfGroup.prtf("HdfGroup: %s: totNumChunks: %d", this.getPath(), totNumChunks);
        }
        this.totChunkNums = new int[this.varRank];
        if (this.varRank > 0) {
            this.totChunkNums[this.varRank - 1] = 1;
            for (ii = this.varRank - 2; ii >= 0; --ii) {
                this.totChunkNums[ii] = numDimChunks[ii + 1] * this.totChunkNums[ii + 1];
                if (hdfFile.bugs < 1) continue;
                HdfGroup.prtf("HdfGroup: %s: totChunkNums[%d]: %d", this.getPath(), ii, this.totChunkNums[ii]);
            }
        }
        this.hdfChunks = new HdfChunk[totNumChunks];
        int[] startIxs = new int[this.varRank];
        if (specChunkDims == null) {
            this.hdfChunks[0] = new HdfChunk(startIxs, this);
        } else {
            block4: for (int ichunk = 0; ichunk < totNumChunks; ++ichunk) {
                if (hdfFile.bugs >= 1) {
                    HdfGroup.prtf("HdfGroup: %s: ichunk: %d  calcChunkIx: %d  startIxs: %s", this.getPath(), ichunk, this.calcChunkIx(startIxs), HdfUtil.formatInts(startIxs));
                }
                if (this.calcChunkIx(startIxs) != ichunk) {
                    HdfGroup.throwerr("calcChunkIx error", new Object[0]);
                }
                this.hdfChunks[ichunk] = new HdfChunk(startIxs, this);
                if (hdfFile.bugs >= 1) {
                    HdfGroup.prtf("HdfGroup: %s: hdfChunks[%d]: %s", this.getPath(), ichunk, this.hdfChunks[ichunk]);
                }
                for (int ii4 = this.varRank - 1; ii4 >= 0; --ii4) {
                    int n = ii4;
                    startIxs[n] = startIxs[n] + specChunkDims[ii4];
                    if (startIxs[ii4] < varDims[ii4]) continue block4;
                    startIxs[ii4] = 0;
                }
            }
        }
        this.msgDataType = new MsgDataType(dtype, dsubTypes, subNames, stgFieldLen, this, hdfFile);
        this.elementLen = this.msgDataType.elementLen;
        this.msgDataSpace = new MsgDataSpace(this.varRank, this.totNumEle, varDims, this, hdfFile);
        this.msgLayout = new MsgLayout(layoutClass, compressionLevel, this, hdfFile);
        boolean isFillExtant = false;
        if (fillValue != null) {
            isFillExtant = true;
        }
        this.msgFillValue = new MsgFillValue(dtype, isFillExtant, fillValue, this, hdfFile);
        this.msgModTime = new MsgModTime(hdfFile.utcModTimeMilliSec, this, hdfFile);
        this.hdrMsgList = new ArrayList();
        this.hdrMsgList.add(this.msgDataType);
        this.hdrMsgList.add(this.msgDataSpace);
        this.hdrMsgList.add(this.msgLayout);
        this.hdrMsgList.add(this.msgFillValue);
        this.hdrMsgList.add(this.msgModTime);
        if (compressionLevel > 0) {
            this.msgFilter = new MsgFilter(1, compressionLevel, this, hdfFile);
            this.hdrMsgList.add(this.msgFilter);
        }
        this.msgAttrInfo = new MsgAttrInfo(this, hdfFile);
        this.hdrMsgList.add(this.msgAttrInfo);
    }

    public HdfGroup addGroup(String subName) throws HdfException {
        if (this.hdfFile.fileStatus != 1) {
            HdfGroup.throwerr("cannot define after calling endDefine", new Object[0]);
        }
        if (this.isVariable) {
            HdfGroup.throwerr("cannot add a group to a variable", new Object[0]);
        }
        if (this.findSubItem(subName) != null) {
            HdfGroup.throwerr("Duplicate subgroup.  The group \"%s\" already contains a subgroup or variable named \"%s\"", this.groupName, subName);
        }
        HdfGroup subGroup = new HdfGroup(subName, this, this.hdfFile);
        this.addSubGroup(subGroup);
        return subGroup;
    }

    public HdfGroup addVariable(String varName, int dtype, int stgFieldLen, int[] varDims, int[] specChunkDims, Object fillValue, int compressionLevel) throws HdfException {
        if (this.hdfFile.fileStatus != 1) {
            HdfGroup.throwerr("cannot define after calling endDefine", new Object[0]);
        }
        if (this.isVariable) {
            HdfGroup.throwerr("cannot add a variable to a variable", new Object[0]);
        }
        if (this.findSubItem(varName) != null) {
            HdfGroup.throwerr("Duplicate subgroup.  The group \"%s\" already contains a subgroup or variable named \"%s\"", this.groupName, varName);
        }
        long statTimea = this.hdfFile.printStat(0L, "grp.addVariable.entry", "varName: " + varName + "  dtype: " + dtypeNames[dtype] + "  compLev: " + compressionLevel + "  varDims: " + HdfUtil.formatInts(varDims) + "  specChunkDims: " + HdfUtil.formatInts(specChunkDims));
        int[] dsubTypes = null;
        String[] subNames = null;
        if (dtype == 13) {
            dsubTypes = new int[]{11, 4};
            subNames = new String[]{"dataset", "dimension"};
        }
        HdfGroup var = new HdfGroup(varName, this, dtype, dsubTypes, subNames, stgFieldLen, varDims, specChunkDims, fillValue, compressionLevel, this.hdfFile);
        this.addSubGroup(var);
        return var;
    }

    public void addAttribute(String attrName, int attrType, int stgFieldLen, Object attrValue, boolean isVlen) throws HdfException {
        if (this.hdfFile.bugs >= 1) {
            String tmsg = "HdfGroup.addAttribute: \"" + this.getPath() + "/" + attrName + "\"" + "  cls: ";
            tmsg = attrValue == null ? tmsg + "(null)" : tmsg + attrValue.getClass().getName();
            HdfGroup.prtf(tmsg, new Object[0]);
        }
        if (this.hdfFile.bugs >= 5) {
            HdfGroup.prtf("  attr isVlen: " + isVlen, new Object[0]);
            HdfGroup.prtf("  attrValue: \"%s\"", HdfUtil.formatObject(attrValue));
        }
        HdfUtil.checkName(attrName, "attribute in group \"" + this.groupName + "\"");
        if (this.findAttribute(attrName) != null) {
            HdfGroup.throwerr("Duplicate attribute.  The group \"%s\" already contains an attribute named \"%s\"", this.getPath(), attrName);
        }
        MsgAttribute msgAttr = new MsgAttribute(attrName, attrType, stgFieldLen, attrValue, isVlen, this, this.hdfFile);
        this.hdrMsgList.add(msgAttr);
        if (this.hdfFile.bugs >= 5) {
            HdfGroup.prtf("HdfGroup.addAttribute: added name: \"" + attrName + "\"\n" + "  at path: \"" + this.getPath() + "\"\n" + "  dtype: " + dtypeNames[attrType] + "\n" + "  type: " + HdfUtil.formatDtypeDim(attrType, msgAttr.dataVarDims) + "\n" + "  isVlen: " + isVlen, new Object[0]);
        }
    }

    @Override
    public String toString() {
        String res = "path: \"" + this.getPath() + "\"" + "  isVariable: " + this.isVariable;
        if (this.isVariable) {
            res = res + "  dtype: " + dtypeNames[this.dtype] + "  dataSpace: " + this.msgDataSpace;
        } else {
            res = res + "  subGroupList: (";
            for (HdfGroup grp : this.subGroupList) {
                res = res + " " + grp.groupName;
            }
            res = res + ")";
            res = res + "  subVariableList: (";
            for (HdfGroup grp : this.subVariableList) {
                res = res + " " + grp.groupName;
            }
            res = res + ")";
        }
        return res;
    }

    String getPath() {
        String res = "";
        HdfGroup grp = this;
        while (grp != null) {
            if (res.length() != 0) {
                res = "/" + res;
            }
            res = grp.groupName + res;
            grp = grp.parentGroup;
        }
        if (res.length() == 0) {
            res = "/";
        }
        return res;
    }

    void addSubGroup(HdfGroup subGroup) throws HdfException {
        if (subGroup.isVariable) {
            this.subVariableList.add(subGroup);
        } else {
            this.subGroupList.add(subGroup);
        }
    }

    HdfGroup findSubItem(String subName) {
        HdfGroup resGroup = null;
        for (HdfGroup subGroup : this.subGroupList) {
            if (!subGroup.groupName.equals(subName)) continue;
            resGroup = subGroup;
            break;
        }
        if (resGroup == null) {
            for (HdfGroup subGroup : this.subVariableList) {
                if (!subGroup.groupName.equals(subName)) continue;
                resGroup = subGroup;
                break;
            }
        }
        return resGroup;
    }

    public MsgAttribute findAttribute(String attrName) {
        MsgAttribute resMsg = null;
        for (MsgBase baseMsg : this.hdrMsgList) {
            if (!(baseMsg instanceof MsgAttribute)) continue;
            MsgAttribute attrMsg = (MsgAttribute)baseMsg;
            if (!attrMsg.attrName.equals(attrName)) continue;
            resMsg = attrMsg;
            break;
        }
        return resMsg;
    }

    int getNumAttribute() {
        int ires = 0;
        for (MsgBase baseMsg : this.hdrMsgList) {
            if (!(baseMsg instanceof MsgAttribute)) continue;
            ++ires;
        }
        return ires;
    }

    public void writeData(int[] startIxs, Object vdata, boolean useLinear) throws HdfException {
        long statTimea = this.hdfFile.printStat(0L, "grp.writeData.entry", "useLinear: " + useLinear + "  startIxs: " + HdfUtil.formatInts(startIxs));
        try {
            this.writeDataSub(startIxs, vdata, useLinear);
        }
        catch (IOException exc) {
            exc.printStackTrace();
            HdfGroup.throwerr("caught: %s", exc);
        }
        this.hdfFile.printStat(statTimea, "grp.writeData.exit", "useLinear: " + useLinear + "  startIxs: " + HdfUtil.formatInts(startIxs));
    }

    void writeDataSub(int[] startIxs, Object vdata, boolean useLinear) throws HdfException, IOException {
        int[] sttIxs;
        int[] chunkDims;
        this.hdfFile.outChannel.position(HdfUtil.alignLong(8L, this.hdfFile.eofAddr));
        if (this.hdfFile.bugs >= 1) {
            HdfGroup.prtf("HdfGroup.writeData entry: path: " + this.getPath() + "\n" + "  specified type: " + HdfUtil.formatDtypeDim(this.dtype, this.varDims) + "\n" + "  useLinear: " + useLinear + "\n" + "  eofAddr: " + this.hdfFile.eofAddr + "\n" + "  new pos: " + this.hdfFile.outChannel.position() + "\n" + "  startIxs: " + HdfUtil.formatInts(startIxs), new Object[0]);
        }
        if (this.hdfFile.fileStatus != 2) {
            HdfGroup.throwerr("must call endDefine first", new Object[0]);
        }
        if (!this.isVariable) {
            HdfGroup.throwerr("cannot write data to a group", new Object[0]);
        }
        int[] dataInfo = HdfUtil.getDimLen(vdata, false);
        int dataDtype = dataInfo[0];
        int dataTotNumEle = dataInfo[1];
        int dataElementLen = dataInfo[2];
        int[] dataDims = Arrays.copyOfRange(dataInfo, 3, dataInfo.length);
        if (this.hdfFile.bugs >= 1) {
            HdfGroup.prtf("HdfGroup.writeData: actual data:\n  vdata object: " + vdata + "\n" + "  vdata class: " + vdata.getClass() + "\n" + "  dtype:  declared: " + dtypeNames[this.dtype] + "  actual: " + dtypeNames[dataDtype] + "\n" + "  totNumEle:  declared: " + this.totNumEle + "  actual: " + dataTotNumEle + "\n" + "  elementLen:  declared: " + this.elementLen + "  actual: " + dataElementLen + "\n" + "  varRank:  declared: " + this.varRank + "  actual: " + dataDims.length + "\n" + "  vdata type and dims: " + HdfUtil.formatDtypeDim(dataDtype, dataDims), new Object[0]);
        }
        int ichunk = 0;
        if (startIxs == null) {
            if (this.specChunkDims != null) {
                HdfGroup.throwerr("startIxs == null but specChunkDims != null", new Object[0]);
            }
            ichunk = 0;
        } else {
            if (this.specChunkDims == null) {
                HdfGroup.throwerr("startIxs != null but specChunkDims == null", new Object[0]);
            }
            ichunk = this.calcChunkIx(startIxs);
        }
        HdfChunk chunk = this.hdfChunks[ichunk];
        if (this.hdfFile.bugs >= 1) {
            HdfGroup.prtf("HdfGroup.writeData: ichunk: %d  chunk: %s", ichunk, chunk);
        }
        if ((chunkDims = this.specChunkDims) == null) {
            chunkDims = this.varDims;
        }
        if ((sttIxs = startIxs) == null) {
            sttIxs = new int[this.varRank];
        }
        if (this.hdfFile.bugs >= 1) {
            HdfGroup.prtf("  useLinear: %s", useLinear);
            HdfGroup.prtf("  varDims: %s", HdfUtil.formatInts(this.varDims));
            HdfGroup.prtf("  specChunkDims: %s", HdfUtil.formatInts(this.specChunkDims));
            HdfGroup.prtf("  chunkDims: %s", HdfUtil.formatInts(chunkDims));
            HdfGroup.prtf("  startIxs: %s", HdfUtil.formatInts(startIxs));
            HdfGroup.prtf("  sttIxs: %s", HdfUtil.formatInts(sttIxs));
            HdfGroup.prtf("  dataDims: %s", HdfUtil.formatInts(dataDims));
        }
        HdfUtil.checkTypeMatch(this.getPath(), this.dtype, dataDtype, useLinear, this.varDims, sttIxs, chunkDims, dataDims);
        if (chunk.chunkDataAddr != 0L) {
            HdfGroup.throwerr("chunk has already been written.  path: %s  startIxs: %s", this.getPath(), HdfUtil.formatInts(chunk.chunkStartIxs));
        }
        HBuffer outbuf = new HBuffer(this.hdfFile.outChannel, this.compressionLevel, this.hdfFile);
        if (this.dtype == 12) {
            HdfGroup.throwerr("DTYPE_VLEN datasets are not supported", new Object[0]);
        }
        if (this.dtype == 10) {
            if (this.compressionLevel > 0) {
                HdfGroup.throwerr("compression not supported for DTYPE_STRING_VAR", new Object[0]);
            }
            GlobalHeap gcol = new GlobalHeap(this.hdfFile);
            HBuffer refBuf = new HBuffer(null, this.compressionLevel, this.hdfFile);
            long gcolAddr = this.hdfFile.outChannel.position();
            if (this.hdfFile.bugs >= 2) {
                HdfGroup.prtf("writeDataSub: call formatRawData for string data", new Object[0]);
            }
            int[] curIxs = new int[this.varRank];
            this.formatRawData("groupName: " + this.groupName, 0, curIxs, useLinear, this.dtype, 0, this.varDims, chunkDims, dataDims, dataElementLen, startIxs, vdata, null, gcolAddr, gcol, refBuf);
            if (this.hdfFile.bugs >= 5) {
                HdfGroup.prtf("  writeDataSub.STRING_VAR: gcol: %s", gcol);
                HdfGroup.prtf("  writeDataSub.STRING_VAR: refBuf: %s", refBuf);
            }
            gcol.formatBuf(0, outbuf);
            outbuf.flush();
            chunk.chunkDataAddr = HdfUtil.alignLong(8L, this.hdfFile.outChannel.position());
            this.hdfFile.outChannel.position(chunk.chunkDataAddr);
            refBuf.writeChannel(this.hdfFile.outChannel);
        } else {
            chunk.chunkDataAddr = HdfUtil.alignLong(8L, this.hdfFile.eofAddr);
            this.hdfFile.outChannel.position(chunk.chunkDataAddr);
            if (this.hdfFile.bugs >= 2) {
                HdfGroup.prtf("writeDataSub: call formatRawData for numeric data", new Object[0]);
            }
            int[] curIxs = new int[this.varRank];
            this.formatRawData("groupName: " + this.groupName, 0, curIxs, useLinear, this.dtype, this.stgFieldLen, this.varDims, chunkDims, dataDims, dataElementLen, startIxs, vdata, new HdfModInt(0), -1L, null, outbuf);
            outbuf.flush();
        }
        long endPos = this.hdfFile.outChannel.position();
        chunk.chunkDataSize = endPos - chunk.chunkDataAddr;
        if (this.hdfFile.bugs >= 2) {
            HdfGroup.prtf("HdfGroup.writeData exit: path: " + this.getPath(), new Object[0]);
            HdfGroup.prtf("  chunkDataAddr: %d  endPos: %d  chunkDataSize: %d", chunk.chunkDataAddr, endPos, chunk.chunkDataSize);
            HdfGroup.prtf("  old eofAddr: %d", this.hdfFile.eofAddr);
        }
        this.hdfFile.eofAddr = this.hdfFile.outChannel.position();
        if (this.hdfFile.bugs >= 2) {
            HdfGroup.prtf("  new eofAddr: %d", this.hdfFile.eofAddr);
        }
    }

    int calcChunkIx(int[] startIxs) throws HdfException {
        int ichunk = 0;
        for (int ii = 0; ii < this.varRank; ++ii) {
            if (startIxs[ii] < 0) {
                HdfGroup.throwerr("startIxs[%d] == %d is < 0: %d", ii, startIxs[ii]);
            }
            if (startIxs[ii] >= this.varDims[ii]) {
                HdfGroup.throwerr("startIxs[%d] == %d is >= varDims[%d] == %d", ii, startIxs[ii], ii, this.varDims[ii]);
            }
            if (this.specChunkDims == null) {
                if (startIxs[ii] == 0) continue;
                HdfGroup.throwerr("startIxs != 0 for specChunkDims == null", new Object[0]);
                continue;
            }
            if (startIxs[ii] % this.specChunkDims[ii] != 0) {
                HdfGroup.throwerr("startIxs[%d] == %d is not a multiple of specChunkDims[%d] == %d", ii, startIxs[ii], ii, this.specChunkDims[ii]);
            }
            ichunk += startIxs[ii] / this.specChunkDims[ii] * this.totChunkNums[ii];
        }
        if (ichunk < 0 || ichunk >= this.hdfChunks.length) {
            HdfGroup.throwerr("invalid ichunk", new Object[0]);
        }
        return ichunk;
    }

    @Override
    void formatBuf(int formatPass, HBuffer fmtBuf) throws HdfException {
        this.setFormatEntry(formatPass, true, fmtBuf);
        if (formatPass == 1) {
            if (!this.isVariable) {
                this.hdrMsgList.add(new MsgGroupInfo(this, this.hdfFile));
                this.hdrMsgList.add(new MsgLinkInfo(this, this.hdfFile));
            }
            if (this.subGroupList != null) {
                for (HdfGroup subGroup : this.subGroupList) {
                    this.hdrMsgList.add(new MsgLinkit(this.linkCreationOrder++, subGroup, this, this.hdfFile));
                }
            }
            if (this.subVariableList != null) {
                for (HdfGroup subGroup : this.subVariableList) {
                    this.hdrMsgList.add(new MsgLinkit(this.linkCreationOrder++, subGroup, this, this.hdfFile));
                }
            }
        }
        HBuffer tempHbuf = new HBuffer(null, 0, this.hdfFile);
        int svIndent = this.hdfFile.indent;
        this.hdfFile.indent += 6;
        if (this.hdfFile.bugs >= 5) {
            this.prtIndent("Start HdfGroup temp layout", new Object[0]);
        }
        long chunk0Len = 0L;
        chunk0Len = this.layoutVersion2(0, chunk0Len, tempHbuf);
        if (this.hdfFile.bugs >= 5) {
            this.prtIndent("End HdfGroup temp layout", new Object[0]);
        }
        this.hdfFile.indent = svIndent;
        this.layoutVersion2(formatPass, chunk0Len, fmtBuf);
        this.noteFormatExit(fmtBuf);
    }

    long layoutVersion2(int formatPass, long prevChunk0Len, HBuffer fmtBuf) throws HdfException {
        long startAllPos = fmtBuf.getPos();
        fmtBuf.putBufByte("HdfGroup: signa", 79);
        fmtBuf.putBufByte("HdfGroup: signb", 72);
        fmtBuf.putBufByte("HdfGroup: signc", 68);
        fmtBuf.putBufByte("HdfGroup: signd", 82);
        fmtBuf.putBufByte("HdfGroup: groupVersion", 2);
        int lenMask = prevChunk0Len <= 255L ? 0 : (prevChunk0Len <= 65535L ? 1 : (prevChunk0Len <= 0xFFFFFFFFL ? 2 : 3));
        int flag = lenMask | 4 | 8 | 0x20;
        fmtBuf.putBufByte("HdfGroup: flags", flag);
        if ((flag & 0x20) != 0) {
            fmtBuf.putBufInt("HdfGroup: accessTime", (int)this.hdfFile.utcModTimeSec);
            fmtBuf.putBufInt("HdfGroup: modTime", (int)this.hdfFile.utcModTimeSec);
            fmtBuf.putBufInt("HdfGroup: changeTime", (int)this.hdfFile.utcModTimeSec);
            fmtBuf.putBufInt("HdfGroup: birthTime", (int)this.hdfFile.utcModTimeSec);
        }
        if ((flag & 0x10) != 0) {
            fmtBuf.putBufShort("HdfGroup: maxNumCompact", 30000);
            fmtBuf.putBufShort("HdfGroup: minNumDense", 0);
        }
        if (lenMask == 0) {
            fmtBuf.putBufByte("HdfGroup: chunk0Len", (int)prevChunk0Len);
        } else if (lenMask == 1) {
            fmtBuf.putBufShort("HdfGroup: chunk0Len", (int)prevChunk0Len);
        } else if (lenMask == 2) {
            fmtBuf.putBufInt("HdfGroup: chunk0Len", (int)prevChunk0Len);
        } else if (lenMask == 3) {
            fmtBuf.putBufLong("HdfGroup: chunk0Len", prevChunk0Len);
        }
        long startMsgPos = fmtBuf.getPos();
        for (MsgBase hmsg : this.hdrMsgList) {
            hmsg.formatFullMsg(formatPass, fmtBuf);
            if (this.hdfFile.bugs < 5) continue;
            this.prtIndent("Group write: above hmsg type: 0x%x == %d  size: 0x%x == %d", hmsg.hdrMsgType, hmsg.hdrMsgType, hmsg.hdrMsgSize, hmsg.hdrMsgSize);
        }
        long endPos = fmtBuf.getPos();
        byte[] chkBytes = fmtBuf.getBufBytes(startAllPos, endPos);
        int checkSumHack = new CheckSumHack().calcHackSum(chkBytes);
        fmtBuf.putBufInt("HdfGroup: checkSumHack", checkSumHack);
        long chunk0Len = endPos - startMsgPos;
        return chunk0Len;
    }

    void formatRawData(String msg, int curLev, int[] curIxs, boolean useLinear, int dtp, int stgFieldLen, int[] varDims, int[] chunkDims, int[] dataDims, int dataElementLen, int[] startIxs, Object vdata, HdfModInt cntr, long gcolAddr, GlobalHeap gcol, HBuffer fmtBuf) throws HdfException {
        block88: {
            boolean useLinearFull;
            int[] virtDataDims;
            int rank;
            block86: {
                block105: {
                    block104: {
                        block103: {
                            block102: {
                                block101: {
                                    block100: {
                                        block99: {
                                            int aval;
                                            block98: {
                                                block97: {
                                                    block96: {
                                                        block95: {
                                                            block94: {
                                                                block93: {
                                                                    block92: {
                                                                        block91: {
                                                                            block90: {
                                                                                block89: {
                                                                                    block87: {
                                                                                        rank = varDims.length;
                                                                                        if (vdata == null) {
                                                                                            HdfGroup.throwerr("vdata is null", new Object[0]);
                                                                                        }
                                                                                        if (this.hdfFile.bugs >= 2) {
                                                                                            this.prtIndent("formatRawData entry for: " + msg, new Object[0]);
                                                                                            this.prtIndent("  curLev: " + curLev, new Object[0]);
                                                                                            this.prtIndent("  curIxs: " + HdfUtil.formatInts(curIxs), new Object[0]);
                                                                                            this.prtIndent("  useLinear: " + useLinear, new Object[0]);
                                                                                            this.prtIndent("  dtp: " + dtypeNames[dtp], new Object[0]);
                                                                                            this.prtIndent("  stgFieldLen: " + stgFieldLen, new Object[0]);
                                                                                            this.prtIndent("  varDims: " + HdfUtil.formatInts(varDims), new Object[0]);
                                                                                            this.prtIndent("  chunkDims: " + HdfUtil.formatInts(chunkDims), new Object[0]);
                                                                                            this.prtIndent("  dataDims: " + HdfUtil.formatInts(dataDims), new Object[0]);
                                                                                            this.prtIndent("  dataElementLen: " + dataElementLen, new Object[0]);
                                                                                            this.prtIndent("  startIxs: " + HdfUtil.formatInts(startIxs), new Object[0]);
                                                                                            this.prtIndent("  vdata class: " + vdata.getClass(), new Object[0]);
                                                                                            this.prtIndent("  cntr: " + cntr, new Object[0]);
                                                                                            this.prtIndent("  rank: " + rank, new Object[0]);
                                                                                            Object tobj = vdata;
                                                                                            while (tobj instanceof Object[] && ((Object[])tobj).length > 0) {
                                                                                                tobj = ((Object[])tobj)[0];
                                                                                                this.prtIndent("    vdata nested class: " + tobj.getClass(), new Object[0]);
                                                                                            }
                                                                                            this.prtIndent("  fmtBuf: " + fmtBuf, new Object[0]);
                                                                                        }
                                                                                        if (startIxs == null) {
                                                                                            startIxs = new int[rank];
                                                                                        }
                                                                                        for (int ii = 0; ii < rank; ++ii) {
                                                                                            if (varDims[ii] <= 0) {
                                                                                                HdfGroup.throwerr("invalid varDims: " + HdfUtil.formatInts(varDims), new Object[0]);
                                                                                            }
                                                                                            if (chunkDims[ii] <= 0 || chunkDims[ii] > varDims[ii]) {
                                                                                                HdfGroup.throwerr("invalid chunkDims: " + HdfUtil.formatInts(chunkDims), new Object[0]);
                                                                                            }
                                                                                            if (curIxs[ii] < 0 || curIxs[ii] >= chunkDims[ii]) {
                                                                                                HdfGroup.throwerr("invalid curIxs: " + HdfUtil.formatInts(curIxs), new Object[0]);
                                                                                            }
                                                                                            if (useLinear) {
                                                                                                if (dataDims.length == 0 || dataDims.length == 1) continue;
                                                                                                HdfGroup.throwerr("useLinear but data rank not 0 or 1", new Object[0]);
                                                                                                continue;
                                                                                            }
                                                                                            if (dataDims[ii] > 0 && dataDims[ii] <= chunkDims[ii]) continue;
                                                                                            HdfGroup.throwerr("invalid dataDims: " + HdfUtil.formatInts(dataDims), new Object[0]);
                                                                                        }
                                                                                        virtDataDims = null;
                                                                                        useLinearFull = false;
                                                                                        if (rank > 0) {
                                                                                            if (useLinear) {
                                                                                                int ii;
                                                                                                int chunkVolume = 1;
                                                                                                int remVolume = 1;
                                                                                                for (ii = 0; ii < rank; ++ii) {
                                                                                                    chunkVolume *= chunkDims[ii];
                                                                                                    int remLen = Math.min(chunkDims[ii], varDims[ii] - startIxs[ii]);
                                                                                                    remVolume *= remLen;
                                                                                                }
                                                                                                if (this.hdfFile.bugs >= 2) {
                                                                                                    this.prtIndent("  chunkVolume: " + chunkVolume, new Object[0]);
                                                                                                    this.prtIndent("  remVolume: " + remVolume, new Object[0]);
                                                                                                }
                                                                                                if (dataDims.length != 1) {
                                                                                                    HdfGroup.throwerr("invalid dataDims", new Object[0]);
                                                                                                }
                                                                                                if (dataDims[0] == chunkVolume) {
                                                                                                    useLinearFull = true;
                                                                                                    virtDataDims = Arrays.copyOf(chunkDims, chunkDims.length);
                                                                                                } else if (dataDims[0] == remVolume) {
                                                                                                    virtDataDims = new int[rank];
                                                                                                    for (ii = 0; ii < rank; ++ii) {
                                                                                                        virtDataDims[ii] = Math.min(chunkDims[ii], varDims[ii] - startIxs[ii]);
                                                                                                    }
                                                                                                } else {
                                                                                                    HdfGroup.throwerr("wrong linear len", new Object[0]);
                                                                                                }
                                                                                            } else {
                                                                                                virtDataDims = Arrays.copyOf(dataDims, dataDims.length);
                                                                                            }
                                                                                            if (this.hdfFile.bugs >= 2) {
                                                                                                this.prtIndent("  virtDataDims: " + HdfUtil.formatInts(virtDataDims), new Object[0]);
                                                                                            }
                                                                                        }
                                                                                        if (rank != 0) break block86;
                                                                                        if (this.hdfFile.bugs < 2) break block87;
                                                                                        this.prtIndent("  Scalar or empty array", new Object[0]);
                                                                                        break block88;
                                                                                    }
                                                                                    if (!(vdata instanceof byte[])) break block89;
                                                                                    if (this.hdfFile.bugs < 2) break block88;
                                                                                    this.prtIndent("formatRawData: empty byte array", new Object[0]);
                                                                                    break block88;
                                                                                }
                                                                                if (!(vdata instanceof short[])) break block90;
                                                                                if (this.hdfFile.bugs < 2) break block88;
                                                                                this.prtIndent("formatRawData: empty short array", new Object[0]);
                                                                                break block88;
                                                                            }
                                                                            if (!(vdata instanceof int[])) break block91;
                                                                            if (this.hdfFile.bugs < 2) break block88;
                                                                            this.prtIndent("formatRawData: empty int array", new Object[0]);
                                                                            break block88;
                                                                        }
                                                                        if (!(vdata instanceof long[])) break block92;
                                                                        if (this.hdfFile.bugs < 2) break block88;
                                                                        this.prtIndent("formatRawData: empty long array", new Object[0]);
                                                                        break block88;
                                                                    }
                                                                    if (!(vdata instanceof float[])) break block93;
                                                                    if (this.hdfFile.bugs < 2) break block88;
                                                                    this.prtIndent("formatRawData: empty float array", new Object[0]);
                                                                    break block88;
                                                                }
                                                                if (!(vdata instanceof double[])) break block94;
                                                                if (this.hdfFile.bugs < 2) break block88;
                                                                this.prtIndent("formatRawData: empty double array", new Object[0]);
                                                                break block88;
                                                            }
                                                            if (!(vdata instanceof String[])) break block95;
                                                            if (this.hdfFile.bugs < 2) break block88;
                                                            this.prtIndent("formatRawData: empty String array", new Object[0]);
                                                            break block88;
                                                        }
                                                        if (!(vdata instanceof HdfGroup[])) break block96;
                                                        if (this.hdfFile.bugs < 2) break block88;
                                                        this.prtIndent("formatRawData: empty HdfGroup array", new Object[0]);
                                                        break block88;
                                                    }
                                                    if (!(vdata instanceof Byte)) break block97;
                                                    this.checkDtype(1, 2, dtp);
                                                    aval = ((Byte)vdata).byteValue();
                                                    fmtBuf.putBufByte("formatRawData", aval);
                                                    break block88;
                                                }
                                                if (!(vdata instanceof Short)) break block98;
                                                this.checkDtype(3, dtp);
                                                aval = ((Short)vdata).shortValue();
                                                fmtBuf.putBufShort("formatRawData", aval);
                                                break block88;
                                            }
                                            if (!(vdata instanceof Integer)) break block99;
                                            this.checkDtype(4, dtp);
                                            aval = (Integer)vdata;
                                            fmtBuf.putBufInt("formatRawData", aval);
                                            break block88;
                                        }
                                        if (!(vdata instanceof Long)) break block100;
                                        this.checkDtype(5, dtp);
                                        long aval = (Long)vdata;
                                        fmtBuf.putBufLong("formatRawData", aval);
                                        break block88;
                                    }
                                    if (!(vdata instanceof Float)) break block101;
                                    this.checkDtype(6, dtp);
                                    float aval = ((Float)vdata).floatValue();
                                    fmtBuf.putBufFloat("formatRawData", aval);
                                    break block88;
                                }
                                if (!(vdata instanceof Double)) break block102;
                                this.checkDtype(7, dtp);
                                double aval = (Double)vdata;
                                fmtBuf.putBufDouble("formatRawData", aval);
                                break block88;
                            }
                            if (!(vdata instanceof Character)) break block103;
                            this.checkDtype(9, dtp);
                            fmtBuf.putBufByte("formatRawData", ((Character)vdata).charValue());
                            break block88;
                        }
                        if (!(vdata instanceof String)) break block104;
                        this.checkDtype(9, 10, dtp);
                        String aval = (String)vdata;
                        if (dtp == 9) {
                            byte[] bytes = HdfUtil.encodeString(aval, false, this);
                            fmtBuf.putBufBytes("formatRawData", HdfUtil.truncPadNull(bytes, stgFieldLen));
                        } else if (dtp == 10) {
                            byte[] bytes = HdfUtil.encodeString((String)vdata, false, this);
                            int gcolIx = gcol.putHeapItem("vlen string data", bytes);
                            fmtBuf.putBufInt("vlen len", bytes.length);
                            fmtBuf.putBufLong("vlen gcol addr", gcolAddr);
                            fmtBuf.putBufInt("vlen gcol ix", gcolIx);
                        } else {
                            HdfGroup.throwerr("dtp mismatch", new Object[0]);
                        }
                        break block88;
                    }
                    if (!(vdata instanceof HdfGroup)) break block105;
                    long aval = ((HdfGroup)vdata).blkPosition;
                    fmtBuf.putBufLong("formatRawData", aval);
                    if (dtp != 13) break block88;
                    fmtBuf.putBufInt("formatRawData ref ix", cntr.getValue());
                    cntr.increment();
                    break block88;
                }
                HdfGroup.throwerr("unknown type: " + vdata.getClass(), new Object[0]);
                break block88;
            }
            if (curLev < rank - 1) {
                for (int ii = 0; ii < chunkDims[curLev]; ++ii) {
                    if (this.hdfFile.bugs >= 2) {
                        this.prtIndent("  curIxs loop.  curLev: " + curLev + "  curIxs: " + curIxs[curLev], new Object[0]);
                    }
                    curIxs[curLev] = ii;
                    if (this.hdfFile.bugs >= 2) {
                        HdfGroup.prtf("formatRawData: call recursion. old curLev: " + curLev + "  ii: " + ii, new Object[0]);
                    }
                    this.formatRawData(msg, curLev + 1, curIxs, useLinear, dtp, stgFieldLen, varDims, chunkDims, dataDims, dataElementLen, startIxs, vdata, cntr, gcolAddr, gcol, fmtBuf);
                }
            } else {
                if (this.hdfFile.bugs >= 2) {
                    this.prtIndent("  curIxs are complete: " + HdfUtil.formatInts(curIxs), new Object[0]);
                }
                boolean isAllPad = false;
                for (int ii = 0; ii < rank - 1; ++ii) {
                    if (curIxs[ii] < virtDataDims[ii] || virtDataDims[ii] >= chunkDims[ii]) continue;
                    if (startIxs[ii] + virtDataDims[ii] != varDims[ii]) {
                        HdfGroup.throwerr("virtDataDims error", new Object[0]);
                    }
                    isAllPad = true;
                    if (this.hdfFile.bugs < 2) break;
                    this.prtIndent("  Set isAllPad: ii: " + ii + "  curIxs: " + curIxs[ii] + "  virtDataDims: " + virtDataDims[ii], new Object[0]);
                    break;
                }
                int padLen = 0;
                int padEleLen = dataElementLen;
                if (isAllPad) {
                    padLen = chunkDims[rank - 1];
                    if (this.hdfFile.bugs >= 2) {
                        this.prtIndent("  all padLen: " + padLen, new Object[0]);
                    }
                } else {
                    Object[] avec;
                    int ii;
                    int writeLen = virtDataDims[rank - 1];
                    padLen = chunkDims[rank - 1] - writeLen;
                    if (this.hdfFile.bugs >= 2) {
                        this.prtIndent("  writeLen: " + writeLen, new Object[0]);
                        this.prtIndent("  padLen: " + padLen, new Object[0]);
                    }
                    if (padLen > 0 && startIxs[rank - 1] + virtDataDims[rank - 1] != varDims[rank - 1]) {
                        HdfGroup.throwerr("virtDataDims mismatch", new Object[0]);
                    }
                    Object vdataOb = null;
                    int linearIx = 0;
                    if (useLinear) {
                        int[] prods = new int[rank];
                        prods[rank - 1] = 1;
                        for (ii = rank - 2; ii >= 0; --ii) {
                            int remLen = chunkDims[ii + 1];
                            if (!useLinearFull) {
                                remLen = Math.min(chunkDims[ii + 1], varDims[ii + 1] - startIxs[ii + 1]);
                            }
                            prods[ii] = remLen * prods[ii + 1];
                        }
                        if (this.hdfFile.bugs >= 2) {
                            this.prtIndent("  prods: " + HdfUtil.formatInts(prods), new Object[0]);
                        }
                        linearIx = 0;
                        for (ii = 0; ii < rank - 1; ++ii) {
                            linearIx += curIxs[ii] * prods[ii];
                        }
                        if (this.hdfFile.bugs >= 2) {
                            this.prtIndent("  linearIx: %d", linearIx);
                        }
                        vdataOb = vdata;
                    } else {
                        vdataOb = vdata;
                        for (int ii2 = 0; ii2 < rank - 1; ++ii2) {
                            Object[] objVec;
                            if (!(vdataOb instanceof Object[])) {
                                HdfGroup.throwerr("wrong types", new Object[0]);
                            }
                            if (curIxs[ii2] >= (objVec = (Object[])vdataOb).length) {
                                HdfGroup.throwerr("dim err", new Object[0]);
                            }
                            vdataOb = objVec[curIxs[ii2]];
                        }
                        linearIx = 0;
                    }
                    if (vdataOb instanceof byte[]) {
                        this.checkDtype(1, 2, dtp);
                        avec = (byte[])vdataOb;
                        if (this.hdfFile.bugs >= 2) {
                            this.prtIndent("formatRawData byte vec len: " + avec.length, new Object[0]);
                        }
                        for (ii = 0; ii < writeLen; ++ii) {
                            fmtBuf.putBufByte("formatRawData", 0xFF & avec[linearIx + ii]);
                        }
                    } else if (vdataOb instanceof short[]) {
                        this.checkDtype(3, dtp);
                        avec = (short[])vdataOb;
                        if (this.hdfFile.bugs >= 2) {
                            this.prtIndent("formatRawData short vec len: " + avec.length, new Object[0]);
                        }
                        for (ii = 0; ii < writeLen; ++ii) {
                            fmtBuf.putBufShort("formatRawData", avec[linearIx + ii]);
                        }
                    } else if (vdataOb instanceof int[]) {
                        this.checkDtype(4, dtp);
                        avec = (int[])vdataOb;
                        if (this.hdfFile.bugs >= 2) {
                            this.prtIndent("formatRawData int vec len: " + avec.length, new Object[0]);
                        }
                        for (ii = 0; ii < writeLen; ++ii) {
                            fmtBuf.putBufInt("formatRawData", avec[linearIx + ii]);
                        }
                    } else if (vdataOb instanceof long[]) {
                        this.checkDtype(5, dtp);
                        avec = (long[])vdataOb;
                        if (this.hdfFile.bugs >= 2) {
                            this.prtIndent("formatRawData long vec len: " + avec.length, new Object[0]);
                        }
                        for (ii = 0; ii < writeLen; ++ii) {
                            fmtBuf.putBufLong("formatRawData", avec[linearIx + ii]);
                        }
                    } else if (vdataOb instanceof float[]) {
                        this.checkDtype(6, dtp);
                        avec = (float[])vdataOb;
                        if (this.hdfFile.bugs >= 2) {
                            this.prtIndent("formatRawData float vec len: " + avec.length, new Object[0]);
                        }
                        for (ii = 0; ii < writeLen; ++ii) {
                            fmtBuf.putBufFloat("formatRawData", avec[linearIx + ii]);
                        }
                    } else if (vdataOb instanceof double[]) {
                        this.checkDtype(7, dtp);
                        avec = (double[])vdataOb;
                        if (this.hdfFile.bugs >= 2) {
                            this.prtIndent("formatRawData double vec len: " + avec.length, new Object[0]);
                        }
                        for (ii = 0; ii < writeLen; ++ii) {
                            fmtBuf.putBufDouble("formatRawData", avec[linearIx + ii]);
                        }
                    } else if (vdataOb instanceof String[] || vdataOb instanceof Object[] && ((Object[])vdataOb)[0] instanceof String) {
                        this.checkDtype(9, 10, dtp);
                        avec = (Object[])vdataOb;
                        if (this.hdfFile.bugs >= 2) {
                            this.prtIndent("formatRawData String vec len: " + avec.length, new Object[0]);
                        }
                        for (ii = 0; ii < writeLen; ++ii) {
                            byte[] bytes;
                            String aval = (String)avec[linearIx + ii];
                            if (dtp == 9) {
                                bytes = HdfUtil.encodeString(aval, false, this);
                                fmtBuf.putBufBytes("formatRawData", HdfUtil.truncPadNull(bytes, stgFieldLen));
                                continue;
                            }
                            if (dtp == 10) {
                                bytes = HdfUtil.encodeString(aval, false, this);
                                int gcolIx = gcol.putHeapItem("vlen string data", bytes);
                                fmtBuf.putBufInt("vlen len", bytes.length);
                                fmtBuf.putBufLong("vlen gcol addr", gcolAddr);
                                fmtBuf.putBufInt("vlen gcol ix", gcolIx);
                                padEleLen = 16;
                                continue;
                            }
                            HdfGroup.throwerr("dtp mismatch", new Object[0]);
                        }
                    } else if (vdataOb instanceof HdfGroup[]) {
                        for (HdfGroup grp : (HdfGroup[])vdataOb) {
                            long aval = grp.blkPosition;
                            fmtBuf.putBufLong("formatRawData", aval);
                            if (dtp != 13) continue;
                            fmtBuf.putBufInt("formatRawData ref ix", cntr.getValue());
                            cntr.increment();
                        }
                    } else {
                        HdfGroup.throwerr("unknown type: " + vdataOb.getClass(), new Object[0]);
                    }
                }
                if (padLen > 0) {
                    if (dtp == 9 || dtp == 10) {
                        byte[] bytes = new byte[]{};
                        for (int ii = 0; ii < padLen; ++ii) {
                            int gcolIx = gcol.putHeapItem("vlen string data", bytes);
                            fmtBuf.putBufInt("vlen len", bytes.length);
                            fmtBuf.putBufLong("vlen gcol addr", gcolAddr);
                            fmtBuf.putBufInt("vlen gcol ix", gcolIx);
                        }
                    } else {
                        for (int ii = 0; ii < padLen * padEleLen; ++ii) {
                            fmtBuf.putBufByte("formatRawData.pad", 119);
                        }
                    }
                }
            }
        }
    }

    void checkDtype(int expecta, int actual) throws HdfException {
        if (actual != expecta) {
            HdfGroup.throwerr("data type mismatch.  Expected: %s  Actual: %s", dtypeNames[expecta], dtypeNames[actual]);
        }
    }

    void checkDtype(int expecta, int expectb, int actual) throws HdfException {
        if (actual != expecta && actual != expectb) {
            HdfGroup.throwerr("data type mismatch.  Expected: %s or %s  Actual: %s", dtypeNames[expecta], dtypeNames[expectb], dtypeNames[actual]);
        }
    }

    void formatVlenRawData(int[] heapIxs, Object vdata, HBuffer fmtBuf) throws HdfException {
        Object[] vdataVec = (Object[])vdata;
        int nrow = vdataVec.length;
        for (int irow = 0; irow < nrow; ++irow) {
            Object vrow = vdataVec[irow];
            int ncol = -1;
            if (vrow instanceof Object[]) {
                ncol = ((Object[])vrow).length;
            } else if (vrow instanceof byte[]) {
                ncol = ((byte[])vrow).length;
            } else if (vrow instanceof short[]) {
                ncol = ((short[])vrow).length;
            } else if (vrow instanceof int[]) {
                ncol = ((int[])vrow).length;
            } else if (vrow instanceof long[]) {
                ncol = ((long[])vrow).length;
            } else if (vrow instanceof float[]) {
                ncol = ((float[])vrow).length;
            } else if (vrow instanceof double[]) {
                ncol = ((double[])vrow).length;
            } else if (vrow instanceof char[]) {
                ncol = ((char[])vrow).length;
            } else {
                HdfGroup.throwerr("unknown vrow type: " + vrow.getClass(), new Object[0]);
            }
            fmtBuf.putBufInt("vlen.ncol", ncol);
            fmtBuf.putBufLong("globalHeap.pos", this.hdfFile.mainGlobalHeap.blkPosition);
            fmtBuf.putBufInt("outputGlobalHeap.ix", heapIxs[irow]);
        }
    }
}

