/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor;

import com.bc.ceres.core.Assert;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.annotations.TargetProperty;
import org.esa.snap.core.gpf.descriptor.AnnotationParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.AnnotationSourceProductDescriptor;
import org.esa.snap.core.gpf.descriptor.AnnotationSourceProductsDescriptor;
import org.esa.snap.core.gpf.descriptor.AnnotationTargetProductDescriptor;
import org.esa.snap.core.gpf.descriptor.AnnotationTargetPropertyDescriptor;
import org.esa.snap.core.gpf.descriptor.ParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.SourceProductDescriptor;
import org.esa.snap.core.gpf.descriptor.SourceProductsDescriptor;
import org.esa.snap.core.gpf.descriptor.TargetProductDescriptor;
import org.esa.snap.core.gpf.descriptor.TargetPropertyDescriptor;

public class AnnotationOperatorDescriptorBody {
    private Class<? extends Operator> operatorClass;
    private List<ParameterDescriptor> parameterDescriptors;
    private List<SourceProductDescriptor> sourceProductDescriptors;
    private TargetProductDescriptor targetProductDescriptor;
    private List<TargetPropertyDescriptor> targetPropertyDescriptors;
    private SourceProductsDescriptor sourceProductsDescriptor;

    public AnnotationOperatorDescriptorBody(Class<? extends Operator> operatorClass) {
        Assert.notNull(operatorClass, (String)"operatorClass");
        this.operatorClass = operatorClass;
        this.processAnnotations();
    }

    public Class<? extends Operator> getOperatorClass() {
        return this.operatorClass;
    }

    public SourceProductDescriptor[] getSourceProductDescriptors() {
        return this.sourceProductDescriptors != null ? this.sourceProductDescriptors.toArray(new SourceProductDescriptor[this.sourceProductDescriptors.size()]) : new SourceProductDescriptor[]{};
    }

    public SourceProductsDescriptor getSourceProductsDescriptor() {
        return this.sourceProductsDescriptor;
    }

    public TargetProductDescriptor getTargetProductDescriptor() {
        return this.targetProductDescriptor;
    }

    public TargetPropertyDescriptor[] getTargetPropertyDescriptors() {
        return this.targetPropertyDescriptors != null ? this.targetPropertyDescriptors.toArray(new TargetPropertyDescriptor[this.targetPropertyDescriptors.size()]) : new TargetPropertyDescriptor[]{};
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        return this.parameterDescriptors != null ? this.parameterDescriptors.toArray(new ParameterDescriptor[this.parameterDescriptors.size()]) : new ParameterDescriptor[]{};
    }

    private void processAnnotations() {
        this.processAnnotationsRec(this.operatorClass);
    }

    private void processAnnotationsRec(Class<?> operatorClass) {
        Field[] declaredFields;
        Class<?> superclass = operatorClass.getSuperclass();
        if (superclass != null && !superclass.equals(Operator.class)) {
            this.processAnnotationsRec(superclass);
        }
        for (Field declaredField : declaredFields = operatorClass.getDeclaredFields()) {
            String fieldName = declaredField.getName();
            Class<?> fieldType = declaredField.getType();
            Parameter parameterAnnotation = declaredField.getAnnotation(Parameter.class);
            if (parameterAnnotation != null) {
                if (this.parameterDescriptors == null) {
                    this.parameterDescriptors = new ArrayList<ParameterDescriptor>();
                }
                boolean isDeprecated = declaredField.getAnnotation(Deprecated.class) != null;
                this.parameterDescriptors.add(new AnnotationParameterDescriptor(fieldName, fieldType, isDeprecated, parameterAnnotation));
                continue;
            }
            SourceProduct sourceProductAnnotation = declaredField.getAnnotation(SourceProduct.class);
            if (sourceProductAnnotation != null && Product.class.isAssignableFrom(fieldType)) {
                if (this.sourceProductDescriptors == null) {
                    this.sourceProductDescriptors = new ArrayList<SourceProductDescriptor>();
                }
                this.sourceProductDescriptors.add(new AnnotationSourceProductDescriptor(fieldName, sourceProductAnnotation));
                continue;
            }
            SourceProducts sourceProductsAnnotation = declaredField.getAnnotation(SourceProducts.class);
            if (sourceProductsAnnotation != null && Product[].class.isAssignableFrom(fieldType)) {
                this.sourceProductsDescriptor = new AnnotationSourceProductsDescriptor(fieldName, sourceProductsAnnotation);
                continue;
            }
            TargetProduct targetProductAnnotation = declaredField.getAnnotation(TargetProduct.class);
            if (targetProductAnnotation != null) {
                this.targetProductDescriptor = new AnnotationTargetProductDescriptor(fieldName, targetProductAnnotation);
                continue;
            }
            TargetProperty targetPropertyAnnotation = declaredField.getAnnotation(TargetProperty.class);
            if (targetPropertyAnnotation == null) continue;
            if (this.targetPropertyDescriptors == null) {
                this.targetPropertyDescriptors = new ArrayList<TargetPropertyDescriptor>();
            }
            this.targetPropertyDescriptors.add(new AnnotationTargetPropertyDescriptor(fieldName, fieldType, targetPropertyAnnotation));
        }
    }
}

