/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import java.util.ArrayList;
import java.util.Collections;
import javax.media.jai.RasterAccessor;
import org.esa.snap.core.gpf.common.resample.Aggregator;
import org.esa.snap.core.gpf.common.resample.DataAccessorFactory;
import org.esa.snap.core.gpf.common.resample.LongDataAccessor;

public abstract class LongDataAggregator
implements Aggregator {
    private LongDataAccessor accessor;

    @Override
    public void init(RasterAccessor srcAccessor, RasterAccessor dstAccessor, double noDataValue) {
        this.accessor = DataAccessorFactory.createLongDataAccessor(srcAccessor, dstAccessor, noDataValue);
    }

    protected long getSrcData(int index) {
        return this.accessor.getSrcData(index);
    }

    protected void setDstData(int index, long value) {
        this.accessor.setDstData(index, value);
    }

    protected long getNoDataValue() {
        return this.accessor.getNoDataValue();
    }

    protected int getSrcOffset() {
        return this.accessor.getSrcOffset();
    }

    static class FlagMedianOr
    extends LongDataAggregator {
        FlagMedianOr() {
        }

        @Override
        public void aggregate(int srcY0, int srcY1, int srcX0, int srcX1, int srcScanlineStride, double wx0, double wx1, double wy0, double wy1, int dstPos) {
            int n = 0;
            int[] occurenceCounter = new int[63];
            int highestOccurence = 0;
            int srcIndexY = this.getSrcOffset() + srcY0 * srcScanlineStride;
            for (int srcY = srcY0; srcY <= srcY1; ++srcY) {
                for (int srcX = srcX0; srcX <= srcX1; ++srcX) {
                    long v = this.getSrcData(srcIndexY + srcX);
                    if (v == this.getNoDataValue()) continue;
                    int j = 0;
                    while (v > 0L) {
                        long compare = v & 1L;
                        if (compare != 0L) {
                            int n2 = j;
                            occurenceCounter[n2] = occurenceCounter[n2] + 1;
                        }
                        v >>= 1;
                        ++j;
                    }
                    highestOccurence = Math.max(highestOccurence, j - 1);
                    ++n;
                }
                srcIndexY += srcScanlineStride;
            }
            long res = 0L;
            float halfN = (float)n / 2.0f;
            for (int i = highestOccurence; i >= 0; --i) {
                res <<= 1;
                if (!((float)occurenceCounter[i] >= halfN)) continue;
                ++res;
            }
            this.setDstData(dstPos, res);
        }
    }

    static class FlagMedianAnd
    extends LongDataAggregator {
        FlagMedianAnd() {
        }

        @Override
        public void aggregate(int srcY0, int srcY1, int srcX0, int srcX1, int srcScanlineStride, double wx0, double wx1, double wy0, double wy1, int dstPos) {
            int n = 0;
            int[] occurenceCounter = new int[63];
            int highestOccurence = 0;
            int srcIndexY = this.getSrcOffset() + srcY0 * srcScanlineStride;
            for (int srcY = srcY0; srcY <= srcY1; ++srcY) {
                for (int srcX = srcX0; srcX <= srcX1; ++srcX) {
                    long v = this.getSrcData(srcIndexY + srcX);
                    if (v == this.getNoDataValue()) continue;
                    int j = 0;
                    while (v > 0L) {
                        long compare = v & 1L;
                        if (compare != 0L) {
                            int n2 = j;
                            occurenceCounter[n2] = occurenceCounter[n2] + 1;
                        }
                        v >>= 1;
                        ++j;
                    }
                    highestOccurence = Math.max(highestOccurence, j - 1);
                    ++n;
                }
                srcIndexY += srcScanlineStride;
            }
            long res = 0L;
            float halfN = (float)n / 2.0f;
            for (int i = highestOccurence; i >= 0; --i) {
                res <<= 1;
                if (!((float)occurenceCounter[i] > halfN)) continue;
                ++res;
            }
            this.setDstData(dstPos, res);
        }
    }

    static class FlagOr
    extends LongDataAggregator {
        FlagOr() {
        }

        @Override
        public void aggregate(int srcY0, int srcY1, int srcX0, int srcX1, int srcScanlineStride, double wx0, double wx1, double wy0, double wy1, int dstPos) {
            long res = 0L;
            int srcIndexY = this.getSrcOffset() + srcY0 * srcScanlineStride;
            for (int srcY = srcY0; srcY <= srcY1; ++srcY) {
                for (int srcX = srcX0; srcX <= srcX1; ++srcX) {
                    long v = this.getSrcData(srcIndexY + srcX);
                    if (v == this.getNoDataValue()) continue;
                    res |= v;
                }
                srcIndexY += srcScanlineStride;
            }
            this.setDstData(dstPos, res);
        }
    }

    static class FlagAnd
    extends LongDataAggregator {
        FlagAnd() {
        }

        @Override
        public void aggregate(int srcY0, int srcY1, int srcX0, int srcX1, int srcScanlineStride, double wx0, double wx1, double wy0, double wy1, int dstPos) {
            long res = Long.MAX_VALUE;
            int n = 0;
            int srcIndexY = this.getSrcOffset() + srcY0 * srcScanlineStride;
            for (int srcY = srcY0; srcY <= srcY1; ++srcY) {
                for (int srcX = srcX0; srcX <= srcX1; ++srcX) {
                    long v = this.getSrcData(srcIndexY + srcX);
                    if (v == this.getNoDataValue()) continue;
                    res &= v;
                    ++n;
                }
                srcIndexY += srcScanlineStride;
            }
            res = n > 0 ? res : 0L;
            this.setDstData(dstPos, res);
        }
    }

    static class First
    extends LongDataAggregator {
        First() {
        }

        @Override
        public void aggregate(int srcY0, int srcY1, int srcX0, int srcX1, int srcScanlineStride, double wx0, double wx1, double wy0, double wy1, int dstPos) {
            this.setDstData(dstPos, this.getSrcData(this.getSrcOffset() + srcY0 * srcScanlineStride + srcX0));
        }
    }

    static class Max
    extends LongDataAggregator {
        Max() {
        }

        @Override
        public void aggregate(int srcY0, int srcY1, int srcX0, int srcX1, int srcScanlineStride, double wx0, double wx1, double wy0, double wy1, int dstPos) {
            long maxValue = Long.MIN_VALUE;
            int n = 0;
            int srcIndexY = this.getSrcOffset() + srcY0 * srcScanlineStride;
            for (int srcY = srcY0; srcY <= srcY1; ++srcY) {
                for (int srcX = srcX0; srcX <= srcX1; ++srcX) {
                    long v = this.getSrcData(srcIndexY + srcX);
                    if (v == this.getNoDataValue() || v <= maxValue) continue;
                    maxValue = v;
                    ++n;
                }
                srcIndexY += srcScanlineStride;
            }
            if (n > 0) {
                this.setDstData(dstPos, maxValue);
            } else {
                this.setDstData(dstPos, this.getNoDataValue());
            }
        }
    }

    static class Min
    extends LongDataAggregator {
        Min() {
        }

        @Override
        public void aggregate(int srcY0, int srcY1, int srcX0, int srcX1, int srcScanlineStride, double wx0, double wx1, double wy0, double wy1, int dstPos) {
            long minValue = Long.MAX_VALUE;
            int n = 0;
            int srcIndexY = this.getSrcOffset() + srcY0 * srcScanlineStride;
            for (int srcY = srcY0; srcY <= srcY1; ++srcY) {
                for (int srcX = srcX0; srcX <= srcX1; ++srcX) {
                    long v = this.getSrcData(srcIndexY + srcX);
                    if (v == this.getNoDataValue() || v >= minValue) continue;
                    minValue = v;
                    ++n;
                }
                srcIndexY += srcScanlineStride;
            }
            if (n > 0) {
                this.setDstData(dstPos, minValue);
            } else {
                this.setDstData(dstPos, this.getNoDataValue());
            }
        }
    }

    static class Median
    extends LongDataAggregator {
        Median() {
        }

        @Override
        public void aggregate(int srcY0, int srcY1, int srcX0, int srcX1, int srcScanlineStride, double wx0, double wx1, double wy0, double wy1, int dstPos) {
            ArrayList<Long> validValues = new ArrayList<Long>();
            int srcIndexY = this.getSrcOffset() + srcY0 * srcScanlineStride;
            for (int srcY = srcY0; srcY <= srcY1; ++srcY) {
                for (int srcX = srcX0; srcX <= srcX1; ++srcX) {
                    long v = this.getSrcData(srcIndexY + srcX);
                    if (v == this.getNoDataValue()) continue;
                    validValues.add(v);
                }
                srcIndexY += srcScanlineStride;
            }
            int numValidValues = validValues.size();
            if (numValidValues == 0) {
                this.setDstData(dstPos, this.getNoDataValue());
            } else {
                Collections.sort(validValues);
                if (numValidValues % 2 == 1) {
                    this.setDstData(dstPos, (Long)validValues.get(numValidValues / 2));
                } else {
                    long median = ((Long)validValues.get(numValidValues / 2 - 1) + (Long)validValues.get(numValidValues / 2)) / 2L;
                    this.setDstData(dstPos, median);
                }
            }
        }
    }

    static class Mean
    extends LongDataAggregator {
        Mean() {
        }

        @Override
        public void aggregate(int srcY0, int srcY1, int srcX0, int srcX1, int srcScanlineStride, double wx0, double wx1, double wy0, double wy1, int dstPos) {
            long vSum = 0L;
            double wSum = 0.0;
            int srcIndexY = this.getSrcOffset() + srcY0 * srcScanlineStride;
            for (int srcY = srcY0; srcY <= srcY1; ++srcY) {
                double wy = srcY == srcY0 ? wy0 : (srcY == srcY1 ? wy1 : 1.0);
                for (int srcX = srcX0; srcX <= srcX1; ++srcX) {
                    double wx = srcX == srcX0 ? wx0 : (srcX == srcX1 ? wx1 : 1.0);
                    long v = this.getSrcData(srcIndexY + srcX);
                    if (v == this.getNoDataValue()) continue;
                    double w = wx * wy;
                    vSum = (long)((double)vSum + w * (double)v);
                    wSum += w;
                }
                srcIndexY += srcScanlineStride;
            }
            if (wSum == 0.0) {
                this.setDstData(dstPos, this.getNoDataValue());
            } else {
                this.setDstData(dstPos, (long)((double)vSum / wSum));
            }
        }
    }
}

