/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import org.esa.snap.core.gpf.common.resample.AggregationType;
import org.esa.snap.core.gpf.common.resample.Aggregator;
import org.esa.snap.core.gpf.common.resample.AggregatorFactory;
import org.esa.snap.core.gpf.internal.OperatorContext;

class AggregatedOpImage
extends GeometricOpImage {
    private static final double EPS = 1.0E-10;
    private final double scaleX;
    private final double scaleY;
    private final float offsetX;
    private final float offsetY;
    private final double noDataValue;
    private AggregationType aggregationType;
    private final int dataBufferType;

    AggregatedOpImage(RenderedImage sourceImage, ImageLayout layout, double noDataValue, AggregationType aggregationType, int dataBufferType, AffineTransform sourceImageToModelTransform, AffineTransform referenceImageToModelTransform) throws NoninvertibleTransformException {
        super(AggregatedOpImage.vectorize((RenderedImage)sourceImage), layout, null, true, AggregatedOpImage.createBorderExtender(noDataValue), null, AggregatedOpImage.createBackground(noDataValue));
        this.noDataValue = noDataValue;
        AffineTransform transform = new AffineTransform(referenceImageToModelTransform);
        transform.concatenate(sourceImageToModelTransform.createInverse());
        this.scaleX = transform.getScaleX();
        this.scaleY = transform.getScaleY();
        this.offsetX = (float)(referenceImageToModelTransform.getTranslateX() / sourceImageToModelTransform.getScaleX()) - (float)(sourceImageToModelTransform.getTranslateX() / sourceImageToModelTransform.getScaleX());
        this.offsetY = (float)(referenceImageToModelTransform.getTranslateY() / sourceImageToModelTransform.getScaleY()) - (float)(sourceImageToModelTransform.getTranslateY() / sourceImageToModelTransform.getScaleY());
        this.aggregationType = aggregationType;
        this.dataBufferType = dataBufferType;
        OperatorContext.setTileCache((OpImage)this);
    }

    private static BorderExtender createBorderExtender(double value) {
        return new BorderExtenderConstant(new double[]{value});
    }

    private static double[] createBackground(double value) {
        return new double[]{value};
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        int dstH = destRect.height;
        int dstW = destRect.width;
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        Aggregator aggregator = AggregatorFactory.createAggregator(this.aggregationType, this.dataBufferType);
        aggregator.init(srcAccessor, dstAccessor, this.noDataValue);
        for (int dstY = 0; dstY < dstH; ++dstY) {
            double srcYF0 = this.scaleY * (double)dstY;
            double srcYF1 = srcYF0 + this.scaleY;
            int srcY0 = (int)srcYF0;
            int srcY1 = (int)srcYF1;
            double wy0 = 1.0 - (srcYF0 - (double)srcY0);
            double wy1 = srcYF1 - (double)srcY1;
            if (wy1 < 1.0E-10) {
                wy1 = 1.0;
                if (srcY1 > srcY0) {
                    --srcY1;
                }
            }
            int dstYIndexOffset = dstAccessor.getBandOffset(0) + dstY * dstAccessor.getScanlineStride();
            for (int dstX = 0; dstX < dstW; ++dstX) {
                double srcXF0 = this.scaleX * (double)dstX;
                double srcXF1 = srcXF0 + this.scaleX;
                int srcX0 = (int)srcXF0;
                int srcX1 = (int)srcXF1;
                double wx0 = 1.0 - (srcXF0 - (double)srcX0);
                double wx1 = srcXF1 - (double)srcX1;
                if (wx1 < 1.0E-10) {
                    wx1 = 1.0;
                    if (srcX1 > srcX0) {
                        --srcX1;
                    }
                }
                aggregator.aggregate(srcY0, srcY1, srcX0, srcX1, srcAccessor.getScanlineStride(), wx0, wx1, wy0, wy1, dstYIndexOffset + dstX);
            }
        }
        if (dstAccessor.isDataCopy()) {
            dstAccessor.clampDataArrays();
            dstAccessor.copyDataToRaster();
        }
    }

    protected Rectangle forwardMapRect(Rectangle rectangle, int i) {
        int x = (int)(rectangle.getX() * (1.0 / this.scaleX) - (double)this.offsetX);
        int y = (int)(rectangle.getY() * (1.0 / this.scaleY) - (double)this.offsetY);
        int width = (int)Math.ceil(rectangle.getWidth() * (1.0 / this.scaleX));
        int height = (int)Math.ceil(rectangle.getHeight() * (1.0 / this.scaleY));
        return new Rectangle(x, y, width, height);
    }

    public Rectangle mapDestRect(Rectangle destRect, int sourceIndex) {
        if (destRect == null) {
            throw new IllegalArgumentException("destRect must not be null");
        }
        if (sourceIndex >= 0 && sourceIndex < this.getNumSources()) {
            return this.backwardMapRect(destRect, sourceIndex);
        }
        throw new IllegalArgumentException("Invalid source index");
    }

    protected Rectangle backwardMapRect(Rectangle rectangle, int i) {
        int x = (int)((double)this.offsetX + rectangle.getX() * this.scaleX);
        int y = (int)((double)this.offsetY + rectangle.getY() * this.scaleY);
        int width = (int)Math.ceil(rectangle.getWidth() * this.scaleX);
        int height = (int)Math.ceil(rectangle.getHeight() * this.scaleY);
        return new Rectangle(x, y, width, height);
    }
}

