/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.bigtiff.internal;

import org.esa.snap.core.util.Guardian;
import org.esa.snap.dataio.bigtiff.internal.GeoTiffAscii;
import org.esa.snap.dataio.bigtiff.internal.TiffAscii;
import org.esa.snap.dataio.bigtiff.internal.TiffDouble;
import org.esa.snap.dataio.bigtiff.internal.TiffLong;
import org.esa.snap.dataio.bigtiff.internal.TiffRational;
import org.esa.snap.dataio.bigtiff.internal.TiffShort;
import org.esa.snap.dataio.bigtiff.internal.TiffUInt;
import org.esa.snap.dataio.bigtiff.internal.TiffValue;

class TiffType {
    public static final byte BYTE_TYPE = 1;
    public static final TiffShort BYTE = new TiffShort(1);
    public static final byte ASCII_TYPE = 2;
    public static final TiffShort ASCII = new TiffShort(2);
    public static final byte SHORT_TYPE = 3;
    public static final TiffShort SHORT = new TiffShort(3);
    public static final byte LONG_TYPE = 4;
    public static final TiffShort LONG = new TiffShort(4);
    public static final byte RATIONAL_TYPE = 5;
    public static final TiffShort RATIONAL = new TiffShort(5);
    public static final byte SBYTE_TYPE = 6;
    public static final TiffShort SBYTE = new TiffShort(6);
    public static final byte UNDEFINED_TYPE = 7;
    public static final TiffShort UNDEFINED = new TiffShort(7);
    public static final byte SSHORT_TYPE = 8;
    public static final TiffShort SSHORT = new TiffShort(8);
    public static final byte SLONG_TYPE = 9;
    public static final TiffShort SLONG = new TiffShort(9);
    public static final byte SRATIONAL_TYPE = 10;
    public static final TiffShort SRATIONAL = new TiffShort(10);
    public static final byte FLOAT_TYPE = 11;
    public static final TiffShort FLOAT = new TiffShort(11);
    public static final byte DOUBLE_TYPE = 12;
    public static final TiffShort DOUBLE = new TiffShort(12);
    public static final byte LONG_8_TYPE = 16;
    public static final TiffShort LONG_8 = new TiffShort(16);
    public static final byte SLONG_8_TYPE = 17;
    public static final TiffShort SLONG_8 = new TiffShort(17);

    TiffType() {
    }

    public static TiffShort getType(TiffValue[] values) {
        Guardian.assertNotNull((String)"values", (Object)values);
        Guardian.assertGreaterThan((String)"values.length", (long)values.length, (long)0L);
        TiffValue value = values[0];
        Guardian.assertNotNull((String)"value", (Object)value);
        if (value instanceof TiffShort) {
            TiffType.ensureElementsEqualValueType(values, TiffShort.class);
            return SHORT;
        }
        if (value instanceof TiffUInt) {
            TiffType.ensureElementsEqualValueType(values, TiffUInt.class);
            return LONG;
        }
        if (value instanceof TiffRational) {
            TiffType.ensureElementsEqualValueType(values, TiffRational.class);
            return RATIONAL;
        }
        if (value instanceof GeoTiffAscii) {
            TiffType.ensureElementsEqualValueType(values, GeoTiffAscii.class);
            return ASCII;
        }
        if (value instanceof TiffAscii) {
            TiffType.ensureElementsEqualValueType(values, TiffAscii.class);
            return ASCII;
        }
        if (value instanceof TiffDouble) {
            TiffType.ensureElementsEqualValueType(values, TiffDouble.class);
            return DOUBLE;
        }
        if (value instanceof TiffLong) {
            TiffType.ensureElementsEqualValueType(values, TiffLong.class);
            return SLONG_8;
        }
        throw new IllegalArgumentException("the given type [" + values.getClass() + "] is not supported");
    }

    private static void ensureElementsEqualValueType(TiffValue[] values, Class compareClass) {
        for (TiffValue value : values) {
            if (compareClass.isInstance(value)) continue;
            throw new IllegalArgumentException("all elements of the given values array must be instances of the same type [" + compareClass.getName() + "]");
        }
    }
}

