/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.idepix.probav;

import java.awt.Color;
import java.util.Random;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.util.BitSetter;
import org.esa.snap.idepix.core.IdepixFlagCoding;

public class ProbaVUtils {
    public static FlagCoding createProbavFlagCoding(String flagId) {
        FlagCoding flagCoding = IdepixFlagCoding.createDefaultFlagCoding((String)flagId);
        flagCoding.addFlag("IDEPIX_WATER", BitSetter.setFlag((int)0, (int)12), "Water pixels");
        flagCoding.addFlag("IDEPIX_CLEAR_LAND", BitSetter.setFlag((int)0, (int)13), "Clear land pixels");
        flagCoding.addFlag("IDEPIX_CLEAR_WATER", BitSetter.setFlag((int)0, (int)14), "Clear water pixels");
        return flagCoding;
    }

    public static void setupProbavClassifBitmask(Product classifProduct) {
        int index = IdepixFlagCoding.setupDefaultClassifBitmask((Product)classifProduct);
        int w = classifProduct.getSceneRasterWidth();
        int h = classifProduct.getSceneRasterHeight();
        Random r = new Random(124567L);
        Mask mask = Mask.BandMathsType.create((String)"IDEPIX_WATER", (String)"Water pixels", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_WATER", (Color)IdepixFlagCoding.getRandomColour((Random)r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"IDEPIX_CLEAR_LAND", (String)"Clear land pixels", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_CLEAR_LAND", (Color)IdepixFlagCoding.getRandomColour((Random)r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"IDEPIX_CLEAR_WATER", (String)"Clear water pixels", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_CLEAR_WATER", (Color)IdepixFlagCoding.getRandomColour((Random)r), (double)0.5);
        classifProduct.getMaskGroup().add(index, (ProductNode)mask);
    }
}

