/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.idepix.landsat8;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glayer.tools.Tools;
import java.awt.image.RenderedImage;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.RenderedOp;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.datamodel.StxFactory;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.idepix.core.AlgorithmSelector;
import org.esa.snap.idepix.core.util.IdepixIO;
import org.esa.snap.idepix.landsat8.ClostOp;
import org.esa.snap.idepix.landsat8.Landsat8ClassificationOp;
import org.esa.snap.idepix.landsat8.Landsat8PostProcessOp;
import org.esa.snap.idepix.landsat8.Landsat8Utils;
import org.esa.snap.idepix.landsat8.NNSelector;
import org.esa.snap.idepix.landsat8.OtsuBinarizeOp;

@OperatorMetadata(alias="Idepix.L8.OLI", category="Optical/Pre-Processing", version="3.0", authors="Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Pixel identification and classification for Landsat-8 OLI instrument.")
public class Landsat8Op
extends Operator {
    @SourceProduct(alias="sourceProduct", label="Landsat 8 product", description="The Landsat 8 source product.")
    private Product sourceProduct;
    @TargetProduct(description="The target product.")
    private Product targetProduct;
    private boolean computeCloudShadow = false;
    private boolean computeCloudBuffer = true;
    @Parameter(defaultValue="2", interval="[0,100]", description="The width of a cloud 'safety buffer' around a pixel which was classified as cloudy.", label="Width of cloud buffer (# of pixels)")
    private int cloudBufferWidth;
    @Parameter(defaultValue="false", label=" Refine pixel classification near coastlines (time consuming!)", description="Refine pixel classification near coastlines (time consuming operation!). Improves distinction of clouds and bright beaches. ")
    private boolean refineClassificationNearCoastlines;
    @Parameter(defaultValue="ALL", valueSet={"ALL", "LAND", "LAND_USE_THERMAL", "WATER", "WATER_NOTIDAL", "WATER_USE_THERMAL", "WATER_NOTIDAL_USE_THERMAL"}, label="Neural Net to be applied", description="The Neural Net which will be applied.")
    private NNSelector nnSelector;
    @Parameter(defaultValue="1.95", label="NN cloud ambiguous lower boundary ")
    private double nnCloudAmbiguousLowerBoundaryValue;
    @Parameter(defaultValue="3.45", label="NN cloud ambiguous/sure separation value ")
    private double nnCloudAmbiguousSureSeparationValue;
    @Parameter(defaultValue="4.3", label="NN cloud sure / snow separation value ")
    private double nnCloudSureSnowSeparationValue;
    @Parameter(defaultValue="true", label=" Apply SHIMEZ cloud test")
    private boolean applyShimezCloudTest;
    @Parameter(defaultValue="0.1", description="Threshold A for SHIMEZ cloud test: cloud if mean > B AND diff < A.", label="Threshold A for SHIMEZ cloud test")
    private float shimezDiffThresh;
    @Parameter(defaultValue="0.25", description="Threshold B for SHIMEZ cloud test: cloud if mean > B AND diff < A.", label="Threshold B for SHIMEZ cloud test")
    private float shimezMeanThresh;
    @Parameter(defaultValue="false", label=" Apply HOT cloud test")
    private boolean applyHotCloudTest;
    @Parameter(defaultValue="0.1", description="Threshold A for HOT cloud test: cloud if blue - 0.5*red > A.", label="Threshold A for HOT cloud test")
    private float hotThresh;
    @Parameter(defaultValue="false", label=" Apply CLOST cloud test")
    private boolean applyClostCloudTest;
    @Parameter(defaultValue="0.001", description="Threshold A for CLOST cloud test: cloud if coastal_aerosol*blue*panchromatic*cirrus > A.", label="Threshold A for CLOST cloud test")
    private double clostThresh;
    @Parameter(defaultValue="false", label=" Apply OTSU cloud test")
    private boolean applyOtsuCloudTest;
    private String otsuMode = "BINARY";
    private boolean outputOtsuBands = false;
    @Parameter(defaultValue="true", description="Write source bands to the target product.", label=" Write source bands to the target product")
    private boolean outputSourceBands;
    @Parameter(defaultValue="false", label=" Write NN value to the target product.", description=" If applied, write NN value to the target product ")
    private boolean outputNNValue;
    private static final int LAND_WATER_MASK_RESOLUTION = 50;
    private static final int OVERSAMPLING_FACTOR_X = 3;
    private static final int OVERSAMPLING_FACTOR_Y = 3;
    private Product classificationProduct;
    private Product postProcessingProduct;
    private Product waterMaskProduct;
    private Map<String, Product> classificationInputProducts;
    private Map<String, Object> classificationParameters;
    private Product otsuProduct;
    private Product clostProduct;
    private final String brightnessBandLandString = "480";
    private final float brightnessThreshLand = 0.5f;
    private final String brightnessBand1WaterString = "655";
    private final float brightnessWeightBand1Water = 1.0f;
    private final String brightnessBand2WaterString = "865";
    private final float brightnessWeightBand2Water = 1.0f;
    private final float brightnessThreshWater = 0.5f;
    private final String whitenessBand1LandString = "655";
    private final String whitenessBand2LandString = "865";
    private final float whitenessThreshLand = 2.0f;
    private final String whitenessBand1WaterString = "655";
    private final String whitenessBand2WaterString = "865";
    private final float whitenessThreshWater = 2.0f;
    private final double darkGlintThreshTest1 = 0.15;
    private final String darkGlintThreshTest1WavelengthString = "865";
    private final double darkGlintThreshTest2 = 0.15;
    private String darkGlintThreshTest2WavelengthString = "1610";
    private int standardBandWidth;
    private int standardBandHeight;

    public void initialize() throws OperatorException {
        boolean inputProductIsValid = IdepixIO.validateInputProduct((Product)this.sourceProduct, (AlgorithmSelector)AlgorithmSelector.LANDSAT8);
        if (!inputProductIsValid) {
            throw new OperatorException("Selected cloud screening algorithm cannot be used with given input product. \n\nSupported sensors are: MERIS, SPOT VGT, MODIS, Landsat-8, SeaWiFS, Sentinel-2 MSI, Sentinel-3 OLCI, PROBA-V, VIIRS.");
        }
        this.standardBandWidth = this.sourceProduct.getBand("blue").getSourceImage().getWidth();
        this.standardBandHeight = this.sourceProduct.getBand("blue").getSourceImage().getHeight();
        this.checkIfLandsatIsReadAsReflectance();
        if (this.applyClostCloudTest || this.applyOtsuCloudTest) {
            this.rescalePanchromaticBand();
            HashMap<String, Product> clostInput = new HashMap<String, Product>();
            clostInput.put("l8source", this.sourceProduct);
            this.clostProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(ClostOp.class), (Map)GPF.NO_PARAMS, clostInput);
            Band clostBand = this.clostProduct.getBand("CLOST");
            this.clostThresh = this.computeClostHistogram3PercentOfMaximum(clostBand);
        }
        if (this.applyOtsuCloudTest) {
            HashMap<String, Product> otsuInput = new HashMap<String, Product>();
            otsuInput.put("l8source", this.sourceProduct);
            otsuInput.put("clost", this.clostProduct);
            HashMap<String, String> otsuParameters = new HashMap<String, String>();
            otsuParameters.put("otsuMode", this.otsuMode);
            this.otsuProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(OtsuBinarizeOp.class), otsuParameters, otsuInput);
        }
        this.preProcess();
        this.computeCloudProduct();
        this.postProcess();
        this.targetProduct = IdepixIO.cloneProduct((Product)this.classificationProduct, (int)this.standardBandWidth, (int)this.standardBandHeight, (boolean)false);
        Band cloudFlagBand = this.targetProduct.getBand("pixel_classif_flags");
        cloudFlagBand.setSourceImage(this.postProcessingProduct.getBand("pixel_classif_flags").getSourceImage());
        this.copyOutputBands();
    }

    private void rescalePanchromaticBand() {
        Band panBand = this.sourceProduct.getBand("panchromatic");
        int panBandImageWidth = panBand.getSourceImage().getWidth();
        int panBandImageHeight = panBand.getSourceImage().getHeight();
        if (this.standardBandWidth != panBandImageWidth || this.standardBandHeight != panBandImageHeight) {
            float scaleFactorW = (float)((double)this.standardBandWidth * 1.0 / (double)panBandImageWidth);
            RenderedOp scaledPanImage = Tools.scaleImage((RenderedImage)panBand.getSourceImage(), (float)scaleFactorW);
            if (scaledPanImage.getWidth() == this.standardBandWidth && scaledPanImage.getHeight() == this.standardBandHeight) {
                panBand.setSourceImage((RenderedImage)scaledPanImage);
            } else {
                System.out.println("WARNING: cannot rescale panchromatic band properly - will skip CLOST and OTSU cloud tests.");
                this.applyClostCloudTest = false;
                this.applyOtsuCloudTest = false;
            }
        }
    }

    private void checkIfLandsatIsReadAsReflectance() {
        if (!this.sourceProduct.getBandAt(0).getDescription().toLowerCase().contains("reflectance")) {
            throw new OperatorException("The landsat source product must provide reflectances. For configuration instructions see IdePix help documentation, Processor description for Landsat-8.");
        }
    }

    private void preProcess() {
        HashMap<String, Integer> waterMaskParameters = new HashMap<String, Integer>();
        waterMaskParameters.put("resolution", 50);
        waterMaskParameters.put("subSamplingFactorX", 3);
        waterMaskParameters.put("subSamplingFactorY", 3);
        Product resizedProduct = new Product("dummy", "dummy", this.standardBandWidth, this.standardBandHeight);
        Band blueBand = this.sourceProduct.getBand("blue");
        IdepixIO.copyGeocodingFromBandToProduct((Band)blueBand, (Product)resizedProduct);
        this.waterMaskProduct = GPF.createProduct((String)"LandWaterMask", waterMaskParameters, (Product)resizedProduct);
    }

    private void setClassificationParameters() {
        this.classificationParameters = new HashMap<String, Object>();
        this.classificationParameters.put("brightnessThreshLand", Float.valueOf(0.5f));
        this.classificationParameters.put("brightnessBandLand", Landsat8Utils.getWavelengthFromString("480"));
        this.classificationParameters.put("brightnessThreshWater", Float.valueOf(0.5f));
        this.classificationParameters.put("brightnessBand1Water", Landsat8Utils.getWavelengthFromString("655"));
        this.classificationParameters.put("brightnessBand2Water", Landsat8Utils.getWavelengthFromString("865"));
        this.classificationParameters.put("brightnessWeightBand1Water", Float.valueOf(1.0f));
        this.classificationParameters.put("brightnessWeightBand2Water", Float.valueOf(1.0f));
        this.classificationParameters.put("whitenessThreshLand", Float.valueOf(2.0f));
        this.classificationParameters.put("whitenessBand1Land", Landsat8Utils.getWavelengthFromString("655"));
        this.classificationParameters.put("whitenessBand2Land", Landsat8Utils.getWavelengthFromString("865"));
        this.classificationParameters.put("whitenessThreshWater", Float.valueOf(2.0f));
        this.classificationParameters.put("whitenessBand1Water", Landsat8Utils.getWavelengthFromString("655"));
        this.classificationParameters.put("whitenessBand2Water", Landsat8Utils.getWavelengthFromString("865"));
        this.classificationParameters.put("applyShimezCloudTest", this.applyShimezCloudTest);
        this.classificationParameters.put("shimezDiffThresh", Float.valueOf(this.shimezDiffThresh));
        this.classificationParameters.put("shimezMeanThresh", Float.valueOf(this.shimezMeanThresh));
        this.classificationParameters.put("applyHotCloudTest", this.applyHotCloudTest);
        this.classificationParameters.put("hotThresh", Float.valueOf(this.hotThresh));
        this.classificationParameters.put("applyClostCloudTest", this.applyClostCloudTest);
        this.classificationParameters.put("clostThresh", this.clostThresh);
        this.classificationParameters.put("applyOtsuCloudTest", this.applyOtsuCloudTest);
        this.classificationParameters.put("nnSelector", (Object)this.nnSelector);
        this.classificationParameters.put("nnCloudAmbiguousLowerBoundaryValue", this.nnCloudAmbiguousLowerBoundaryValue);
        this.classificationParameters.put("nnCloudAmbiguousLowerBoundaryValue", this.nnCloudAmbiguousLowerBoundaryValue);
        this.classificationParameters.put("nnCloudSureSnowSeparationValue", this.nnCloudSureSnowSeparationValue);
        this.classificationParameters.put("darkGlintThreshTest1", 0.15);
        this.classificationParameters.put("darkGlintThreshTest1Wavelength", Landsat8Utils.getWavelengthFromString("865"));
        this.classificationParameters.put("darkGlintThreshTest2", 0.15);
        this.classificationParameters.put("darkGlintThreshTest2Wavelength", Landsat8Utils.getWavelengthFromString(this.darkGlintThreshTest2WavelengthString));
    }

    private void computeCloudProduct() {
        this.setClassificationParameters();
        this.classificationInputProducts = new HashMap<String, Product>();
        this.classificationInputProducts.put("l8source", this.sourceProduct);
        this.classificationInputProducts.put("otsu", this.otsuProduct);
        this.classificationInputProducts.put("waterMask", this.waterMaskProduct);
        this.classificationProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(Landsat8ClassificationOp.class), this.classificationParameters, this.classificationInputProducts);
    }

    private void postProcess() {
        HashMap<String, Product> input = new HashMap<String, Product>();
        input.put("landsatCloud", this.classificationProduct);
        input.put("waterMask", this.waterMaskProduct);
        HashMap<String, Constable> params = new HashMap<String, Constable>();
        params.put("cloudBufferWidth", Integer.valueOf(this.cloudBufferWidth));
        params.put("computeCloudBuffer", Boolean.valueOf(this.computeCloudBuffer));
        params.put("computeCloudShadow", Boolean.valueOf(false));
        params.put("refineClassificationNearCoastlines", Boolean.valueOf(this.refineClassificationNearCoastlines));
        this.postProcessingProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(Landsat8PostProcessOp.class), params, input);
    }

    private void copyOutputBands() {
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
        Landsat8Utils.setupLandsat8ClassifBitmask(this.targetProduct);
        if (this.outputSourceBands) {
            ProductUtils.copyFlagCodings((Product)this.sourceProduct, (Product)this.targetProduct);
            for (Band sourceBand : this.sourceProduct.getBands()) {
                if (sourceBand.getName().equals("panchromatic")) continue;
                ProductUtils.copyBand((String)sourceBand.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
            }
        }
        if (this.outputOtsuBands) {
            for (Band otsuBands : this.otsuProduct.getBands()) {
                ProductUtils.copyBand((String)otsuBands.getName(), (Product)this.otsuProduct, (Product)this.targetProduct, (boolean)true);
            }
        }
        if (this.outputNNValue) {
            IdepixIO.copySourceBands((Product)this.classificationProduct, (Product)this.targetProduct, (String)"nn_value");
        }
    }

    private double computeClostHistogram3PercentOfMaximum(Band band) {
        Stx stx = new StxFactory().create((RasterDataNode)band, ProgressMonitor.NULL);
        return Landsat8Utils.getHistogramBinAtNPercentOfMaximum(stx, 3.0);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(Landsat8Op.class);
        }
    }
}

