/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.idepix.landsat8;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.idepix.core.util.IdepixIO;
import org.esa.snap.idepix.core.util.SchillerNeuralNetWrapper;
import org.esa.snap.idepix.landsat8.Landsat8Algorithm;
import org.esa.snap.idepix.landsat8.Landsat8Constants;
import org.esa.snap.idepix.landsat8.Landsat8Utils;
import org.esa.snap.idepix.landsat8.NNSelector;

@OperatorMetadata(alias="Idepix.L8.Classification", version="3.0", internal=true, authors="Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Landsat 8 pixel classification operator.")
public class Landsat8ClassificationOp
extends Operator {
    private static final float WATER_MASK_SOUTH_BOUND = -58.0f;
    @Parameter(defaultValue="865", valueSet={"440", "480", "560", "655", "865", "1610", "2200", "590", "1370", "10895", "12005"}, description="Wavelength for brightness computation br = R(wvl) over land.", label="Wavelength for brightness computation over land")
    private int brightnessBandLand;
    @Parameter(defaultValue="100.0", description="Threshold T for brightness classification over land: bright if br > T.", label="Threshold for brightness classification over land")
    private float brightnessThreshLand;
    @Parameter(defaultValue="655", valueSet={"440", "480", "560", "655", "865", "1610", "2200", "590", "1370", "10895", "12005"}, description="Wavelength 1 for brightness computation over water.", label="Wavelength 1 for brightness computation over water")
    private int brightnessBand1Water;
    @Parameter(defaultValue="1.0", description="Weight A for wavelength 1 for brightness computation (br = A*R(wvl_1) + B*R(wvl_2)) over water.", label="Weight A for wavelength 1 for brightness computation over water")
    private float brightnessWeightBand1Water;
    @Parameter(defaultValue="865", valueSet={"440", "480", "560", "655", "865", "1610", "2200", "590", "1370", "10895", "12005"}, description="Wavelength 2 for brightness computation over water.", label="Wavelength 1 for brightness computation over water")
    private int brightnessBand2Water;
    @Parameter(defaultValue="1.0", description="Weight B for wavelength 2 for brightness computation (br = A*R(wvl_1) + B*R(wvl_2)) over water.", label="Weight B for wavelength 2 for brightness computation over water")
    private float brightnessWeightBand2Water;
    @Parameter(defaultValue="100.0", description="Threshold T for brightness classification over water: bright if br > T.", label="Threshold for brightness classification over water")
    private float brightnessThreshWater;
    @Parameter(defaultValue="655", valueSet={"440", "480", "560", "655", "865", "1610", "2200", "590", "1370", "10895", "12005"}, description="Wavelength 1 for whiteness computation (wh = R(wvl_1) / R(wvl_2)) over land.", label="Wavelength 1 for whiteness computation over land")
    private int whitenessBand1Land;
    @Parameter(defaultValue="865", valueSet={"440", "480", "560", "655", "865", "1610", "2200", "590", "1370", "10895", "12005"}, description="Wavelength 2 for whiteness computation (wh = R(wvl_1) / R(wvl_2)) over land.", label="Wavelength 2 for whiteness computation over land")
    private int whitenessBand2Land;
    @Parameter(defaultValue="2.0", description="Threshold T for whiteness classification over land: white if wh < T.", label="Threshold for whiteness classification over land")
    private float whitenessThreshLand;
    @Parameter(defaultValue="655", valueSet={"440", "480", "560", "655", "865", "1610", "2200", "590", "1370", "10895", "12005"}, description="Wavelength 1 for whiteness computation (wh = R(wvl_1) / R(wvl_2)) over water.", label="Wavelength 1 for whiteness computation over water")
    private int whitenessBand1Water;
    @Parameter(defaultValue="865", valueSet={"440", "480", "560", "655", "865", "1610", "2200", "590", "1370", "10895", "12005"}, description="Wavelength 2 for whiteness computation (wh = R(wvl_1) / R(wvl_2)) over water.", label="Wavelength 2 for whiteness computation over water")
    private int whitenessBand2Water;
    @Parameter(defaultValue="2.0", description="Threshold T for whiteness classification over water: white if wh < T.", label="Threshold for whiteness classification over water")
    private float whitenessThreshWater;
    @Parameter(defaultValue="0.15", label="Dark Glint Test 1", description="'Dark glint' threshold: Cloud possible only if refl > THRESH.")
    private double darkGlintThreshTest1;
    @Parameter(defaultValue="865", valueSet={"440", "480", "560", "655", "865", "1610", "2200", "590", "1370", "10895", "12005"}, description="Wavelength 2 for whiteness computation (wh = R(wvl_1) / R(wvl_2)) over water.", label="Wavelength used for Dark Glint Test 1")
    private int darkGlintThreshTest1Wavelength;
    @Parameter(defaultValue="0.15", label="Dark Glint Test 2", description="'Dark glint' threshold: Cloud possible only if refl > THRESH.")
    private double darkGlintThreshTest2;
    @Parameter(defaultValue="1610", valueSet={"440", "480", "560", "655", "865", "1610", "2200", "590", "1370", "10895", "12005"}, description="Wavelength 2 for whiteness computation (wh = R(wvl_1) / R(wvl_2)) over water.", label="Wavelength used for Dark Glint Test 2")
    private int darkGlintThreshTest2Wavelength;
    @Parameter(defaultValue="true", label=" Apply SHIMEZ cloud test")
    private boolean applyShimezCloudTest;
    @Parameter(defaultValue="0.1", description="Threshold A for SHIMEZ cloud test: cloud if mean > B AND diff < A.", label="Threshold A for SHIMEZ cloud test")
    private float shimezDiffThresh;
    @Parameter(defaultValue="0.35", description="Threshold B for SHIMEZ cloud test: cloud if mean > B AND diff < A.", label="Threshold B for SHIMEZ cloud test")
    private float shimezMeanThresh;
    @Parameter(defaultValue="false", label=" Apply HOT cloud test")
    private boolean applyHotCloudTest;
    @Parameter(defaultValue="0.1", description="Threshold A for HOT cloud test: cloud if blue - 0.5*red > A.", label="Threshold A for HOT cloud test")
    private float hotThresh;
    @Parameter(defaultValue="false", label=" Apply CLOST cloud test")
    private boolean applyClostCloudTest;
    @Parameter(defaultValue="0.00001", description="Threshold A for CLOST cloud test: cloud if coastal_aerosol*blue*panchromatic*cirrus > A.", label="Threshold A for CLOST cloud test")
    private double clostThresh;
    @Parameter(defaultValue="false", label=" Apply OTSU cloud test")
    private boolean applyOtsuCloudTest;
    @Parameter(defaultValue="ALL", valueSet={"ALL", "LAND", "LAND_USE_THERMAL", "WATER", "WATER_NOTIDAL", "WATER_USE_THERMAL", "WATER_NOTIDAL_USE_THERMAL"}, label="Neural Net to be applied", description="The Neural Net which will be applied.")
    private NNSelector nnSelector;
    @Parameter(defaultValue="1.95", label="NN cloud ambiguous lower boundary ")
    private double nnCloudAmbiguousLowerBoundaryValue;
    @Parameter(defaultValue="3.45", label="NN cloud ambiguous/sure separation value ")
    private double nnCloudAmbiguousSureSeparationValue;
    @Parameter(defaultValue="4.3", label="NN cloud sure / snow separation value ")
    private double nnCloudSureSnowSeparationValue;
    @SourceProduct(alias="l8source", description="The source product.")
    private Product sourceProduct;
    @SourceProduct(alias="otsu", optional=true, description="The OTSU product.")
    private Product otsuProduct;
    @SourceProduct(alias="waterMask", optional=true)
    private Product waterMaskProduct;
    @TargetProduct(description="The target product.")
    private Product targetProduct;
    private Band[] l8ReflectanceBands;
    private Band landWaterBand;
    private Band clostBand;
    private Band otsuBand;
    static final int L8_F_DESIGNATED_FILL = 0;
    static final int L8_F_WATER_CONFIDENCE_HIGH = 5;
    private String cloudFlagBandName;
    private ThreadLocal<SchillerNeuralNetWrapper> landsat8CloudNet;

    public void initialize() throws OperatorException {
        this.initCloudNet();
        this.setBands();
        this.createTargetProduct();
        if (this.waterMaskProduct != null) {
            this.landWaterBand = this.waterMaskProduct.getBand("land_water_fraction");
        }
        if (this.otsuProduct != null) {
            this.clostBand = this.otsuProduct.getBand("CLOST");
            this.otsuBand = this.otsuProduct.getBand("OTSU_BINARY");
        }
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle rectangle, ProgressMonitor pm) throws OperatorException {
        Tile landWaterTile = null;
        if (this.waterMaskProduct != null) {
            landWaterTile = this.getSourceTile((RasterDataNode)this.landWaterBand, rectangle);
        }
        Tile clostTile = null;
        Tile otsuTile = null;
        if (this.otsuProduct != null) {
            clostTile = this.getSourceTile((RasterDataNode)this.clostBand, rectangle);
            otsuTile = this.getSourceTile((RasterDataNode)this.otsuBand, rectangle);
        }
        Band l8FlagBand = this.sourceProduct.getBand("flags");
        Tile l8FlagTile = this.getSourceTile((RasterDataNode)l8FlagBand, rectangle);
        Tile[] l8ReflectanceTiles = new Tile[Landsat8Constants.LANDSAT8_NUM_SPECTRAL_BANDS];
        for (int i = 0; i < Landsat8Constants.LANDSAT8_NUM_SPECTRAL_BANDS; ++i) {
            l8ReflectanceTiles[i] = this.getSourceTile((RasterDataNode)this.l8ReflectanceBands[i], rectangle);
        }
        Tile cloudFlagTargetTile = targetTiles.get(this.targetProduct.getBand(this.cloudFlagBandName));
        Tile nnResultTargetTile = targetTiles.get(this.targetProduct.getBand("nn_value"));
        try {
            for (int y = rectangle.y; y < rectangle.y + rectangle.height; ++y) {
                this.checkForCancellation();
                for (int x = rectangle.x; x < rectangle.x + rectangle.width; ++x) {
                    Landsat8Algorithm landsat8Algorithm = this.createLandsat8Algorithm(l8ReflectanceTiles, l8FlagTile, landWaterTile, clostTile, otsuTile, x, y);
                    this.setCloudFlag(cloudFlagTargetTile, x, y, landsat8Algorithm);
                    nnResultTargetTile.setSample(x, y, landsat8Algorithm.getNnResult()[0]);
                }
            }
        }
        catch (Exception e) {
            throw new OperatorException("Failed to provide Landsat8 cloud screening:\n" + e.getMessage(), (Throwable)e);
        }
    }

    private void setBands() {
        this.l8ReflectanceBands = new Band[Landsat8Constants.LANDSAT8_NUM_SPECTRAL_BANDS];
        for (int i = 0; i < Landsat8Constants.LANDSAT8_NUM_SPECTRAL_BANDS; ++i) {
            this.l8ReflectanceBands[i] = this.sourceProduct.getBand(Landsat8Constants.LANDSAT8_SPECTRAL_BAND_NAMES[i]);
        }
    }

    private void createTargetProduct() throws OperatorException {
        Band blueBand = this.sourceProduct.getBand("blue");
        int sceneWidth = blueBand.getRasterWidth();
        int sceneHeight = blueBand.getRasterHeight();
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), sceneWidth, sceneHeight);
        this.cloudFlagBandName = "pixel_classif_flags";
        Band cloudFlagBand = this.targetProduct.addBand(this.cloudFlagBandName, 12);
        FlagCoding flagCoding = Landsat8Utils.createLandsat8FlagCoding(this.cloudFlagBandName);
        cloudFlagBand.setSampleCoding((SampleCoding)flagCoding);
        this.targetProduct.getFlagCodingGroup().add((ProductNode)flagCoding);
        this.targetProduct.addBand("nn_value", 30);
        IdepixIO.copyGeocodingFromBandToProduct((Band)blueBand, (Product)this.targetProduct);
        this.targetProduct.setStartTime(this.sourceProduct.getStartTime());
        this.targetProduct.setEndTime(this.sourceProduct.getEndTime());
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
    }

    private boolean isLandPixelSrtmBeam(int x, int y, Tile l8FlagTile, int waterFraction) {
        if (this.getGeoPos((int)x, (int)y).lat > -58.0) {
            if (waterFraction <= 100) {
                return waterFraction == 0;
            }
            return !l8FlagTile.getSampleBit(x, y, 5);
        }
        return !l8FlagTile.getSampleBit(x, y, 5);
    }

    private GeoPos getGeoPos(int x, int y) {
        GeoPos geoPos = new GeoPos();
        GeoCoding geoCoding = this.getSourceProduct().getSceneGeoCoding();
        PixelPos pixelPos = new PixelPos((double)x, (double)y);
        geoCoding.getGeoPos(pixelPos, geoPos);
        return geoPos;
    }

    private void setCloudFlag(Tile targetTile, int x, int y, Landsat8Algorithm l8Algorithm) {
        targetTile.setSample(x, y, 0, l8Algorithm.isInvalid());
        targetTile.setSample(x, y, 1, l8Algorithm.isCloud());
        targetTile.setSample(x, y, 3, l8Algorithm.isCloud());
        targetTile.setSample(x, y, 2, l8Algorithm.isCloudAmbiguous());
        targetTile.setSample(x, y, 6, l8Algorithm.isSnowIce());
        targetTile.setSample(x, y, 7, l8Algorithm.isBright());
        targetTile.setSample(x, y, 8, l8Algorithm.isWhite());
        targetTile.setSample(x, y, 5, false);
        targetTile.setSample(x, y, 9, false);
        targetTile.setSample(x, y, 10, l8Algorithm.isLand());
        targetTile.setSample(x, y, 12, this.applyShimezCloudTest && l8Algorithm.isCloudShimez());
        targetTile.setSample(x, y, 13, false);
        targetTile.setSample(x, y, 14, this.applyHotCloudTest && l8Algorithm.isCloudHot());
        targetTile.setSample(x, y, 15, false);
        targetTile.setSample(x, y, 16, this.applyOtsuCloudTest && l8Algorithm.isCloudOtsu());
        targetTile.setSample(x, y, 17, false);
        targetTile.setSample(x, y, 18, this.applyClostCloudTest && l8Algorithm.isCloudClost());
        targetTile.setSample(x, y, 19, false);
    }

    private Landsat8Algorithm createLandsat8Algorithm(Tile[] l8ReflectanceTiles, Tile l8FlagTile, Tile landWaterTile, Tile clostTile, Tile otsuTile, int x, int y) {
        Landsat8Algorithm l8Algorithm = new Landsat8Algorithm();
        boolean isLand = false;
        if (this.waterMaskProduct != null) {
            int waterFraction = landWaterTile.getSampleInt(x, y);
            isLand = this.isLandPixelSrtmBeam(x, y, l8FlagTile, waterFraction);
        }
        float[] l8Reflectance = new float[Landsat8Constants.LANDSAT8_NUM_SPECTRAL_BANDS];
        for (int i = 0; i < Landsat8Constants.LANDSAT8_NUM_SPECTRAL_BANDS; ++i) {
            l8Reflectance[i] = l8ReflectanceTiles[i].getSampleFloat(x, y);
        }
        l8Algorithm.setInvalid(l8FlagTile.getSampleBit(x, y, 0));
        l8Algorithm.setL8SpectralBandData(l8Reflectance);
        l8Algorithm.setIsLand(isLand);
        l8Algorithm.setNnCloudAmbiguousLowerBoundaryValue(this.nnCloudAmbiguousLowerBoundaryValue);
        l8Algorithm.setNnCloudAmbiguousSureSeparationValue(this.nnCloudAmbiguousSureSeparationValue);
        l8Algorithm.setNnCloudSureSnowSeparationValue(this.nnCloudSureSnowSeparationValue);
        l8Algorithm.setApplyShimezCloudTest(this.applyShimezCloudTest);
        l8Algorithm.setShimezDiffThresh(this.shimezDiffThresh);
        l8Algorithm.setShimezMeanThresh(this.shimezMeanThresh);
        l8Algorithm.setHotThresh(this.hotThresh);
        l8Algorithm.setApplyHotCloudTest(this.applyHotCloudTest);
        l8Algorithm.setClostThresh(this.clostThresh);
        l8Algorithm.setApplyClostCloudTest(this.applyClostCloudTest);
        l8Algorithm.setApplyOtsuCloudTest(this.applyOtsuCloudTest);
        if (this.otsuProduct != null) {
            l8Algorithm.setClostValue(clostTile.getSampleFloat(x, y));
            l8Algorithm.setOtsuValue(otsuTile.getSampleFloat(x, y));
        }
        l8Algorithm.setBrightnessBandLand(this.brightnessBandLand);
        l8Algorithm.setBrightnessThreshLand(this.brightnessThreshLand);
        l8Algorithm.setBrightnessBand1Water(this.brightnessBand1Water);
        l8Algorithm.setBrightnessWeightBand1Water(this.brightnessWeightBand1Water);
        l8Algorithm.setBrightnessBand2Water(this.brightnessBand2Water);
        l8Algorithm.setBrightnessWeightBand2Water(this.brightnessWeightBand2Water);
        l8Algorithm.setBrightnessThreshWater(this.brightnessThreshWater);
        l8Algorithm.setWhitenessBand1Land(this.whitenessBand1Land);
        l8Algorithm.setWhitenessBand2Land(this.whitenessBand2Land);
        l8Algorithm.setWhitenessThreshLand(this.whitenessThreshLand);
        l8Algorithm.setWhitenessBand1Water(this.whitenessBand1Water);
        l8Algorithm.setWhitenessBand2Water(this.whitenessBand2Water);
        l8Algorithm.setWhitenessThreshWater(this.whitenessThreshWater);
        l8Algorithm.setDarkGlintThresholdTest1(this.darkGlintThreshTest1);
        l8Algorithm.setDarkGlintThresholdTest1Wvl(this.darkGlintThreshTest1Wavelength);
        l8Algorithm.setDarkGlintThresholdTest2(this.darkGlintThreshTest2);
        l8Algorithm.setDarkGlintThresholdTest2Wvl(this.darkGlintThreshTest2Wavelength);
        double[] netResult = this.calcNeuralNetResult(l8Reflectance);
        l8Algorithm.setNnResult(netResult);
        return l8Algorithm;
    }

    private double[] calcNeuralNetResult(float[] l8Reflectance) {
        SchillerNeuralNetWrapper neuralNetWrapper = this.landsat8CloudNet.get();
        double[] cloudNetInput = neuralNetWrapper.getInputVector();
        for (int i = 0; i < 7; ++i) {
            cloudNetInput[i] = Math.sqrt(l8Reflectance[i]);
        }
        cloudNetInput[7] = Math.max(Math.sqrt(l8Reflectance[8]), neuralNetWrapper.getNeuralNet().getInmin()[7]);
        if (this.nnSelector.getLabel().endsWith("_USE_THERMAL")) {
            cloudNetInput[8] = Math.sqrt(l8Reflectance[9]);
            cloudNetInput[9] = Math.sqrt(l8Reflectance[10]);
        }
        return neuralNetWrapper.getNeuralNet().calc(cloudNetInput);
    }

    private void initCloudNet() {
        try (InputStream cloudNet = ((Object)((Object)this)).getClass().getResourceAsStream(this.nnSelector.getNnFileName());){
            this.landsat8CloudNet = SchillerNeuralNetWrapper.create((InputStream)cloudNet);
        }
        catch (IOException e) {
            throw new OperatorException("Cannot read cloud neural net: " + e.getMessage());
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(Landsat8ClassificationOp.class);
        }
    }
}

