/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.idepix.landsat8;

import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.image.RenderedImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.MultiplyDescriptor;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProduct;

@OperatorMetadata(alias="Idepix.L8.Clost", version="3.0", internal=true, authors="Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Landsat 8 CLOST: provides product from blue, aerosol, pan and cirrus images.")
public class ClostOp
extends Operator {
    public static final String CLOST_BAND_NAME = "CLOST";
    @SourceProduct(alias="l8source", description="The source product.")
    Product sourceProduct;

    public void initialize() throws OperatorException {
        Band blueBand = this.sourceProduct.getBand("blue");
        Band cirrusBand = this.sourceProduct.getBand("cirrus");
        Band aerosolBand = this.sourceProduct.getBand("coastal_aerosol");
        Band panBand = this.sourceProduct.getBand("panchromatic");
        MultiLevelImage blueImage = blueBand.getGeophysicalImage();
        MultiLevelImage aerosolImage = aerosolBand.getGeophysicalImage();
        RenderedOp blueAerosolImage = MultiplyDescriptor.create((RenderedImage)blueImage, (RenderedImage)aerosolImage, null);
        MultiLevelImage panImage = panBand.getGeophysicalImage();
        RenderedOp blueAerosolPanImage = MultiplyDescriptor.create((RenderedImage)blueAerosolImage, (RenderedImage)panImage, null);
        MultiLevelImage cirrusImage = cirrusBand.getGeophysicalImage();
        RenderedOp blueAerosolPanCirrusImage = MultiplyDescriptor.create((RenderedImage)blueAerosolPanImage, (RenderedImage)cirrusImage, null);
        Product clostProduct = this.createClostProduct(blueAerosolPanCirrusImage);
        this.setTargetProduct(clostProduct);
    }

    private Product createClostProduct(RenderedOp blueAerosolPanCirrusImage) {
        Product product = new Product(this.sourceProduct.getName() + "_clost", this.sourceProduct.getProductType() + " (clost)", blueAerosolPanCirrusImage.getWidth(), blueAerosolPanCirrusImage.getHeight());
        product.setSceneGeoCoding(this.sourceProduct.getSceneGeoCoding());
        product.setDescription("Product holding Clost Image");
        Band band = product.addBand(CLOST_BAND_NAME, 30);
        band.setSourceImage((RenderedImage)blueAerosolPanCirrusImage);
        band.setUnit("dl");
        band.setDescription("CLOST Image: aerosol * blue * pan * cirrus ");
        return product;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ClostOp.class);
        }
    }
}

