/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.standalone;

import com.bc.ceres.standalone.CliHandler;
import java.util.HashMap;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CliHandlerTest {
    private CliHandler cliHandler;
    private String[] command;

    @Before
    public void setUp() throws Exception {
        this.command = new String[]{"-v", "template1=/my/template/dir/veltemp.vm.txt", "-v", "template2=/my/template/dir/veltemp.vm.xml", "-t", "/my/out/product.n1", "-S", "source1=foo/baa/prod.N1", "-S", "source2=foo/bah/MER.N1", "-S", "source3=foo/bar/ATS.N1", "-m", "meta1=/root/dir/global-metadata.txt", "-m", "meta2=/root/dir/lut.properties", "var1", "var2", "var3 var3a"};
        this.cliHandler = new CliHandler(this.command);
    }

    @Test
    public void testCreateOptions() throws Exception {
        Options options = this.cliHandler.createOptions();
        Option option = options.getOption("-v");
        Assert.assertNotNull((Object)option);
        Assert.assertTrue((boolean)option.isRequired());
        Assert.assertNull((Object)option.getValue());
        Assert.assertEquals((Object)"template>=<filePath", (Object)option.getArgName());
        Assert.assertEquals((Object)"The absolute path of the velocity templates (*.vm). Could be several given by key-value-pairs.", (Object)option.getDescription());
        option = options.getOption("-t");
        Assert.assertNotNull((Object)option);
        Assert.assertTrue((boolean)option.isRequired());
        Assert.assertNull((Object)option.getValue());
        Assert.assertEquals((Object)"filePath", (Object)option.getArgName());
        String desc = "The absolute item path (e.g. a product), the metadata file will be placed next to the item. It gets the name 'itemName-templateName.templateSuffix'. Refer to as $targetPath in velocity templates. If the targetPath is a directory, the metadata file will get the name of the velocity template without the suffix *.vm";
        Assert.assertEquals((Object)desc, (Object)option.getDescription());
        option = options.getOption("-S");
        Assert.assertNotNull((Object)option);
        Assert.assertFalse((String)"source item paths are optional", (boolean)option.isRequired());
        Assert.assertNull((Object)option.getValue());
        Assert.assertEquals((Object)"source>=<filePath", (Object)option.getArgName());
        desc = "Optional. The absolute path and name of the source items. Could be several given by key-value-pairs. In the velocity templates the key will give you the content of the associated metadata file(s). The reference $sourcePaths holds a map of the input item paths. The reference $sourceMetadata holds a map with all source-metadata, which can be referenced by their key. ($sourceMetadata.get(\"source\").get(\"metadata_xml\").content";
        Assert.assertEquals((Object)desc, (Object)option.getDescription());
        option = options.getOption("-m");
        Assert.assertNotNull((Object)option);
        Assert.assertFalse((String)"static metadata are optional", (boolean)option.isRequired());
        Assert.assertNull((Object)option.getValue());
        Assert.assertEquals((Object)"myKey>=<filePath", (Object)option.getArgName());
        desc = "Optional. The absolute path and name of text file(s) (e.g. global metadata, LUTs) to be included as ceres-metadata - Resource. Refer to as $myKey in velocity templates. ($myKey.content; $myKey.map.get(\"key\"), if it was a *.properties file or $myKey.path)";
        Assert.assertEquals((Object)desc, (Object)option.getDescription());
    }

    @Test
    public void testParseTemplateFiles() throws Exception {
        HashMap templateFiles = this.cliHandler.fetchTemplateFiles();
        Assert.assertEquals((long)2L, (long)templateFiles.size());
        Assert.assertEquals((Object)"/my/template/dir/veltemp.vm.txt", templateFiles.get("template1"));
        Assert.assertEquals((Object)"/my/template/dir/veltemp.vm.xml", templateFiles.get("template2"));
    }

    @Test
    public void testParseTemplateFilesWithIllegalArgumentFormat() throws Exception {
        this.command = new String[]{"-v", "/a/path/temp1.vm.txt", "-t", "bla/"};
        this.cliHandler = new CliHandler(this.command);
        try {
            this.cliHandler.fetchTemplateFiles();
            Assert.fail((String)"Do not reach this statement.");
        }
        catch (ParseException e) {
            Assert.fail((String)"Not this exception");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertEquals((Object)"Pattern for values of the option -v is: key=value", (Object)expected.getMessage());
        }
    }

    @Test
    public void testParseSourceItemFiles() throws Exception {
        HashMap sourceItemFiles = this.cliHandler.fetchSourceItemFiles();
        Assert.assertEquals((long)3L, (long)sourceItemFiles.size());
        Assert.assertEquals((Object)"foo/baa/prod.N1", sourceItemFiles.get("source1"));
        Assert.assertEquals((Object)"foo/bah/MER.N1", sourceItemFiles.get("source2"));
        Assert.assertEquals((Object)"foo/bar/ATS.N1", sourceItemFiles.get("source3"));
    }

    @Test
    public void testFetchSourceItemFiles() throws Exception {
        this.command = new String[]{"-v", "template1=/my/template/dir/veltemp.vm.txt", "-t", "/my/out/product.n1"};
        this.cliHandler = new CliHandler(this.command);
        HashMap sourceItemFiles = this.cliHandler.fetchSourceItemFiles();
        Assert.assertNotNull((Object)sourceItemFiles);
        Assert.assertEquals((long)0L, (long)sourceItemFiles.size());
    }

    @Test
    public void testParseTargetItemFile() throws Exception {
        String targetItemFile = this.cliHandler.fetchTargetItemFile();
        Assert.assertEquals((Object)"/my/out/product.n1", (Object)targetItemFile);
    }

    @Test
    public void testParseStaticMetadataTextFiles() throws Exception {
        HashMap metadataFile = this.cliHandler.fetchGlobalMetadataFiles();
        Assert.assertEquals((long)2L, (long)metadataFile.size());
        Assert.assertEquals((Object)"/root/dir/global-metadata.txt", metadataFile.get("meta1"));
        Assert.assertEquals((Object)"/root/dir/lut.properties", metadataFile.get("meta2"));
    }

    @Test
    public void testParseArguments() throws Exception {
        String[] arguments = this.cliHandler.fetchArguments();
        Assert.assertEquals((long)3L, (long)arguments.length);
        Assert.assertEquals((Object)"var1", (Object)arguments[0]);
        Assert.assertEquals((Object)"var2", (Object)arguments[1]);
        Assert.assertEquals((Object)"var3 var3a", (Object)arguments[2]);
    }

    @Test
    public void testPrintUsage() throws Exception {
    }
}

